/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.validation;

import fr.msimeon.mads.mads.CommInPlanType;
import fr.msimeon.mads.mads.Commodity;
import fr.msimeon.mads.mads.DataByHerdClass;
import fr.msimeon.mads.mads.DebtServFunc;
import fr.msimeon.mads.mads.Entity;
import fr.msimeon.mads.mads.Herd;
import fr.msimeon.mads.mads.HerdClass;
import fr.msimeon.mads.mads.HerdDataByCat;
import fr.msimeon.mads.mads.HerdInPlanType;
import fr.msimeon.mads.mads.IntakeItem;
import fr.msimeon.mads.mads.MadsPackage;
import fr.msimeon.mads.mads.Model;
import fr.msimeon.mads.mads.ParturitionItem;
import fr.msimeon.mads.mads.Plan;
import fr.msimeon.mads.mads.PlanInPlanType;
import fr.msimeon.mads.mads.PlanItem;
import fr.msimeon.mads.mads.TabYear;
import fr.msimeon.mads.mads.Table;
import fr.msimeon.mads.mads.TableType;
import fr.msimeon.mads.validation.AbstractMadsJavaValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.validation.Check;

public class MadsJavaValidator
extends AbstractMadsJavaValidator {
    @Check
    public void checkOCC(Model model) {
        double OCC = model.getOCC();
        if (OCC <= 0.0 | OCC > 100.0) {
            this.error("OCC must be > 0 and <= 100", (EStructuralFeature)MadsPackage.Literals.MODEL__OCC);
        }
    }

    @Check
    public void checkExchangeRate(Model model) {
        double ExchangeRate = model.getExchangeRate();
        if (ExchangeRate <= 0.0) {
            this.error("ExchangeRate must be > 0", (EStructuralFeature)MadsPackage.Literals.MODEL__EXCHANGE_RATE);
        }
    }

    @Check
    public void checkProjectLife(Model model) {
        Integer pLife = model.getProjectLife();
        if (pLife <= 0) {
            this.error("Project life must be > 0", (EStructuralFeature)MadsPackage.Literals.MODEL__PROJECT_LIFE);
        }
    }

    @Check
    public void checkDuration(HerdClass aClass) {
        int duration = aClass.getDuration();
        if (duration <= 0) {
            this.error("Age group duration must be > 0", (EStructuralFeature)MadsPackage.Literals.HERD_CLASS__DURATION);
        }
    }

    @Check
    public void checkInitSize(HerdClass aClass) {
        double size = aClass.getInitSize();
        if (size < 0.0) {
            this.error("Age group initial size must be >= 0", (EStructuralFeature)MadsPackage.Literals.HERD_CLASS__INIT_SIZE);
        }
    }

    @Check
    public void checkDataByHerdClass(DataByHerdClass dataByHerdClass) {
        HerdDataByCat dataByCat = (HerdDataByCat)dataByHerdClass.eContainer();
        EList<DataByHerdClass> data = dataByCat.getData();
        String[] names = new String[data.size()];
        int i = 0;
        while (i < data.size()) {
            names[i] = ((DataByHerdClass)data.get(i)).getClassRef().getName();
            ++i;
        }
        if (this.dulicatesInList(names).booleanValue()) {
            this.error("Cannot include a herd class reference more than once", (EStructuralFeature)MadsPackage.Literals.DATA_BY_HERD_CLASS__CLASS_REF);
        }
    }

    @Check
    public void checkIntakeItems(IntakeItem item) {
        EList<IntakeItem> data = ((Herd)item.eContainer()).getIntakeItems();
        String[] names = new String[data.size()];
        int i = 0;
        while (i < data.size()) {
            names[i] = ((IntakeItem)data.get(i)).getClassRef().getName();
            ++i;
        }
        if (this.dulicatesInList(names).booleanValue()) {
            this.error("Cannot include a herd class reference more than once", (EStructuralFeature)MadsPackage.Literals.INTAKE_ITEM__CLASS_REF);
        }
    }

    @Check
    public void checkParturitionItems(ParturitionItem item) {
        EList<ParturitionItem> data = ((Herd)item.eContainer()).getParturitionItems();
        String[] names = new String[data.size()];
        int i = 0;
        while (i < data.size()) {
            names[i] = ((ParturitionItem)data.get(i)).getClassRef().getName();
            ++i;
        }
        if (this.dulicatesInList(names).booleanValue()) {
            this.error("Cannot include a herd class reference more than once", (EStructuralFeature)MadsPackage.Literals.PARTURITION_ITEM__CLASS_REF);
        }
    }

    Boolean dulicatesInList(String[] data) {
        int i = 0;
        while (i < data.length) {
            int j = data.length - 1;
            while (j > i) {
                if (data[i].equals(data[j])) {
                    return true;
                }
                --j;
            }
            ++i;
        }
        return false;
    }

    @Check
    public void checkMaxSize(HerdClass aClass) {
        double size = aClass.getMaxSize();
        if (size < 0.0) {
            this.error("Age group maximum size must be >= 0", (EStructuralFeature)MadsPackage.Literals.HERD_CLASS__MAX_SIZE);
        }
    }

    @Check
    public void checkGraceOnInt(DebtServFunc dsF) {
        if (dsF.isSeparateGraceOnIt()) {
            int grace = dsF.getGrace();
            int graceOnInt = dsF.getGraceOnInt();
            if (graceOnInt > grace) {
                this.error("Grace on interest cannot be > grace", (EStructuralFeature)MadsPackage.Literals.DEBT_SERV_FUNC__GRACE_ON_INT);
            }
        }
    }

    @Check
    public void checkTableType(Table table) {
        if (table.getTableType() == TableType.BUDGET) {
            if (table.isTotals()) {
                this.warning("Table totals do not apply to BUDGET tables", (EStructuralFeature)MadsPackage.Literals.TABLE__TABLE_TYPE);
            }
            if (table.isAllColumns()) {
                this.warning("Table allColumns do not apply to BUDGET tables", (EStructuralFeature)MadsPackage.Literals.TABLE__TABLE_TYPE);
            }
        }
    }

    @Check
    public void checkTableYears(Table table) {
        Integer year1;
        EList<TabYear> years = table.getYears();
        int nb = years.size() + 1;
        Integer previous = year1 = Integer.valueOf(table.getYear1());
        Integer pLife = ((Model)EcoreUtil.getRootContainer((EObject)table)).getProjectLife();
        this.checkYear(year1, pLife);
        if (table.getTableType().toString().equals("budget") && nb > 2 | (nb == 2 && ((TabYear)table.getYears().get(0)).getSeparator().equals("~")) && ((TabYear)table.getYears().get(0)).getYear() - year1 > 1) {
            this.error("Budget Table years must be 2 values at most", (EStructuralFeature)MadsPackage.Literals.TABLE__YEARS);
        }
        for (TabYear tabyear : years) {
            Integer year = tabyear.getYear();
            this.checkYear(year, pLife);
            if (year <= previous) {
                this.error("Table years must be in increasing order", (EStructuralFeature)MadsPackage.Literals.TABLE__YEARS);
            }
            previous = year;
        }
    }

    private void checkYear(Integer year, Integer pLife) {
        if (year == 0) {
            this.error("Table years must be > 0", (EStructuralFeature)MadsPackage.Literals.TABLE__YEARS);
        } else if (year > pLife) {
            this.error("Table years must be within project life " + pLife, (EStructuralFeature)MadsPackage.Literals.TABLE__YEARS);
        }
    }

    @Check
    public void checkPlanItem(PlanItem planItem) {
        Entity entity = planItem.getPlanItemRef();
        if (entity != null && CommInPlanType.COMM_IN_PLAN_TYPE_NULL.equals((Object)planItem.getCommCalcType()) && PlanInPlanType.PLAN_IN_PLAN_TYPE_NULL.equals((Object)planItem.getPlanCalcType()) && HerdInPlanType.HERD_IN_PLAN_TYPE_NULL.equals((Object)planItem.getHerdCalcType())) {
            this.error("Please specify a result type", (EStructuralFeature)MadsPackage.Literals.PLAN_ITEM__PLAN_ITEM_REF);
        }
        if (!(entity instanceof Plan) && !PlanInPlanType.PLAN_IN_PLAN_TYPE_NULL.equals((Object)planItem.getPlanCalcType())) {
            this.error("keyword " + planItem.getPlanCalcType().getLiteral() + " is not allowed here", (EStructuralFeature)MadsPackage.Literals.PLAN_ITEM__PLAN_CALC_TYPE);
        }
        if (!(entity instanceof Herd) && !HerdInPlanType.HERD_IN_PLAN_TYPE_NULL.equals((Object)planItem.getHerdCalcType())) {
            this.error("keyword " + planItem.getHerdCalcType().getLiteral() + " is not allowed here", (EStructuralFeature)MadsPackage.Literals.PLAN_ITEM__HERD_CALC_TYPE);
        }
        if (!(entity instanceof Commodity) && !CommInPlanType.COMM_IN_PLAN_TYPE_NULL.equals((Object)planItem.getCommCalcType())) {
            this.error("keyword " + planItem.getCommCalcType().getLiteral() + " is not allowed here", (EStructuralFeature)MadsPackage.Literals.PLAN_ITEM__COMM_CALC_TYPE);
        }
        if (entity instanceof Plan) {
            Plan planRefPlan = (Plan)entity;
            Plan container = (Plan)planItem.eContainer();
            String containerName = container.getName();
            Boolean found = false;
            if ((found = this.scanPlan(planRefPlan, containerName, found)).booleanValue()) {
                this.error("A plan cannot include itself through nested plans", (EStructuralFeature)MadsPackage.Literals.PLAN_ITEM__PLAN_ITEM_REF);
            }
        }
    }

    private Boolean scanPlan(Plan planRefPlan, String containerName, Boolean found) {
        EcoreEList items = (EcoreEList)planRefPlan.getPlanItems();
        for (PlanItem anItem : items) {
            Plan anInnerPlan;
            String planItemName;
            Entity entity = anItem.getPlanItemRef();
            if (!(entity instanceof Plan) || (found = Boolean.valueOf((planItemName = (anInnerPlan = (Plan)entity).getName()).equals(containerName))).booleanValue()) continue;
            found = this.scanPlan(anInnerPlan, containerName, found);
        }
        return found;
    }
}

