/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;
import sun.java2d.pipe.Region;

public class WFileDialogPeer
extends WWindowPeer
implements FileDialogPeer {
    private WComponentPeer parent;
    private FilenameFilter fileFilter;
    private Vector<WWindowPeer> blockedWindows = new Vector();

    private static native void setFilterString(String var0);

    @Override
    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.fileFilter = filenameFilter;
    }

    boolean checkFilenameFilter(String string) {
        FileDialog fileDialog = (FileDialog)this.target;
        if (this.fileFilter == null) {
            return true;
        }
        File file = new File(string);
        return this.fileFilter.accept(new File(file.getParent()), file.getName());
    }

    WFileDialogPeer(FileDialog fileDialog) {
        super(fileDialog);
    }

    @Override
    void create(WComponentPeer wComponentPeer) {
        this.parent = wComponentPeer;
    }

    @Override
    protected void checkCreation() {
    }

    @Override
    void initialize() {
        this.setFilenameFilter(((FileDialog)this.target).getFilenameFilter());
    }

    private native void _dispose();

    @Override
    protected void disposeImpl() {
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    private native void _show();

    private native void _hide();

    @Override
    public void show() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WFileDialogPeer.this._show();
            }
        }).start();
    }

    @Override
    public void hide() {
        this._hide();
    }

    void setHWnd(long l) {
        if (this.hwnd == l) {
            return;
        }
        this.hwnd = l;
        for (WWindowPeer wWindowPeer : this.blockedWindows) {
            if (l != 0L) {
                wWindowPeer.modalDisable((Dialog)this.target, l);
                continue;
            }
            wWindowPeer.modalEnable((Dialog)this.target);
        }
    }

    void handleSelected(char[] cArray) {
        String[] stringArray = new String(cArray).split("\u0000");
        boolean bl = stringArray.length > 1;
        String string = null;
        String string2 = null;
        String[] stringArray2 = null;
        if (bl) {
            string = stringArray[0];
            stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            string2 = stringArray2[1];
        } else {
            int n = stringArray[0].lastIndexOf(File.separatorChar);
            if (n == -1) {
                string = "." + File.separator;
                string2 = stringArray[0];
            } else {
                string = stringArray[0].substring(0, n + 1);
                string2 = stringArray[0].substring(n + 1);
            }
            stringArray2 = new String[]{string2};
        }
        final FileDialog fileDialog = (FileDialog)this.target;
        AWTAccessor.FileDialogAccessor fileDialogAccessor = AWTAccessor.getFileDialogAccessor();
        fileDialogAccessor.setDirectory(fileDialog, string);
        fileDialogAccessor.setFile(fileDialog, string2);
        fileDialogAccessor.setFiles(fileDialog, string, stringArray2);
        WToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            @Override
            public void run() {
                fileDialog.hide();
            }
        });
    }

    void handleCancel() {
        final FileDialog fileDialog = (FileDialog)this.target;
        AWTAccessor.getFileDialogAccessor().setFile(fileDialog, null);
        AWTAccessor.getFileDialogAccessor().setFiles(fileDialog, null, null);
        WToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            @Override
            public void run() {
                fileDialog.hide();
            }
        });
    }

    void blockWindow(WWindowPeer wWindowPeer) {
        this.blockedWindows.add(wWindowPeer);
        if (this.hwnd != 0L) {
            wWindowPeer.modalDisable((Dialog)this.target, this.hwnd);
        }
    }

    void unblockWindow(WWindowPeer wWindowPeer) {
        this.blockedWindows.remove(wWindowPeer);
        if (this.hwnd != 0L) {
            wWindowPeer.modalEnable((Dialog)this.target);
        }
    }

    @Override
    public void blockWindows(List<Window> list) {
        for (Window window : list) {
            WWindowPeer wWindowPeer = (WWindowPeer)AWTAccessor.getComponentAccessor().getPeer(window);
            if (wWindowPeer == null) continue;
            this.blockWindow(wWindowPeer);
        }
    }

    @Override
    public native void toFront();

    @Override
    public native void toBack();

    @Override
    public void setAlwaysOnTop(boolean bl) {
    }

    @Override
    public void setDirectory(String string) {
    }

    @Override
    public void setFile(String string) {
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public void setResizable(boolean bl) {
    }

    @Override
    public void enable() {
    }

    @Override
    public void disable() {
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
    }

    public boolean handleEvent(Event event) {
        return false;
    }

    @Override
    public void setForeground(Color color) {
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public void setFont(Font font) {
    }

    @Override
    public void updateMinimumSize() {
    }

    @Override
    public void updateIconImages() {
    }

    public boolean requestFocus(boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause) {
        return false;
    }

    @Override
    void start() {
    }

    @Override
    public void beginValidate() {
    }

    @Override
    public void endValidate() {
    }

    void invalidate(int n, int n2, int n3, int n4) {
    }

    @Override
    public void addDropTarget(DropTarget dropTarget) {
    }

    @Override
    public void removeDropTarget(DropTarget dropTarget) {
    }

    @Override
    public void updateFocusableWindowState() {
    }

    @Override
    public void setZOrder(ComponentPeer componentPeer) {
    }

    private static native void initIDs();

    @Override
    public void applyShape(Region region) {
    }

    @Override
    public void setOpacity(float f) {
    }

    @Override
    public void setOpaque(boolean bl) {
    }

    public void updateWindow(BufferedImage bufferedImage) {
    }

    @Override
    public void createScreenSurface(boolean bl) {
    }

    @Override
    public void replaceSurfaceData() {
    }

    public boolean isMultipleMode() {
        FileDialog fileDialog = (FileDialog)this.target;
        return AWTAccessor.getFileDialogAccessor().isMultipleMode(fileDialog);
    }

    static {
        WFileDialogPeer.initIDs();
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("sun.awt.windows.awtLocalization");
                    return resourceBundle.getString("allFiles");
                }
                catch (MissingResourceException missingResourceException) {
                    return "All Files";
                }
            }
        });
        WFileDialogPeer.setFilterString(string);
    }
}

