/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.ui.contentassist;

import fr.msimeon.mads.mads.Commodity;
import fr.msimeon.mads.mads.Entity;
import fr.msimeon.mads.mads.Herd;
import fr.msimeon.mads.mads.HerdFeedItem;
import fr.msimeon.mads.mads.HerdPropItem;
import fr.msimeon.mads.mads.MadsPackage;
import fr.msimeon.mads.mads.Plan;
import fr.msimeon.mads.mads.PlanItem;
import fr.msimeon.mads.ui.contentassist.AbstractMadsProposalProvider;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.util.Strings;

public class MadsProposalProvider
extends AbstractMadsProposalProvider {
    public void completeKeyword(Keyword keyword, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject currItem = context.getCurrentModel();
        if (currItem instanceof PlanItem) {
            PlanItem item = (PlanItem)currItem;
            Entity entity = item.getPlanItemRef();
            EEnum eenum = this.getEEnum(keyword);
            if (entity instanceof Commodity || entity instanceof Plan || entity instanceof Herd) {
                this.acceptStringProposal("item = ID resType [ series of values ] or read function ; ", context, acceptor);
                if (keyword.getValue().equals("CommInPlanTypeNull") || keyword.getValue().equals("HerdInPlanTypeNull") || keyword.getValue().equals("PlanInPlanTypeNull")) {
                    return;
                }
                if (eenum == null) {
                    super.completeKeyword(keyword, context, acceptor);
                } else if (entity instanceof Commodity) {
                    if (MadsPackage.Literals.COMM_IN_PLAN_TYPE.equals(eenum)) {
                        super.completeKeyword(keyword, context, acceptor);
                    }
                } else if (entity instanceof Plan) {
                    if (MadsPackage.Literals.PLAN_IN_PLAN_TYPE.equals(eenum)) {
                        super.completeKeyword(keyword, context, acceptor);
                    }
                } else if (entity instanceof Herd && MadsPackage.Literals.HERD_IN_PLAN_TYPE.equals(eenum)) {
                    super.completeKeyword(keyword, context, acceptor);
                }
            }
        } else if (currItem instanceof Herd || currItem instanceof HerdFeedItem || currItem instanceof HerdPropItem) {
            EEnum eenum = this.getEEnum(keyword);
            if (keyword.getValue().equals("CommInPlanTypeNull")) {
                return;
            }
            if (eenum == null) {
                super.completeKeyword(keyword, context, acceptor);
            } else if (MadsPackage.Literals.COMM_IN_PLAN_TYPE.equals(eenum)) {
                super.completeKeyword(keyword, context, acceptor);
            }
        } else {
            super.completeKeyword(keyword, context, acceptor);
        }
    }

    private void acceptStringProposal(String proposalText, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String proposal = this.getValueConverter().toString((Object)proposalText, "STRING");
        ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(completionProposal);
    }

    EEnum getEEnum(Keyword keyword) {
        if (keyword.eContainer() instanceof EnumLiteralDeclaration) {
            return ((EnumLiteralDeclaration)keyword.eContainer()).getEnumLiteral().getEEnum();
        }
        return null;
    }

    @Override
    public void completeModel_Elements(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeModel_Elements(model, assignment, context, acceptor);
        String proposal = "Possible elements: commodity, herd, plan, script, table";
        proposal = this.getValueConverter().toString((Object)proposal, "STRING");
        ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(completionProposal);
    }

    @Override
    public void complete_Value(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String feature = this.getAssignedFeature(ruleCall);
        this.createProposal(context, acceptor, feature, ruleCall);
    }

    public void complete_INT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String feature = this.getAssignedFeature(ruleCall);
        this.createIntProposal(context, acceptor, ruleCall, feature, 1);
    }

    private void createIntProposal(ContentAssistContext context, ICompletionProposalAcceptor acceptor, RuleCall ruleCall, String feature, int i) {
        ICompletionProposal proposal;
        String proposalText;
        String displayText = proposalText = feature != null ? feature : Strings.toFirstUpper((String)ruleCall.getRule().getName().toLowerCase());
        if (feature != null) {
            displayText = String.valueOf(displayText) + " - " + ruleCall.getRule().getName();
        }
        if ((proposal = this.createCompletionProposal(proposalText, displayText, null, context)) instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal;
            configurable.setSelectionStart(configurable.getReplacementOffset());
            configurable.setSelectionLength(proposalText.length());
            configurable.setAutoInsertable(false);
            configurable.setSimpleLinkedMode(context.getViewer(), new char[]{'\t', ' '});
        }
        acceptor.accept(proposal);
    }

    @Override
    public void complete_SignedInt(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String feature = this.getAssignedFeature(ruleCall);
        this.createProposal(context, acceptor, feature, ruleCall);
    }

    @Override
    public void complete_ID(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String feature = this.getAssignedFeature(ruleCall);
        this.createProposal(context, acceptor, feature, ruleCall);
    }

    @Override
    public void complete_SEMI(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String proposalText = ";";
        EObject keyword = null;
        String displayText = proposalText;
        ICompletionProposal proposal = this.createCompletionProposal(proposalText, displayText, this.getImage(keyword), context);
        acceptor.accept(proposal);
    }

    private String getAssignedFeature(RuleCall call) {
        Assignment ass = GrammarUtil.containingAssignment((EObject)call);
        if (ass != null) {
            String result = ass.getFeature();
            if (result.equals(result.toLowerCase())) {
                result = Strings.toFirstUpper((String)result);
            }
            return result;
        }
        return null;
    }

    private void createProposal(ContentAssistContext context, ICompletionProposalAcceptor acceptor, String feature, RuleCall ruleCall) {
        ICompletionProposal proposal;
        String proposalText = feature != null ? feature : Strings.toFirstUpper((String)ruleCall.getRule().getName().toLowerCase());
        String displayText = proposalText = this.getValueConverter().toString((Object)proposalText, ruleCall.getRule().getName());
        if (feature != null) {
            displayText = String.valueOf(displayText) + " - " + ruleCall.getRule().getName();
        }
        if ((proposal = this.createCompletionProposal(proposalText, displayText, null, context)) instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal;
            configurable.setSelectionStart(configurable.getReplacementOffset() + 1);
            configurable.setSelectionLength(proposalText.length() - 2);
            configurable.setAutoInsertable(false);
            configurable.setSimpleLinkedMode(context.getViewer(), new char[]{proposalText.charAt(0), '\t'});
        }
        acceptor.accept(proposal);
    }
}

