/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.ui.labeling;

import com.google.inject.Inject;
import fr.msimeon.mads.mads.Command;
import fr.msimeon.mads.mads.Commodity;
import fr.msimeon.mads.mads.CommodityReference;
import fr.msimeon.mads.mads.DataByHerdClass;
import fr.msimeon.mads.mads.ExportCmd;
import fr.msimeon.mads.mads.Expr;
import fr.msimeon.mads.mads.FemaleHerdClass;
import fr.msimeon.mads.mads.FileSpec;
import fr.msimeon.mads.mads.Herd;
import fr.msimeon.mads.mads.HerdDataByCat;
import fr.msimeon.mads.mads.HerdFeedItem;
import fr.msimeon.mads.mads.HerdPropItem;
import fr.msimeon.mads.mads.HerdReference;
import fr.msimeon.mads.mads.Instruction;
import fr.msimeon.mads.mads.IntakeItem;
import fr.msimeon.mads.mads.MaleHerdClass;
import fr.msimeon.mads.mads.Model;
import fr.msimeon.mads.mads.ParturitionItem;
import fr.msimeon.mads.mads.Plan;
import fr.msimeon.mads.mads.PlanItem;
import fr.msimeon.mads.mads.Script;
import fr.msimeon.mads.mads.TabYear;
import fr.msimeon.mads.mads.Table;
import fr.msimeon.mads.mads.TableBlock;
import fr.msimeon.mads.mads.Variable;
import fr.msimeon.mads.mads.VariableReference;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

public class MadsLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    public MadsLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    String text(Model model) {
        return "Project: " + model.getProjectName() + " - " + model.getDataSetName();
    }

    String text(Commodity commodity) {
        return "Commodity " + commodity.getName();
    }

    String text(Plan plan) {
        return "Plan " + plan.getName();
    }

    String text(Table table) {
        return "Table " + table.getName();
    }

    String text(Script script) {
        return "Script " + script.getName();
    }

    String text(Herd herd) {
        return "Herd " + herd.getName();
    }

    String text(PlanItem item) {
        Object entity = null;
        entity = item.getPlanItemRef() != null ? item.getPlanItemRef() : item.getScriptRef();
        String label = "";
        label = entity instanceof Commodity ? "Commodity " + item.getCommCalcType() : (entity instanceof Plan ? "Plan " + item.getPlanCalcType() : (entity instanceof Herd ? "Herd " + item.getHerdCalcType() : "Script"));
        return String.valueOf(label) + " " + entity.getName();
    }

    String text(FemaleHerdClass item) {
        return "Female class " + item.getName();
    }

    String text(MaleHerdClass item) {
        return "Male class " + item.getName();
    }

    String text(ParturitionItem item) {
        return "Parturition Item " + item.getClassRef().getName();
    }

    String text(IntakeItem item) {
        return "Intake Item " + item.getClassRef().getName();
    }

    String text(HerdFeedItem item) {
        return "Feed Item " + item.getCommRef().getName();
    }

    String text(HerdPropItem item) {
        return "Proportional Item " + item.getCommRef().getName();
    }

    String text(HerdDataByCat item) {
        return "Quantity per Class ";
    }

    String text(DataByHerdClass item) {
        return "Herd Class " + item.getClassRef().getName();
    }

    String text(TabYear item) {
        if (item.getSeparator().equals(",")) {
            return "Year";
        }
        return "Years range";
    }

    String text(TableBlock item) {
        return "Block " + item.getTitle();
    }

    String text(Command item) {
        return "Command";
    }

    String text(FileSpec item) {
        return "File Specification";
    }

    String text(ExportCmd item) {
        return "Export Command ";
    }

    String text(Variable item) {
        return "Variable declaration: " + item.getName();
    }

    String text(Instruction item) {
        String ret = "Instruction ";
        ret = item.getVar() != null ? String.valueOf(ret) + "var " + item.getVar().getName() : String.valueOf(ret) + item.getVRef().getVarRef().getName();
        return ret;
    }

    String text(Expr item) {
        return "Expression";
    }

    String text(VariableReference item) {
        return "Variable reference ";
    }

    String text(CommodityReference item) {
        return "Commodity reference " + item.getCommRef().getName() + " " + item.getCommResType();
    }

    String text(HerdReference item) {
        return "Herd reference " + item.getHerdRef().getName() + " " + item.getHerdResType();
    }
}

