/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IReferenceUpdater;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.impl.ReferenceDescriptionSorter;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReferenceUpdater
implements IReferenceUpdater {
    @Inject
    private ReferenceDescriptionSorter sorter;
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;

    @Override
    public void createReferenceUpdates(ElementRenameArguments elementRenameArguments, Iterable<IReferenceDescription> referenceDescriptions, IRefactoringUpdateAcceptor updateAcceptor, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.beginTask("Sort references by project", 1);
        Multimap<IProject, IReferenceDescription> project2references = this.sorter.sortByProject(referenceDescriptions);
        SubMonitor allProjectsProgress = progress.newChild(98).setWorkRemaining(project2references.keySet().size());
        for (IProject project : project2references.keySet()) {
            if (allProjectsProgress.isCanceled()) break;
            Multimap<URI, IReferenceDescription> resource2references = this.sorter.sortByResource(project2references.get((Object)project));
            ResourceSet resourceSet = this.resourceSetProvider.get(project);
            StatusWrapper status = updateAcceptor.getRefactoringStatus();
            this.createClusteredReferenceUpdates(elementRenameArguments, resource2references, resourceSet, updateAcceptor, status, (IProgressMonitor)allProjectsProgress.newChild(1));
        }
    }

    protected void createClusteredReferenceUpdates(ElementRenameArguments elementRenameArguments, Multimap<URI, IReferenceDescription> resource2references, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor, StatusWrapper status, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(resource2references.size() + 1));
        if (this.loadTargetResources(resourceSet, elementRenameArguments, status, (IProgressMonitor)progress.newChild(1))) {
            HashSet targetResources = Sets.newHashSet((Iterable)resourceSet.getResources());
            if (this.getClusterSize() > 0) {
                HashMultimap cluster = HashMultimap.create();
                for (URI referringResourceURI : resource2references.keySet()) {
                    cluster.putAll((Object)referringResourceURI, (Iterable)resource2references.get((Object)referringResourceURI));
                    if (cluster.keySet().size() != this.getClusterSize()) continue;
                    this.unloadNonTargetResources(resourceSet, targetResources);
                    this.createReferenceUpdatesForCluster(elementRenameArguments, (Multimap<URI, IReferenceDescription>)cluster, resourceSet, updateAcceptor, status, (IProgressMonitor)progress.newChild(cluster.size()));
                    cluster.clear();
                }
                if (!cluster.isEmpty()) {
                    this.unloadNonTargetResources(resourceSet, targetResources);
                    this.createReferenceUpdatesForCluster(elementRenameArguments, (Multimap<URI, IReferenceDescription>)cluster, resourceSet, updateAcceptor, status, (IProgressMonitor)progress.newChild(cluster.size()));
                }
            } else {
                this.createReferenceUpdatesForCluster(elementRenameArguments, resource2references, resourceSet, updateAcceptor, status, (IProgressMonitor)progress);
            }
        }
    }

    protected void unloadNonTargetResources(ResourceSet resourceSet, Set<Resource> targetResources) {
        for (Resource resource : Lists.newArrayList((Iterable)resourceSet.getResources())) {
            if (targetResources.contains(resource)) continue;
            resource.unload();
            resourceSet.getResources().remove((Object)resource);
        }
    }

    protected int getClusterSize() {
        return 20;
    }

    protected void createReferenceUpdatesForCluster(ElementRenameArguments elementRenameArguments, Multimap<URI, IReferenceDescription> resource2references, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor, StatusWrapper status, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List<URI> unloadableResources = this.loadReferringResources(resourceSet, resource2references.keySet(), status, (IProgressMonitor)progress.newChild(10));
        for (URI unloadableResouce : unloadableResources) {
            resource2references.removeAll((Object)unloadableResouce);
        }
        List<IReferenceDescription> unresolvableReferences = this.resolveReferenceProxies(resourceSet, resource2references.values(), status, (IProgressMonitor)progress.newChild(10));
        for (IReferenceDescription unresolvableReference : unresolvableReferences) {
            URI unresolvableReferringResource = unresolvableReference.getSourceEObjectUri().trimFragment();
            resource2references.remove((Object)unresolvableReferringResource, (Object)unresolvableReference);
        }
        elementRenameArguments.getRenameStrategy().applyDeclarationChange(elementRenameArguments.getNewName(), resourceSet);
        this.createReferenceUpdates(elementRenameArguments, resource2references, resourceSet, updateAcceptor, (IProgressMonitor)progress.newChild(80));
        elementRenameArguments.getRenameStrategy().revertDeclarationChange(resourceSet);
    }

    protected List<IReferenceDescription> resolveReferenceProxies(ResourceSet resourceSet, Collection<IReferenceDescription> values, StatusWrapper status, IProgressMonitor monitor) {
        ArrayList unresolvedDescriptions = null;
        for (IReferenceDescription referenceDescription : values) {
            EObject sourceEObject = resourceSet.getEObject(referenceDescription.getSourceEObjectUri(), false);
            if (sourceEObject == null) {
                this.handleCannotLoadReferringElement(referenceDescription, status);
            } else {
                EObject resolvedReference = this.resolveReference(sourceEObject, referenceDescription);
                if (resolvedReference != null && !resolvedReference.eIsProxy()) continue;
                this.handleCannotResolveExistingReference(sourceEObject, referenceDescription, status);
            }
            if (unresolvedDescriptions == null) {
                unresolvedDescriptions = Lists.newArrayList();
            }
            unresolvedDescriptions.add(referenceDescription);
        }
        return unresolvedDescriptions == null ? Collections.emptyList() : unresolvedDescriptions;
    }

    protected EObject resolveReference(EObject referringElement, IReferenceDescription referenceDescription) {
        Object resolvedValue = referringElement.eGet((EStructuralFeature)referenceDescription.getEReference());
        if (referenceDescription.getEReference().isMany()) {
            List list = (List)resolvedValue;
            resolvedValue = list.get(referenceDescription.getIndexInList());
        }
        return (EObject)resolvedValue;
    }

    protected void handleCannotLoadReferringElement(IReferenceDescription referenceDescription, StatusWrapper status) {
        status.add(3, "Cannot find referring element {0}.\nMaybe the index is be corrupt. Consider a rebuild.", referenceDescription.getSourceEObjectUri());
    }

    protected void handleCannotResolveExistingReference(EObject sourceEObject, IReferenceDescription referenceDescription, StatusWrapper status) {
        status.add(3, "Cannot resolve existing reference.\nMaybe the index is be corrupt. Consider a rebuild.", referenceDescription.getSourceEObjectUri());
    }

    protected abstract void createReferenceUpdates(ElementRenameArguments var1, Multimap<URI, IReferenceDescription> var2, ResourceSet var3, IRefactoringUpdateAcceptor var4, IProgressMonitor var5);

    protected boolean loadTargetResources(ResourceSet resourceSet, ElementRenameArguments elementRenameArguments, StatusWrapper status, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Loading target resource", (int)Iterables.size(elementRenameArguments.getRenamedElementURIs()));
        boolean isSuccess = true;
        for (URI renamedElementURI : elementRenameArguments.getRenamedElementURIs()) {
            EObject renamedElement = resourceSet.getEObject(renamedElementURI, true);
            if (renamedElement == null || renamedElement.eIsProxy()) {
                status.add(3, "Cannot load target element {0}.", renamedElementURI);
                isSuccess = false;
            }
            progress.worked(1);
        }
        return isSuccess;
    }

    protected List<URI> loadReferringResources(ResourceSet resourceSet, Iterable<URI> referringResourceURIs, StatusWrapper status, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Loading referencing resources", (int)Iterables.size(referringResourceURIs));
        ArrayList unloadableResources = null;
        for (URI referringResourceURI : referringResourceURIs) {
            Resource referringResource = resourceSet.getResource(referringResourceURI, true);
            if (referringResource == null) {
                status.add(3, "Could not load referring resource ", referringResourceURI);
                if (unloadableResources == null) {
                    unloadableResources = Lists.newArrayList();
                }
                unloadableResources.add(referringResourceURI);
            }
            progress.worked(1);
        }
        return unloadableResources == null ? Collections.emptyList() : unloadableResources;
    }
}

