/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.calc;

import fr.msimeon.mads.mads.CommInPlanType;
import fr.msimeon.mads.mads.CommResType;
import fr.msimeon.mads.mads.Command;
import fr.msimeon.mads.mads.Commodity;
import fr.msimeon.mads.mads.Entity;
import fr.msimeon.mads.mads.ExportCmd;
import fr.msimeon.mads.mads.Herd;
import fr.msimeon.mads.mads.HerdClass;
import fr.msimeon.mads.mads.HerdDetailedResType;
import fr.msimeon.mads.mads.HerdResType;
import fr.msimeon.mads.mads.Instruction;
import fr.msimeon.mads.mads.Model;
import fr.msimeon.mads.mads.Plan;
import fr.msimeon.mads.mads.PlanInPlanType;
import fr.msimeon.mads.mads.PlanItem;
import fr.msimeon.mads.mads.ReadFunc;
import fr.msimeon.mads.mads.ScriptItem;
import fr.msimeon.mads.mads.TabYear;
import fr.msimeon.mads.mads.Table;
import fr.msimeon.mads.mads.TableBlock;
import fr.msimeon.mads.mads.TableItem;
import fr.msimeon.mads.mads.TableType;
import fr.msimeon.mads.mads.impl.AtomIDImpl;
import fr.msimeon.mads.mads.impl.CommandImpl;
import fr.msimeon.mads.mads.impl.CommodityImpl;
import fr.msimeon.mads.mads.impl.ExportCmdImpl;
import fr.msimeon.mads.mads.impl.HerdImpl;
import fr.msimeon.mads.mads.impl.InstructionImpl;
import fr.msimeon.mads.mads.impl.ModelImpl;
import fr.msimeon.mads.mads.impl.PlanImpl;
import fr.msimeon.mads.mads.impl.ScriptImpl;
import fr.msimeon.mads.mads.impl.TableBlockImpl;
import fr.msimeon.mads.mads.impl.TableImpl;
import fr.msimeon.mads.mads.impl.VariableImpl;
import fr.msimeon.mads.runModel.calc.Expression;
import fr.msimeon.mads.runModel.calc.Functions;
import fr.msimeon.mads.runModel.calc.HerdModel;
import fr.msimeon.mads.runModel.calc.InOut;
import fr.msimeon.mads.runModel.calc.PlanResults;
import fr.msimeon.mads.runModel.calc.Results;
import fr.msimeon.mads.runModel.calc.TimeSeries;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.IDocument;

public class Calc {
    public static void calcPlan(ModelImpl model, PlanImpl plan, int numberOfPlans, IDocument doc, Boolean isHtml) {
        Results results = new Results(numberOfPlans * 4 / 3);
        String[] headers = new String[4];
        headers[0] = model.getCountryName();
        headers[1] = model.getProjectName();
        headers[2] = "Current plan: " + plan.getLabel();
        InOut.out.println("\n" + headers[0] + " - " + headers[1] + "\n" + headers[2]);
        InOut.outputHeaders(headers, isHtml, doc);
        PlanResults planResults = Calc.calcResults(plan, model.getProjectLife(), model.getOCC(), results, doc, isHtml, headers);
        Calc.processCommands(model, plan, results, doc, isHtml);
        planResults.listOut();
    }

    public static PlanResults calcResults(PlanImpl plan, int pLife, Double oCC, Results results, IDocument doc, Boolean isHtml, String[] headers) {
        String planId = plan.getName();
        PlanResults currentPlanResults = results.getPlanResults(planId);
        if (currentPlanResults != null) {
            return currentPlanResults;
        }
        currentPlanResults = new PlanResults();
        EList planItems = plan.getPlanItems();
        for (PlanItem item : planItems) {
            Entity entity = item.getPlanItemRef();
            if (entity == null) continue;
            TimeSeries level = new TimeSeries(pLife);
            if (item.getValues().isEmpty()) {
                ReadFunc readfunc = item.getLevelvalues();
                if (readfunc != null) {
                    level = Calc.getReadValues(readfunc, pLife);
                }
            } else {
                level.setValues((EList<Double>)item.getValues());
            }
            if (entity instanceof Plan) {
                PlanImpl innerPlan = (PlanImpl)entity;
                PlanResults innerResults = Calc.calcResults(innerPlan, pLife, oCC, results, doc, isHtml, headers);
                PlanInPlanType pType = item.getPlanCalcType();
                currentPlanResults.addPlanResults(innerResults, pType, level);
                continue;
            }
            if (entity instanceof Herd) {
                HerdImpl herd = (HerdImpl)entity;
                HerdModel herdModel = new HerdModel(herd, pLife);
                if (doc != null) {
                    herdModel.listOut();
                }
                herdModel.evaluate(currentPlanResults, level);
                continue;
            }
            if (!(entity instanceof Commodity)) continue;
            CommInPlanType calcType = item.getCommCalcType();
            CommodityImpl comm = (CommodityImpl)entity;
            Calc.setCommodityResults(comm, calcType, level, currentPlanResults);
        }
        for (PlanItem item1 : planItems) {
            if (item1.getScriptRef() == null) continue;
            ScriptImpl script = (ScriptImpl)item1.getScriptRef();
            EList scriptItems = script.getScriptItems();
            for (ScriptItem scriptItem : scriptItems) {
                Boolean isLocal;
                String varName;
                if (scriptItem instanceof Command || scriptItem instanceof ExportCmd) {
                    currentPlanResults.addCommand(scriptItem);
                    continue;
                }
                if (!(scriptItem instanceof Instruction)) continue;
                InstructionImpl instruction = (InstructionImpl)scriptItem;
                if (instruction.getVar() == null) {
                    varName = instruction.getVRef().getVarRef().getName();
                    isLocal = instruction.getVRef().getVarRef().isLocal();
                } else {
                    varName = instruction.getVar().getName();
                    isLocal = instruction.getVar().isLocal();
                }
                Expression expression = new Expression(instruction.getInstr(), pLife, oCC, doc, isHtml, headers);
                TimeSeries res = expression.evaluate(currentPlanResults);
                if (isLocal.booleanValue()) {
                    currentPlanResults.putLocalVarResult(varName, res);
                    continue;
                }
                currentPlanResults.putGlobalVarResult(varName, res);
            }
        }
        results.putPlanResults(plan.getName(), currentPlanResults);
        return currentPlanResults;
    }

    public static void setCommodityResults(CommodityImpl comm, CommInPlanType calcType, TimeSeries quantities, PlanResults planResults) {
        CommResType vResType;
        CommResType qResType;
        int signCoeff;
        String commID = comm.getName();
        double price = comm.getPrice();
        if (calcType == CommInPlanType.AVAIL) {
            signCoeff = 1;
            price = 0.0;
            qResType = CommResType.AVAIL_Q;
            vResType = CommResType.AVAIL_V;
        } else if (calcType == CommInPlanType.PROD) {
            qResType = CommResType.PROD_Q;
            vResType = CommResType.PROD_V;
            signCoeff = 1;
        } else {
            qResType = CommResType.CONS_Q;
            vResType = CommResType.CONS_V;
            signCoeff = -1;
        }
        planResults.putCommodityResult(commID, qResType, quantities);
        TimeSeries signedLevel = quantities.multValues(signCoeff);
        planResults.putCommodityResult(commID, CommResType.BAL_Q, signedLevel);
        TimeSeries values = quantities.multValues(price);
        planResults.putCommodityResult(commID, vResType, values);
        TimeSeries signedValues = values.multValues(signCoeff);
        planResults.putCommodityResult(commID, CommResType.BAL_V, signedValues);
    }

    public static TimeSeries getReadValues(ReadFunc readfunc, int pLife) {
        String fSpec = readfunc.getFileSpec().getFileSpec();
        String vName = readfunc.getRvar();
        String tName = readfunc.getTable();
        return Functions.read(vName, tName, fSpec, pLife);
    }

    static void processCommands(ModelImpl model, PlanImpl plan, Results results, IDocument doc, Boolean isHtml) {
        String planName = plan.getName();
        int pLife = model.getProjectLife();
        PlanResults planResults = results.getPlanResults(planName);
        Iterable<ScriptItem> commands = planResults.getCommands();
        for (ScriptItem command : commands) {
            TableImpl table;
            String text;
            CommandImpl cmd;
            if (command instanceof Command) {
                CommResType resType;
                cmd = (CommandImpl)command;
                String label = cmd.getLabel();
                if (cmd.getCommItem() != null) {
                    CommodityImpl comm = (CommodityImpl)cmd.getCommItem().getCommRef();
                    resType = cmd.getCommItem().getCommResType();
                    if (label == null) {
                        label = String.valueOf(comm.getLabel()) + " " + resType.toString();
                    }
                    TimeSeries res = planResults.getCommodityResult(comm.getName(), resType);
                    InOut.outputTS(res, label, doc, isHtml);
                    continue;
                }
                if (cmd.getHerdItem() != null) {
                    HerdImpl herd = (HerdImpl)cmd.getHerdItem().getHerdRef();
                    resType = cmd.getHerdItem().getHerdResType();
                    HerdDetailedResType detResType = cmd.getHerdItem().getHerdDetailedResType();
                    String hClass = null;
                    HerdClass classRef = cmd.getHerdItem().getClassRef();
                    if (classRef != null) {
                        hClass = classRef.getName();
                    }
                    if (label == null) {
                        label = resType != null ? String.valueOf(herd.getLabel()) + " " + resType.toString() : String.valueOf(herd.getLabel()) + " " + detResType.toString() + " " + hClass;
                    }
                    TimeSeries res = planResults.getHerdResult(herd.getName(), (HerdResType)resType, detResType, hClass);
                    InOut.outputTS(res, label, doc, isHtml);
                    continue;
                }
                if (cmd.getVarRef() != null) {
                    VariableImpl var = (VariableImpl)cmd.getVarRef().getVarRef();
                    TimeSeries res = var.isLocal() ? planResults.getLocalVarResult(var.getName()) : planResults.getGlobalVarResult(var.getName());
                    if (label == null && (label = var.getLabel()) == null) {
                        label = var.getName();
                    }
                    InOut.outputTS(res, label, doc, isHtml);
                    continue;
                }
                TableImpl table2 = (TableImpl)cmd.getTableRef();
                TableType tType = table2.getTableType();
                if (tType == TableType.BUDGET) {
                    Calc.setBudgetTable(table2, (Model)model, (Plan)plan, label, results, doc, isHtml, false, null, null);
                    continue;
                }
                Calc.setYrlistTable(table2, (Model)model, (Plan)plan, label, results, doc, isHtml, false, null, null);
                continue;
            }
            cmd = (ExportCmdImpl)command;
            String worksheetName = cmd.getWorksheet();
            String fileSpec = cmd.getFileRef().getFileSpec();
            if (InOut.checkODSFile(fileSpec, text = (table = (TableImpl)cmd.getTabRef()) == null ? "Time Series" : "Table") != 0) continue;
            if (table == null) {
                AtomIDImpl atomID = (AtomIDImpl)cmd.getAtomRef();
                String dataID = cmd.getData();
                TimeSeries ts = Expression.getAtomIDValues(atomID, planResults, pLife);
                InOut.exportTS(ts, dataID, worksheetName, fileSpec);
                continue;
            }
            TableType tType = table.getTableType();
            String label = cmd.getLabel();
            if (tType == TableType.BUDGET) {
                Calc.setBudgetTable(table, (Model)model, (Plan)plan, label, results, doc, isHtml, true, worksheetName, fileSpec);
                continue;
            }
            Calc.setYrlistTable(table, (Model)model, (Plan)plan, label, results, doc, isHtml, true, worksheetName, fileSpec);
        }
    }

    static void setYrlistTable(TableImpl table, Model model, Plan plan, String label, Results results, IDocument doc, Boolean isHtml, Boolean export, String worksheetName, String fileSpec) {
        int nbyears;
        String[] headers = Calc.getTableHeaders(table, model, plan, label);
        int pLife = model.getProjectLife();
        ArrayList<Integer> tYears = Calc.getYears((Table)table);
        TableBodyStructure structure = new TableBodyStructure(table, isHtml);
        PlanResults planResults = results.getPlanResults(plan.getName());
        ArrayList<TimeSeries> lineValues = Calc.getYrlistValues((Table)table, planResults, pLife);
        int nbLines = lineValues.size();
        int nbcols = nbyears = tYears.size();
        boolean isTotals = table.isTotals();
        if (isTotals) {
            ++nbcols;
        }
        double tScale = table.getTabScale();
        double lineTotal = 0.0;
        if (tScale == 0.0) {
            tScale = 1.0;
        }
        double[][] values = new double[nbLines][nbcols];
        int lineNb = 0;
        while (lineNb < nbLines) {
            double[] aLineValues = lineValues.get(lineNb).getValues();
            int year = 0;
            while (year < nbyears) {
                values[lineNb][year] = aLineValues[tYears.get(year)] * tScale;
                ++year;
            }
            if (isTotals) {
                int yr = tYears.get(0);
                while (yr <= tYears.get(nbyears - 1)) {
                    lineTotal += aLineValues[yr] * tScale;
                    ++yr;
                }
                values[lineNb][nbyears] = lineTotal;
            }
            ++lineNb;
        }
        boolean[] skipYear = new boolean[nbyears];
        if (nbyears == pLife && !table.isAllColumns()) {
            int yr = pLife - 1;
            while (yr > 0) {
                skipYear[yr] = true;
                int line = 0;
                while (line < nbLines) {
                    if (values[line][yr] != values[line][yr - 1]) {
                        skipYear[yr] = false;
                        break;
                    }
                    ++line;
                }
                --yr;
            }
        }
        if (export.booleanValue()) {
            if (isHtml.booleanValue()) {
                structure.adjust();
            }
            InOut.exportTable(headers, tYears, structure.lineLabels, structure.footnotes, structure.decDigits, structure.isLineTitle, values, tScale, isTotals, table.getColWidth(), skipYear, null, worksheetName, fileSpec);
        } else if (isHtml.booleanValue()) {
            InOut.outputTable_html(headers, tYears, structure.lineLabels, structure.footnotes, structure.decDigits, structure.isLineTitle, values, tScale, isTotals, skipYear, null, doc);
        } else {
            InOut.outputTable_plain(headers, tYears, structure.lineLabels, structure.footnotes, structure.decDigits, structure.isLineTitle, values, tScale, isTotals, table.getColWidth(), skipYear, null, doc);
        }
    }

    static void setBudgetTable(TableImpl table, Model model, Plan plan, String label, Results results, IDocument doc, Boolean isHtml, Boolean export, String worksheetName, String fileSpec) {
        int pLife = model.getProjectLife();
        String[] headers = Calc.getTableHeaders(table, model, plan, label);
        ArrayList<Integer> tYears = Calc.getYears((Table)table);
        ArrayList<PlanImpl> innerPlans = new ArrayList<PlanImpl>();
        ArrayList<String> innerPlansLabels = new ArrayList<String>();
        for (PlanItem item : plan.getPlanItems()) {
            Entity entity = item.getPlanItemRef();
            if (entity == null || !(entity instanceof Plan)) continue;
            PlanImpl innerPlan = (PlanImpl)entity;
            innerPlans.add(innerPlan);
            innerPlansLabels.add(innerPlan.getLabel());
        }
        int nbInnerPlans = innerPlans.size();
        int i = 1;
        while (i < nbInnerPlans) {
            tYears.add(tYears.get(0));
            tYears.add(tYears.get(1));
            ++i;
        }
        TableBodyStructure structure = new TableBodyStructure(table, isHtml);
        int nbyears = tYears.size();
        int nbLines = structure.decDigits.size();
        double tScale = table.getTabScale();
        if (tScale == 0.0) {
            tScale = 1.0;
        }
        double[][] values = Calc.getBudgetValues((Table)table, innerPlans, tYears, results, nbLines, pLife);
        boolean[] skipYear = new boolean[nbyears];
        if (export.booleanValue()) {
            if (isHtml.booleanValue()) {
                structure.adjust();
            }
            InOut.exportTable(headers, tYears, structure.lineLabels, structure.footnotes, structure.decDigits, structure.isLineTitle, values, tScale, false, table.getColWidth(), skipYear, innerPlansLabels, worksheetName, fileSpec);
        } else if (isHtml.booleanValue()) {
            InOut.outputTable_html(headers, tYears, structure.lineLabels, structure.footnotes, structure.decDigits, structure.isLineTitle, values, tScale, false, skipYear, innerPlansLabels, doc);
        } else {
            InOut.outputTable_plain(headers, tYears, structure.lineLabels, structure.footnotes, structure.decDigits, structure.isLineTitle, values, tScale, false, table.getColWidth(), skipYear, innerPlansLabels, doc);
        }
    }

    static double[][] getBudgetValues(Table table, ArrayList<PlanImpl> innerPlans, ArrayList<Integer> tYears, Results results, int nbLines, int pLife) {
        int nbInnerPlans = innerPlans.size();
        int nbYears = tYears.size() / nbInnerPlans;
        PlanResults[] planResults = new PlanResults[nbInnerPlans];
        int planIndex = 0;
        while (planIndex < nbInnerPlans) {
            planResults[planIndex] = results.getPlanResults(innerPlans.get(planIndex).getName());
            ++planIndex;
        }
        double[][] values = new double[nbLines][tYears.size()];
        EList blocks = table.getTableBlocks();
        int lineIndex = 0;
        for (TableBlock ablock : blocks) {
            TableBlockImpl block = (TableBlockImpl)ablock;
            double[] subTotal = new double[tYears.size()];
            for (TableItem item : block.getTableItems()) {
                int planIndex2 = 0;
                while (planIndex2 < nbInnerPlans) {
                    double value;
                    TimeSeries lineTS = Expression.getTableItemValues(item, planResults[planIndex2], pLife);
                    int yr1 = nbYears == 1 ? planIndex2 : planIndex2 * 2;
                    values[lineIndex][yr1] = value = lineTS.getValues()[tYears.get(0)];
                    int n = yr1;
                    subTotal[n] = subTotal[n] + value;
                    if (nbYears == 2) {
                        values[lineIndex][yr1 + 1] = value = lineTS.getValues()[tYears.get(1)];
                        int n2 = yr1 + 1;
                        subTotal[n2] = subTotal[n2] + value;
                    }
                    ++planIndex2;
                }
                ++lineIndex;
            }
            if (!block.isBlocktotals()) continue;
            int yr = 0;
            while (yr < tYears.size()) {
                values[lineIndex][yr] = subTotal[yr];
                ++yr;
            }
            ++lineIndex;
        }
        return values;
    }

    static ArrayList<TimeSeries> getYrlistValues(Table table, PlanResults planResults, int pLife) {
        ArrayList<TimeSeries> lineTSs = new ArrayList<TimeSeries>();
        EList blocks = table.getTableBlocks();
        for (TableBlock ablock : blocks) {
            TableBlockImpl block = (TableBlockImpl)ablock;
            TimeSeries subTotalTS = new TimeSeries(pLife);
            for (TableItem item : block.getTableItems()) {
                TimeSeries lineTS = Expression.getTableItemValues(item, planResults, pLife);
                subTotalTS = subTotalTS.addValues(lineTS);
                lineTSs.add(lineTS);
            }
            if (!block.isBlocktotals()) continue;
            lineTSs.add(subTotalTS);
        }
        return lineTSs;
    }

    static String[] getTableHeaders(TableImpl table, Model model, Plan plan, String label) {
        if (label == null) {
            label = table.getLabel();
        }
        EList titles = table.getTitles();
        int nbTitles = titles.size();
        String[] headers = new String[5 + nbTitles];
        headers[0] = String.valueOf(model.getCountryName()) + " - " + model.getProjectName();
        headers[1] = model.getDataSetName();
        headers[2] = model.getCurrency();
        headers[3] = plan.getLabel();
        headers[4] = label;
        if (nbTitles >= 0) {
            int i = 0;
            while (i < nbTitles) {
                headers[i + 5] = (String)titles.get(i);
                ++i;
            }
        }
        return headers;
    }

    static ArrayList<Integer> getYears(Table table) {
        ArrayList<Integer> tYears = new ArrayList<Integer>();
        int currYear = table.getYear1();
        tYears.add(currYear);
        for (TabYear year : table.getYears()) {
            int nextYear = year.getYear();
            if (year.getSeparator().equals(",")) {
                tYears.add(nextYear);
            } else {
                int i = currYear + 1;
                while (i <= nextYear) {
                    tYears.add(i);
                    ++i;
                }
            }
            currYear = nextYear;
        }
        return tYears;
    }

    static class TableBodyStructure {
        ArrayList<String> lineLabels = new ArrayList();
        ArrayList<String> footnotes = new ArrayList();
        ArrayList<Integer> decDigits = new ArrayList();
        ArrayList<Boolean> isLineTitle = new ArrayList();

        TableBodyStructure(TableImpl table, Boolean isHtml) {
            int tableDecDigits = 2;
            if (table.isDecDigitsSet()) {
                tableDecDigits = table.getDecDigits();
            }
            int footnoteNbr = 0;
            EList blocks = table.getTableBlocks();
            for (TableBlock ablock : blocks) {
                String title;
                TableBlockImpl block = (TableBlockImpl)ablock;
                int blockDecDigits = tableDecDigits;
                if (block.isDecDigitsSet()) {
                    blockDecDigits = block.getDecDigits();
                }
                if ((title = block.getTitle()) != null) {
                    this.isLineTitle.add(true);
                    this.lineLabels.add(title);
                }
                for (TableItem item : block.getTableItems()) {
                    String itemLabel = item.getLabel() != null ? item.getLabel() : Expression.getTableItemLabel(item);
                    if (item.isDecDigitsSet()) {
                        this.decDigits.add(item.getDecDigits());
                    } else {
                        this.decDigits.add(blockDecDigits);
                    }
                    if (item.getFootNote() != null) {
                        ++footnoteNbr;
                        String footnote = item.getFootNote();
                        if (isHtml.booleanValue()) {
                            itemLabel = String.format("%1s &lt;%1d&gt;", itemLabel, footnoteNbr);
                            footnote = String.format("&lt;%1d&gt; %1s", footnoteNbr, footnote);
                        } else {
                            itemLabel = String.format("%1s <%1d>", itemLabel, footnoteNbr);
                            footnote = String.format("<%1d> %1s", footnoteNbr, footnote);
                        }
                        this.footnotes.add(footnote);
                    }
                    this.isLineTitle.add(false);
                    this.lineLabels.add(itemLabel);
                }
                if (!block.isBlocktotals()) continue;
                this.isLineTitle.add(false);
                this.lineLabels.add("SUB-TOTAL");
                this.decDigits.add(blockDecDigits);
            }
        }

        static String clean(String s0) {
            String s = s0.replace("&lt;", "<");
            s = s.replace("&gt;", ">");
            return s;
        }

        void adjust() {
            String s;
            int i = 0;
            while (i < this.lineLabels.size()) {
                s = TableBodyStructure.clean(this.lineLabels.get(i));
                this.lineLabels.set(i, s);
                ++i;
            }
            if (!this.footnotes.isEmpty()) {
                i = 0;
                while (i < this.footnotes.size()) {
                    s = TableBodyStructure.clean(this.footnotes.get(i));
                    this.footnotes.set(i, s);
                    ++i;
                }
            }
        }
    }
}

