/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.calc;

import fr.msimeon.mads.runModel.odfdom.ODFSpreadsheet_IO;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;

public class ExportIRR_full
extends UIJob {
    final String[] headers;
    double[] npv;
    String[] varLabels;
    double oCC;
    double bal;
    Object result;
    String fSpec;
    String worksheet;

    public ExportIRR_full(String[] headers, double[] npv, String[] varLabels, double oCC, double bal, Object result, String fSpec, String worksheet) {
        super("Mads export full IRR");
        this.headers = headers;
        this.npv = npv;
        this.varLabels = varLabels;
        this.oCC = oCC;
        this.bal = bal;
        this.result = result;
        this.worksheet = worksheet;
        this.fSpec = fSpec;
    }

    public boolean belongsTo(Object family) {
        return family == "MadsJobs";
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) {
                    ODFSpreadsheet_IO ods = null;
                    int nbHeaders = ExportIRR_full.this.headers.length;
                    int nbRes = ExportIRR_full.this.npv.length;
                    monitor.beginTask("Exporting IRR Table ", 2 + nbRes);
                    try {
                        ods = new ODFSpreadsheet_IO(ExportIRR_full.this.fSpec, ExportIRR_full.this.worksheet, true, 3, nbHeaders + 4 + nbRes);
                        if (!ods.docOK().booleanValue()) {
                            ods.close();
                            monitor.setCanceled(true);
                            return;
                        }
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.subTask("Exporting headers");
                        monitor.worked(2);
                        ods.setCell(0, 0, 0, 0, "left", null, String.valueOf(ExportIRR_full.this.headers[0]) + " - " + ExportIRR_full.this.headers[1], ods.h1StyleName, null, null);
                        int i = 2;
                        while (i < nbHeaders) {
                            ods.setCell(0, i - 1, 0, 0, "left", null, ExportIRR_full.this.headers[i], ods.h2StyleName, null, null);
                            ++i;
                        }
                        double[] sw = new double[nbRes];
                        int width = 0;
                        int i2 = 0;
                        while (i2 < nbRes) {
                            width = Math.max(width, ExportIRR_full.this.varLabels[i2].length());
                            ++i2;
                        }
                        width = Math.max(width, 16);
                        ods.setColWidth(0, width);
                        ods.setColWidth(1, 16);
                        ods.setColWidth(2, 16);
                        ods.setCell(0, nbHeaders - 1, 1, 0, "left", null, "Rate of return = ", ods.tlStyleName, null, null);
                        if (ExportIRR_full.this.result instanceof Double) {
                            ods.setCell(1, nbHeaders - 1, 1, 0, null, null, null, ods.dStyleName, (Double)ExportIRR_full.this.result / 100.0, true);
                        } else {
                            ods.setCell(1, nbHeaders - 1, 1, 0, "left", null, (String)ExportIRR_full.this.result, ods.dStyleName, null, null);
                        }
                        ods.setCell(0, nbHeaders + 1, 3, 0, "center", null, "Present and Switching Values", ods.h2StyleName, null, null);
                        String s = String.format("%s%,1.2f%%}", "(Opportunity cost of capital = ", ExportIRR_full.this.oCC);
                        ods.setCell(0, nbHeaders + 2, 3, 0, "center", null, s, ods.emhStyleName, null, null);
                        ods.setCell(0, nbHeaders + 3, 1, 0, "center", null, "  ", ods.h2StyleName, null, null);
                        ods.setCell(1, nbHeaders + 3, 1, 0, "center", null, "Present Values", ods.tlStyleName, null, null);
                        ods.setCell(2, nbHeaders + 3, 1, 0, "center", null, "Switching Values\nPer cent", ods.tlStyleName, null, null);
                        int i3 = 0;
                        while (i3 < nbRes) {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            monitor.subTask("Exporting Table row " + i3);
                            monitor.worked(1);
                            sw[i3] = -1.0 * ExportIRR_full.this.bal / ExportIRR_full.this.npv[i3];
                            ods.setCell(0, nbHeaders + 4 + i3, 1, 0, "left", null, ExportIRR_full.this.varLabels[i3], ods.tlStyleName, null, null);
                            ods.setCell(1, nbHeaders + 4 + i3, 1, 0, "right", null, null, ods.dStyleName, ExportIRR_full.this.npv[i3], false);
                            ods.setCell(2, nbHeaders + 4 + i3, 1, 0, "right", null, null, ods.dStyleName, sw[i3], true);
                            ++i3;
                        }
                        ods.setCell(0, nbHeaders + 4 + nbRes, 1, 0, "right", null, "Net Balance", ods.tlStyleName, null, null);
                        ods.setCell(1, nbHeaders + 4 + nbRes, 1, 0, "right", null, null, ods.dStyleName, ExportIRR_full.this.bal, false);
                        ods.setCell(2, nbHeaders + 4 + nbRes, 1, 0, "right", null, "--", ods.tlStyleName, null, null);
                        if (ods.save() != false) return;
                        ods.close();
                        return;
                    }
                    finally {
                        ods.close();
                        monitor.done();
                    }
                }
            }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

