/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.calc;

import fr.msimeon.mads.runModel.calc.InOut;
import fr.msimeon.mads.runModel.odfdom.ODFSpreadsheet_IO;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;

public class ExportTable
extends UIJob {
    final String[] headers;
    ArrayList<Integer> tYears;
    ArrayList<String> lineLabels;
    ArrayList<String> footnotes;
    ArrayList<Integer> decDigits;
    ArrayList<Boolean> isLineTitle;
    double[][] values;
    double tScale;
    boolean totals;
    int width;
    boolean[] skipYear;
    ArrayList<String> yearGroupLabels;
    String worksheetName;
    String fSpec;

    public ExportTable(String[] headers, ArrayList<Integer> tYears, ArrayList<String> lineLabels, ArrayList<String> footnotes, ArrayList<Integer> decDigits, ArrayList<Boolean> isLineTitle, double[][] values, double tScale, boolean totals, int width, boolean[] skipYear, ArrayList<String> yearGroupLabels, String worksheetName, String fSpec) {
        super("Exporting Table " + headers[3] + ": " + headers[4]);
        this.headers = headers;
        this.tYears = tYears;
        this.lineLabels = lineLabels;
        this.footnotes = footnotes;
        this.decDigits = decDigits;
        this.isLineTitle = isLineTitle;
        this.values = values;
        this.tScale = tScale;
        this.totals = totals;
        this.width = width;
        this.skipYear = skipYear;
        this.yearGroupLabels = yearGroupLabels;
        this.worksheetName = worksheetName;
        this.fSpec = fSpec;
    }

    public boolean belongsTo(Object family) {
        return family == "MadsJobs";
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) {
                    ODFSpreadsheet_IO ods = null;
                    String ref = String.valueOf(ExportTable.this.headers[3]) + " - " + ExportTable.this.headers[4];
                    int nbRows = ExportTable.this.lineLabels.size();
                    monitor.beginTask("Exporting Table " + ref, 5 + nbRows);
                    try {
                        int i;
                        InOut.TableLayout layout = new InOut.TableLayout(ExportTable.this.tYears, ExportTable.this.decDigits, ExportTable.this.values, ExportTable.this.width, ExportTable.this.lineLabels, ExportTable.this.isLineTitle, ExportTable.this.yearGroupLabels, ExportTable.this.skipYear, ExportTable.this.totals);
                        String[] yearHeaders = layout.yearHeaders;
                        int nbYears = layout.nbYears;
                        int nextRow = ExportTable.this.headers.length;
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.subTask("Exporting headers");
                        monitor.worked(2);
                        ods = new ODFSpreadsheet_IO(ExportTable.this.fSpec, ExportTable.this.worksheetName, true, layout.totColNbr, nextRow + 2 + ExportTable.this.lineLabels.size() + ExportTable.this.footnotes.size());
                        if (!ods.docOK().booleanValue()) {
                            ods.close();
                            monitor.setCanceled(true);
                            return;
                        }
                        ods.setColWidth(0, layout.labelWidth);
                        int i2 = 1;
                        while (i2 < layout.totColNbr) {
                            ods.setColWidth(i2, layout.width);
                            ++i2;
                        }
                        ods.setCell(0, 0, layout.totColNbr, 0, "center", null, ExportTable.this.headers[0], ods.h2StyleName, null, null);
                        ods.setCell(0, 1, layout.totColNbr, 0, "center", null, ExportTable.this.headers[1], ods.h2StyleName, null, null);
                        ods.setCell(0, 2, layout.totColNbr, 0, "center", null, ExportTable.this.headers[2], ods.emhStyleName, null, null);
                        ods.setCell(0, 3, layout.totColNbr, 0, "center", null, ExportTable.this.headers[3], ods.h2StyleName, null, null);
                        ods.setCell(0, 4, layout.totColNbr, 0, "center", null, ExportTable.this.headers[4], ods.h1StyleName, null, null);
                        int i3 = 5;
                        while (i3 < ExportTable.this.headers.length) {
                            ods.setCell(0, i3, layout.totColNbr, 0, "center", null, ExportTable.this.headers[i3], ods.emhStyleName, null, null);
                            ++i3;
                        }
                        if (ExportTable.this.tScale != 1.0) {
                            String sf = String.format("All values in table scaled by a factor of %1.4g", ExportTable.this.tScale);
                            ods.setCell(0, nextRow, layout.totColNbr, 0, "center", null, sf, ods.emhStyleName, null, null);
                            ++nextRow;
                        }
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.subTask("Exporting Columns headers");
                        monitor.worked(2);
                        if (ExportTable.this.yearGroupLabels != null) {
                            int nbOfYearHeaders = ExportTable.this.yearGroupLabels.size();
                            int yearGroupSize = nbYears / nbOfYearHeaders;
                            ods.setCell(0, nextRow, 1, 1, "center", "middle", " ", ods.tlStyleName, null, null);
                            int nextCol = 1;
                            i = 0;
                            while (i < nbOfYearHeaders) {
                                String s = layout.yearGroupLabelsSplit ? (yearHeaders[i].equals(" ") ? yearHeaders[i + nbOfYearHeaders] : String.valueOf(yearHeaders[i]) + "\n" + yearHeaders[i + nbOfYearHeaders]) : yearHeaders[i];
                                ods.setCell(nextCol, nextRow, yearGroupSize, 0, "center", "middle", s, ods.tlStyleName, null, null);
                                nextCol += yearGroupSize;
                                ++i;
                            }
                            ++nextRow;
                        }
                        ods.setCell(0, nextRow, 1, 0, "right", "middle", "Years ", ods.tlStyleName, null, null);
                        int nextCol = 1;
                        int yr = 0;
                        while (yr < nbYears) {
                            if (!ExportTable.this.skipYear[yr]) {
                                int nextYr = yr;
                                while (nextYr + 1 < nbYears && ExportTable.this.skipYear[nextYr + 1]) {
                                    ++nextYr;
                                }
                                String s = nextYr == yr ? String.format("%d", ExportTable.this.tYears.get(yr)) : String.format(String.valueOf(ExportTable.this.tYears.get(yr).toString()) + "-" + ExportTable.this.tYears.get(nextYr).toString(), new Object[0]);
                                ods.setCell(nextCol, nextRow, 1, 0, "center", null, s, ods.tlStyleName, null, null);
                                ++nextCol;
                            }
                            ++yr;
                        }
                        if (ExportTable.this.totals) {
                            ods.setCell(nextCol, nextRow, 1, 0, "center", null, "Total", ods.tlStyleName, null, null);
                        }
                        ++nextRow;
                        int lineIndex = 0;
                        int labelIndex = 0;
                        while (labelIndex < ExportTable.this.lineLabels.size()) {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            monitor.subTask("Exporting Table row " + labelIndex);
                            monitor.worked(1);
                            Boolean isTitle = ExportTable.this.isLineTitle.get(labelIndex);
                            if (isTitle.booleanValue()) {
                                ods.setCell(0, nextRow, layout.totColNbr, 0, "left", null, ExportTable.this.lineLabels.get(labelIndex), ods.emlStyleName, null, null);
                            } else {
                                ods.setCell(0, nextRow, 1, 0, "left", null, ExportTable.this.lineLabels.get(labelIndex), ods.tlStyleName, null, null);
                            }
                            if (!isTitle.booleanValue()) {
                                nextCol = 1;
                                int yr2 = 0;
                                while (yr2 < nbYears) {
                                    if (!ExportTable.this.skipYear[yr2]) {
                                        ods.setCell(nextCol, nextRow, 0, 0, "right", null, null, ods.dStyleName, ExportTable.this.values[lineIndex][yr2], false, ExportTable.this.decDigits.get(lineIndex));
                                        ++nextCol;
                                    }
                                    ++yr2;
                                }
                                if (ExportTable.this.totals) {
                                    ods.setCell(nextCol, nextRow, 0, 0, "right", null, null, ods.dStyleName, ExportTable.this.values[lineIndex][nbYears], false, ExportTable.this.decDigits.get(lineIndex));
                                }
                                ++lineIndex;
                            }
                            ++nextRow;
                            ++labelIndex;
                        }
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.subTask("Exporting Footnotes");
                        monitor.worked(1);
                        i = 0;
                        while (i < ExportTable.this.footnotes.size()) {
                            ods.setCell(0, nextRow, layout.totColNbr, 0, "left", null, ExportTable.this.footnotes.get(i), ods.defStyleName, null, null);
                            ++nextRow;
                            ++i;
                        }
                        if (ods.save() != false) return;
                        monitor.setCanceled(true);
                        ods.close();
                        return;
                    }
                    finally {
                        ods.close();
                        monitor.done();
                    }
                }
            }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

