/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.calc;

import fr.msimeon.mads.mads.Atom;
import fr.msimeon.mads.mads.CommResType;
import fr.msimeon.mads.mads.Commodity;
import fr.msimeon.mads.mads.CommodityReference;
import fr.msimeon.mads.mads.DebtServFunc;
import fr.msimeon.mads.mads.DeflatingFunc;
import fr.msimeon.mads.mads.Expr;
import fr.msimeon.mads.mads.Factor;
import fr.msimeon.mads.mads.FileSpec;
import fr.msimeon.mads.mads.Function;
import fr.msimeon.mads.mads.Herd;
import fr.msimeon.mads.mads.HerdClass;
import fr.msimeon.mads.mads.HerdDetailedResType;
import fr.msimeon.mads.mads.HerdReference;
import fr.msimeon.mads.mads.HerdResType;
import fr.msimeon.mads.mads.IRRExp;
import fr.msimeon.mads.mads.IRRFunc;
import fr.msimeon.mads.mads.IfMinusFunc;
import fr.msimeon.mads.mads.IfPlusFunc;
import fr.msimeon.mads.mads.MultOrDiv;
import fr.msimeon.mads.mads.OpCostFunc;
import fr.msimeon.mads.mads.OpFactor;
import fr.msimeon.mads.mads.OutstandingFunc;
import fr.msimeon.mads.mads.PlusOrMinus;
import fr.msimeon.mads.mads.PriceContFunc;
import fr.msimeon.mads.mads.PurchFunc;
import fr.msimeon.mads.mads.ReadFunc;
import fr.msimeon.mads.mads.RefOrInt;
import fr.msimeon.mads.mads.RefOrValue;
import fr.msimeon.mads.mads.ResValFunc;
import fr.msimeon.mads.mads.ShiftFunc;
import fr.msimeon.mads.mads.SignedTerm;
import fr.msimeon.mads.mads.SingleValFunc;
import fr.msimeon.mads.mads.SumFunc;
import fr.msimeon.mads.mads.TableItem;
import fr.msimeon.mads.mads.Term;
import fr.msimeon.mads.mads.Variable;
import fr.msimeon.mads.mads.VariableReference;
import fr.msimeon.mads.mads.impl.AtomIDImpl;
import fr.msimeon.mads.mads.impl.AtomImpl;
import fr.msimeon.mads.mads.impl.ExprImpl;
import fr.msimeon.mads.mads.impl.FactorImpl;
import fr.msimeon.mads.mads.impl.IRRExpImpl;
import fr.msimeon.mads.mads.impl.IRRFuncImpl;
import fr.msimeon.mads.mads.impl.OpFactorImpl;
import fr.msimeon.mads.mads.impl.ReadFuncImpl;
import fr.msimeon.mads.mads.impl.RefOrIntImpl;
import fr.msimeon.mads.mads.impl.RefOrValueImpl;
import fr.msimeon.mads.mads.impl.ShiftFuncImpl;
import fr.msimeon.mads.mads.impl.SignedTermImpl;
import fr.msimeon.mads.mads.impl.TermImpl;
import fr.msimeon.mads.runModel.calc.Functions;
import fr.msimeon.mads.runModel.calc.InOut;
import fr.msimeon.mads.runModel.calc.PlanResults;
import fr.msimeon.mads.runModel.calc.TimeSeries;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.IDocument;

public class Expression {
    private int pLife;
    private ExprImpl expr;
    private Double opCostCap;
    private IDocument doc;
    private Boolean isHtml;
    private String[] headers;

    Expression(Expr expr, int pLife, Double opCostCap, IDocument doc, Boolean isHtml, String[] headers) {
        this.pLife = pLife;
        this.expr = (ExprImpl)expr;
        this.opCostCap = opCostCap;
        this.doc = doc;
        this.isHtml = isHtml;
        this.headers = headers;
    }

    TimeSeries evaluate(PlanResults currentPlanResults) {
        TimeSeries res = new TimeSeries(this.pLife);
        res = this.evaluateTerm((TermImpl)this.expr.getLeft(), currentPlanResults);
        EList sTerms = this.expr.getSignedTerms();
        for (SignedTerm sTerm : sTerms) {
            TermImpl termImpl = (TermImpl)((SignedTermImpl)sTerm).getTerm();
            PlusOrMinus addOp = ((SignedTermImpl)sTerm).getAddop();
            TimeSeries ts = new TimeSeries(this.pLife);
            ts = this.evaluateTerm(termImpl, currentPlanResults);
            if (ts == null) continue;
            res = addOp == PlusOrMinus.PLUS ? res.addValues(ts) : res.substractValues(ts);
        }
        return res;
    }

    TimeSeries evaluateTerm(TermImpl term, PlanResults currentPlanResults) {
        TimeSeries res = new TimeSeries(this.pLife);
        res = this.evaluateFactor((FactorImpl)term.getLeft(), currentPlanResults);
        EList opFactors = term.getOpFactors();
        for (OpFactor opFactor : opFactors) {
            res = ((OpFactorImpl)opFactor).getMultop() == MultOrDiv.MULT ? res.multValues(this.evaluateFactor((FactorImpl)opFactor.getFactor(), currentPlanResults)) : res.divValues(this.evaluateFactor((FactorImpl)opFactor.getFactor(), currentPlanResults));
        }
        return res;
    }

    TimeSeries evaluateFactor(FactorImpl factor, PlanResults currentPlanResults) {
        TimeSeries res = new TimeSeries(this.pLife);
        res = this.evaluateAtom((AtomImpl)factor.getLeft(), currentPlanResults);
        Atom right = factor.getRight();
        if (right != null) {
            res = res.power(this.evaluateAtom((AtomImpl)right, currentPlanResults));
        }
        return res;
    }

    TimeSeries evaluateAtom(AtomImpl atom, PlanResults currentPlanResults) {
        TimeSeries res = new TimeSeries(this.pLife);
        EList level = atom.getLevel();
        if (!level.isEmpty()) {
            res.setValues((EList<Double>)level);
        } else if (atom.getInstr() != null) {
            Expression expression = new Expression(atom.getInstr(), this.pLife, this.opCostCap, this.doc, this.isHtml, this.headers);
            res = expression.evaluate(currentPlanResults);
        } else if (atom.getAtomRef() != null) {
            AtomIDImpl atomID = (AtomIDImpl)atom.getAtomRef();
            res = Expression.getAtomIDValues(atomID, currentPlanResults, this.pLife);
        } else if (atom.getFunction() != null) {
            Function function = atom.getFunction();
            if (function instanceof IRRFunc) {
                String label = ((IRRFuncImpl)function).getLabel();
                FileSpec fSpec = ((IRRFuncImpl)function).getFileRef();
                Boolean export = fSpec != null;
                String worksheet = null;
                String fileSpec = null;
                if (this.doc == null) {
                    export = false;
                }
                if (export.booleanValue()) {
                    worksheet = ((IRRFuncImpl)function).getTable();
                    fileSpec = fSpec.getFileSpec();
                    if (InOut.checkODSFile(fileSpec, "IRR") != 0) {
                        export = false;
                    }
                }
                EList vars = ((IRRFuncImpl)function).getVars();
                ArrayList<TimeSeries> iRRVars = new ArrayList<TimeSeries>();
                ArrayList<String> varLabels = new ArrayList<String>();
                for (IRRExp var : vars) {
                    TimeSeries iRRVar = new TimeSeries(this.pLife);
                    String varLabel = Expression.getAtomLabel((AtomIDImpl)((IRRExpImpl)var).getV());
                    iRRVar = Expression.getAtomIDValues((AtomIDImpl)((IRRExpImpl)var).getV(), currentPlanResults, this.pLife);
                    if (((IRRExpImpl)var).getWeight() != null) {
                        MultOrDiv op = ((IRRExpImpl)var).getWeight().getMultOp();
                        Double weight = ((IRRExpImpl)var).getWeight().getW();
                        iRRVar = op == MultOrDiv.MULT ? iRRVar.multValues(weight) : iRRVar.divValues(weight);
                    }
                    iRRVars.add(iRRVar);
                    varLabels.add(varLabel);
                }
                Double irr = null;
                irr = Functions.irr(iRRVars, varLabels, this.opCostCap, label, this.pLife, this.doc, this.isHtml, export, fileSpec, worksheet, this.headers);
                res.setValues(irr);
            } else if (function instanceof ReadFunc) {
                String name = ((ReadFuncImpl)function).getRvar();
                String table = ((ReadFuncImpl)function).getTable();
                String fileSpec = ((ReadFuncImpl)function).getFileSpec().getFileSpec();
                res = Functions.read(name, table, fileSpec, this.pLife);
            } else if (function instanceof ShiftFunc) {
                int shift = ((ShiftFuncImpl)function).getShift();
                res = Expression.getAtomIDValues((AtomIDImpl)((ShiftFuncImpl)function).getVarRef(), currentPlanResults, this.pLife);
                res = res.shift(shift);
            } else if (function instanceof IfPlusFunc) {
                res = Expression.getAtomIDValues((AtomIDImpl)((IfPlusFunc)function).getVarRef(), currentPlanResults, this.pLife);
                res = res.ifPlus();
            } else if (function instanceof IfMinusFunc) {
                res = Expression.getAtomIDValues((AtomIDImpl)((IfMinusFunc)function).getVarRef(), currentPlanResults, this.pLife);
                res = res.ifMinus();
            } else if (function instanceof PurchFunc) {
                TimeSeries itemCons = new TimeSeries(this.pLife);
                TimeSeries itemProd = new TimeSeries(this.pLife);
                itemCons = Expression.getAtomIDValues((AtomIDImpl)((PurchFunc)function).getItemConsRef(), currentPlanResults, this.pLife);
                itemProd = Expression.getAtomIDValues((AtomIDImpl)((PurchFunc)function).getItemProdRef(), currentPlanResults, this.pLife);
                res = Functions.purchase(itemCons, itemProd, this.pLife);
            } else if (function instanceof OpCostFunc) {
                TimeSeries itemInv = new TimeSeries(this.pLife);
                itemInv = Expression.getAtomIDValues((AtomIDImpl)((OpCostFunc)function).getInvestment(), currentPlanResults, this.pLife);
                int life = this.getInt(((OpCostFunc)function).getLife(), currentPlanResults);
                int delay = this.getInt(((OpCostFunc)function).getDelay(), currentPlanResults);
                double rate = this.getValue(((OpCostFunc)function).getRate(), currentPlanResults);
                res = Functions.opCost(itemInv, life, delay, rate, this.pLife);
            } else if (function instanceof ResValFunc) {
                TimeSeries itemInv = new TimeSeries(this.pLife);
                itemInv = Expression.getAtomIDValues((AtomIDImpl)((ResValFunc)function).getInvestment(), currentPlanResults, this.pLife);
                int life = this.getInt(((ResValFunc)function).getLife(), currentPlanResults);
                double rate = this.getValue(((ResValFunc)function).getResValRate(), currentPlanResults);
                res = Functions.resVal(itemInv, life, rate, this.pLife);
            } else if (function instanceof DebtServFunc) {
                TimeSeries itemLoan = new TimeSeries(this.pLife);
                itemLoan = Expression.getAtomIDValues((AtomIDImpl)((DebtServFunc)function).getLoanRef(), currentPlanResults, this.pLife);
                int duration = ((DebtServFunc)function).getDuration();
                int grace = ((DebtServFunc)function).getGrace();
                int graceOnInt = ((DebtServFunc)function).isSeparateGraceOnIt() ? ((DebtServFunc)function).getGraceOnInt() : grace;
                double rate = this.getValue(((DebtServFunc)function).getRate(), currentPlanResults);
                boolean isEndYr = ((DebtServFunc)function).isEndYr();
                boolean isSeparateLoans = ((DebtServFunc)function).isSeparateLoans();
                res = Functions.debtService(itemLoan, duration, grace, graceOnInt, rate, isEndYr, isSeparateLoans, this.pLife);
            } else if (function instanceof OutstandingFunc) {
                TimeSeries itemLoan = new TimeSeries(this.pLife);
                itemLoan = Expression.getAtomIDValues((AtomIDImpl)((OutstandingFunc)function).getLoanRef(), currentPlanResults, this.pLife);
                double rate = this.getValue(((OutstandingFunc)function).getRate(), currentPlanResults);
                boolean isEndYr = ((OutstandingFunc)function).isEndYr();
                TimeSeries debtService = new TimeSeries(this.pLife);
                String debtServiceName = ((OutstandingFunc)function).getDebtServRef().getVarRef().getName();
                Boolean isLocal = ((OutstandingFunc)function).getDebtServRef().getVarRef().isLocal();
                debtService = isLocal != false ? currentPlanResults.getLocalVarResult(debtServiceName) : currentPlanResults.getGlobalVarResult(debtServiceName);
                res = Functions.outstanding(itemLoan, rate, isEndYr, debtService, this.pLife);
            } else if (function instanceof SingleValFunc) {
                res = Expression.getAtomIDValues((AtomIDImpl)((SingleValFunc)function).getVarRef(), currentPlanResults, this.pLife);
                int index = ((SingleValFunc)function).getIndex();
                res = res.singleValue(index);
            } else if (function instanceof DeflatingFunc) {
                res = Expression.getAtomIDValues((AtomIDImpl)((DeflatingFunc)function).getItemRef(), currentPlanResults, this.pLife);
                TimeSeries inflationRates = new TimeSeries(this.pLife);
                String inflationRatesName = ((DeflatingFunc)function).getInflationRates().getName();
                Boolean isLocal = ((DeflatingFunc)function).getInflationRates().isLocal();
                inflationRates = isLocal != false ? currentPlanResults.getLocalVarResult(inflationRatesName) : currentPlanResults.getGlobalVarResult(inflationRatesName);
                res = res.deflated(inflationRates);
            } else if (function instanceof PriceContFunc) {
                res = Expression.getAtomIDValues((AtomIDImpl)((PriceContFunc)function).getItemRef(), currentPlanResults, this.pLife);
                TimeSeries inflationRates = new TimeSeries(this.pLife);
                String inflationRatesName = ((PriceContFunc)function).getInflationRates().getName();
                Boolean isLocal = ((PriceContFunc)function).getInflationRates().isLocal();
                inflationRates = isLocal != false ? currentPlanResults.getLocalVarResult(inflationRatesName) : currentPlanResults.getGlobalVarResult(inflationRatesName);
                res = res.priceCont(inflationRates);
            } else if (function instanceof SumFunc) {
                res = Expression.getAtomIDValues((AtomIDImpl)((SumFunc)function).getVarRef(), currentPlanResults, this.pLife);
                res = res.sum();
            }
        } else {
            double v = atom.getV();
            res.setValues(v);
        }
        return res;
    }

    public static String getAtomLabel(AtomIDImpl atomID) {
        String label = "";
        if (atomID instanceof VariableReference) {
            if (((VariableReference)atomID).getVarRef().getLabel() != null) {
                return ((VariableReference)atomID).getVarRef().getLabel();
            }
            return ((VariableReference)atomID).getVarRef().getName();
        }
        if (atomID instanceof CommodityReference) {
            return String.valueOf(((CommodityReference)atomID).getCommRef().getLabel()) + " " + ((CommodityReference)atomID).getCommResType().toString();
        }
        if (atomID instanceof HerdReference) {
            HerdReference hRef = (HerdReference)atomID;
            HerdClass classRef = hRef.getClassRef();
            label = String.valueOf(hRef.getHerdRef().getLabel()) + " ";
            if (classRef != null) {
                return String.valueOf(label) + hRef.getHerdDetailedResType().toString() + " " + classRef.getLabel();
            }
            return String.valueOf(label) + hRef.getHerdResType().toString();
        }
        return label;
    }

    public static String getTableItemLabel(TableItem tableItem) {
        String label = "";
        Variable variable = tableItem.getVarRef();
        Commodity comm = tableItem.getCommRef();
        Herd herd = tableItem.getHerdRef();
        if (variable != null) {
            if (variable.getLabel() != null) {
                return variable.getLabel();
            }
            return variable.getName();
        }
        if (comm != null) {
            return String.valueOf(comm.getLabel()) + " " + tableItem.getCommResType().toString();
        }
        if (herd != null) {
            HerdClass classRef = tableItem.getClassRef();
            label = String.valueOf(herd.getLabel()) + " ";
            if (classRef != null) {
                return String.valueOf(label) + tableItem.getHerdDetailedResType().toString() + " " + classRef.getLabel();
            }
            return String.valueOf(label) + tableItem.getHerdResType().toString();
        }
        return label;
    }

    int getInt(RefOrInt rf, PlanResults currentPlanResults) {
        int res;
        RefOrIntImpl ref = (RefOrIntImpl)rf;
        if (ref.getValRef() != null) {
            Variable var = ref.getValRef().getVarRef();
            double dres = currentPlanResults.getLocalVarResult(var.getName()).getValues()[1];
            long longres = (long)dres;
            res = Expression.longToInt(longres);
        } else {
            res = ref.getValue();
        }
        return res;
    }

    static int longToInt(Long longIndex) {
        int index;
        if (longIndex <= Integer.MAX_VALUE && longIndex >= Integer.MIN_VALUE) {
            String nbrS = longIndex.toString();
            index = Integer.valueOf(nbrS);
        } else {
            index = longIndex >= 0L ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        return index;
    }

    double getValue(RefOrValue rf, PlanResults currentPlanResults) {
        double dres;
        RefOrValueImpl ref = (RefOrValueImpl)rf;
        if (ref.getValRef() != null) {
            Variable var = ref.getValRef().getVarRef();
            dres = currentPlanResults.getLocalVarResult(var.getName()).getValues()[1];
        } else {
            dres = ref.getValue();
        }
        return dres;
    }

    public static TimeSeries getAtomIDValues(AtomIDImpl atomID, PlanResults currentPlanResults, int pLife) {
        TimeSeries res = new TimeSeries(pLife);
        if (atomID instanceof VariableReference) {
            String varName = ((VariableReference)atomID).getVarRef().getName();
            Boolean isLocal = ((VariableReference)atomID).getVarRef().isLocal();
            res = isLocal.booleanValue() ? currentPlanResults.getLocalVarResult(varName) : currentPlanResults.getGlobalVarResult(varName);
        } else if (atomID instanceof CommodityReference) {
            String commName = ((CommodityReference)atomID).getCommRef().getName();
            CommResType resType = ((CommodityReference)atomID).getCommResType();
            res = currentPlanResults.getCommodityResult(commName, resType);
        } else if (atomID instanceof HerdReference) {
            String herdName = ((HerdReference)atomID).getHerdRef().getName();
            HerdResType resType = ((HerdReference)atomID).getHerdResType();
            HerdDetailedResType detResType = ((HerdReference)atomID).getHerdDetailedResType();
            String hClass = null;
            HerdClass classRef = ((HerdReference)atomID).getClassRef();
            if (classRef != null) {
                hClass = classRef.getName();
                resType = null;
            } else {
                detResType = null;
            }
            res = currentPlanResults.getHerdResult(herdName, resType, detResType, hClass);
        }
        if (res == null) {
            res = new TimeSeries(pLife);
        }
        return res;
    }

    public static TimeSeries getTableItemValues(TableItem tableItem, PlanResults currentPlanResults, int pLife) {
        TimeSeries res = new TimeSeries(pLife);
        Commodity comm = tableItem.getCommRef();
        Herd herd = tableItem.getHerdRef();
        Variable variable = tableItem.getVarRef();
        if (variable != null) {
            String varName = variable.getName();
            Boolean isLocal = variable.isLocal();
            res = isLocal.booleanValue() ? currentPlanResults.getLocalVarResult(varName) : currentPlanResults.getGlobalVarResult(varName);
        } else if (comm != null) {
            String commName = comm.getName();
            CommResType resType = tableItem.getCommResType();
            res = currentPlanResults.getCommodityResult(commName, resType);
        } else if (herd != null) {
            String herdName = herd.getName();
            HerdResType resType = tableItem.getHerdResType();
            HerdDetailedResType detResType = tableItem.getHerdDetailedResType();
            HerdClass herdClass = tableItem.getClassRef();
            String hClass = null;
            if (herdClass != null) {
                hClass = herdClass.getName();
                resType = null;
            } else {
                detResType = null;
            }
            res = currentPlanResults.getHerdResult(herdName, resType, detResType, hClass);
        }
        if (res == null) {
            res = new TimeSeries(pLife);
        }
        return res;
    }

    void listOut() {
        this.listTerm(this.expr.getLeft());
        EList sTerms = this.expr.getSignedTerms();
        for (SignedTerm sTerm : sTerms) {
            InOut.out.print(String.valueOf(((SignedTermImpl)sTerm).getAddop().toString()) + " ");
            this.listTerm(((SignedTermImpl)sTerm).getTerm());
        }
    }

    private void listTerm(Term term) {
        this.listFactor(((TermImpl)term).getLeft());
        EList opFactors = ((TermImpl)term).getOpFactors();
        for (OpFactor opFactor : opFactors) {
            InOut.out.print(String.valueOf(((OpFactorImpl)opFactor).getMultop().toString()) + " ");
            this.listFactor(((OpFactorImpl)opFactor).getFactor());
        }
    }

    private void listFactor(Factor factor) {
        this.listAtom(((FactorImpl)factor).getLeft());
        if (factor.getRight() != null) {
            InOut.out.print("^ ");
            this.listAtom(((FactorImpl)factor).getRight());
        }
    }

    private void listAtom(Atom atomI) {
        AtomImpl atom = (AtomImpl)atomI;
        EList level = atom.getLevel();
        if (!level.isEmpty()) {
            InOut.out.print("[ ");
            for (Double v : level) {
                InOut.out.print(String.format("%1.2f ", v));
            }
            InOut.out.print("] ");
        } else if (atom.getInstr() != null) {
            Expression expression = new Expression(atom.getInstr(), this.pLife, this.opCostCap, this.doc, this.isHtml, this.headers);
            InOut.out.print("( ");
            expression.listOut();
            InOut.out.print(") ");
        } else if (atom.getAtomRef() != null) {
            AtomIDImpl atomID = (AtomIDImpl)atom.getAtomRef();
            if (atomID instanceof VariableReference) {
                InOut.out.print(String.valueOf(((VariableReference)atomID).getVarRef().getName()) + " ");
            } else if (atomID instanceof CommodityReference) {
                InOut.out.print(String.valueOf(((CommodityReference)atomID).getCommRef().getName()) + "~" + ((CommodityReference)atomID).getCommResType().toString() + " ");
            } else if (atomID instanceof HerdReference) {
                InOut.out.print(String.valueOf(((HerdReference)atomID).getHerdRef().getName()) + "~" + ((HerdReference)atomID).getHerdResType().toString() + " ");
            } else {
                InOut.out.print("AtomRef ");
            }
        } else if (atom.getFunction() != null) {
            InOut.out.print("Function ");
        } else {
            double v = atom.getV();
            InOut.out.print(String.format("%1.2f ", v));
        }
    }
}

