/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.calc;

import fr.msimeon.mads.runModel.calc.InOut;
import fr.msimeon.mads.runModel.calc.TimeSeries;
import fr.msimeon.mads.runModel.math.Complex;
import fr.msimeon.mads.runModel.math.Polynomial;
import fr.msimeon.mads.runModel.math.RootException;
import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;

public class Functions {
    public static TimeSeries read(String vName, String table, String fSpec, int pLife) {
        TimeSeries res = new TimeSeries(pLife);
        res = InOut.importTS(vName, table, fSpec, pLife);
        return res;
    }

    public static double irr(ArrayList<TimeSeries> vars, ArrayList<String> varLabels, Double oCC, String label, int pLife, IDocument doc, Boolean isHtml, Boolean export, String fSpec, String worksheet, String[] headers) {
        double rate = Double.NEGATIVE_INFINITY;
        Object result = null;
        int nbVars = vars.size();
        headers[3] = label;
        if (nbVars == 1) {
            result = Functions.getIRR(vars.get(0).getValues());
            double npv = Functions.netPresentValue(vars.get(0).getValues(), oCC);
            InOut.listIRR(label, npv, oCC, result, doc, isHtml);
            if (export.booleanValue()) {
                InOut.exportIRR(headers, npv, oCC, result, fSpec, worksheet);
            }
        } else {
            TimeSeries balance = new TimeSeries(pLife);
            double[] npv = new double[nbVars];
            int i = 0;
            while (i < nbVars) {
                balance = balance.addValues(vars.get(i));
                npv[i] = Functions.netPresentValue(vars.get(i).getValues(), oCC);
                ++i;
            }
            double balNPV = Functions.netPresentValue(balance.getValues(), oCC);
            result = Functions.getIRR(balance.getValues());
            String[] vlabels = varLabels.toArray(new String[varLabels.size()]);
            if (doc != null) {
                InOut.listIRR(label, npv, vlabels, oCC, balNPV, result, doc, isHtml);
            }
            if (export.booleanValue()) {
                InOut.exportIRR(headers, npv, vlabels, oCC, balNPV, result, fSpec, worksheet);
            }
        }
        if (result instanceof Double) {
            rate = (Double)result;
        }
        return rate;
    }

    static double netPresentValue(double[] var, Double oCC) {
        double x;
        double npv = 0.0;
        double factor = x = 1.0 / (1.0 + oCC / 100.0);
        int i = 1;
        while (i < var.length) {
            npv += var[i] * factor;
            factor *= x;
            ++i;
        }
        return npv;
    }

    static Object getIRR(double[] var) {
        int pLife;
        Complex[] zeros = null;
        int notNull = pLife = var.length - 1;
        while (var[notNull] == 0.0 && notNull > 0) {
            --notNull;
        }
        double[] newVar = new double[notNull];
        int i = 0;
        while (i < notNull) {
            newVar[i] = var[i + 1];
            ++i;
        }
        Polynomial poly = new Polynomial(newVar);
        try {
            zeros = poly.zeros();
        }
        catch (RootException e) {
            System.out.println(e.getMessage());
        }
        ArrayList<Double> realRates = new ArrayList<Double>();
        if (zeros != null) {
            int i2 = 0;
            while (i2 < zeros.length) {
                if (zeros[i2].im() == 0.0 && zeros[i2].re() != 0.0) {
                    Double IRR = 100.0 * (1.0 - zeros[i2].re()) / zeros[i2].re();
                    realRates.add(IRR);
                }
                ++i2;
            }
            if (realRates.size() == 1) {
                return realRates.get(0);
            }
            if (realRates.size() > 1) {
                return "More than one rate found: rate of return not applicable";
            }
            return "No rate of return could be found";
        }
        return "No roots could be found: rate of return not applicable";
    }

    public static TimeSeries purchase(TimeSeries itemCons, TimeSeries itemProd, int pLife) {
        TimeSeries res = new TimeSeries(pLife);
        TimeSeries res2 = new TimeSeries(pLife);
        res = res.addValues(itemCons);
        res = res.substractValues(itemProd);
        res2 = res.ifMinus().shift(1);
        return res.addValues(res2);
    }

    public static TimeSeries resVal(TimeSeries itemInv, int life, double rvRate, int pLife) {
        TimeSeries res = new TimeSeries(pLife);
        double rate = rvRate / 100.0;
        int i = 1;
        while (i <= pLife) {
            double inv = -itemInv.getValues()[i];
            if (i + life <= pLife) {
                res.addValue(inv * rate, i + life);
            } else {
                int left = life - (pLife - i + 1);
                double perCentLeft = (1.0 - rate) * ((double)left / (double)life);
                double resval = inv * (rate + perCentLeft);
                res.addValue(resval, pLife);
            }
            ++i;
        }
        return res;
    }

    public static TimeSeries opCost(TimeSeries itemInv, int life, int delay, double rate, int pLife) {
        TimeSeries res = new TimeSeries(pLife);
        int i = 1;
        while (i <= pLife) {
            double inv = itemInv.getValues()[i];
            int index = Math.min(pLife, i + life - 1);
            int j = i + delay;
            while (j <= index) {
                res.addValue(inv * (rate / 100.0), j);
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static TimeSeries debtService(TimeSeries itemLoan, int duration, int grace, int graceOnInt, double rate, boolean isEndYr, boolean isSeparateLoans, int pLife) {
        int repayP;
        TimeSeries res = new TimeSeries(pLife);
        double rateFactor = 1.0 + rate / 100.0;
        int first = 1;
        int last = pLife;
        while (first <= pLife && itemLoan.getValues()[first] == 0.0) {
            ++first;
        }
        while (last >= 1 && itemLoan.getValues()[last] == 0.0) {
            --last;
        }
        if (grace < last - first) {
            grace = last - first;
            System.out.printf("Grace period set to %1d to fit loan installments%n", grace);
        }
        if ((repayP = duration - grace) < 1) {
            System.out.printf("Grace and duration do not fit loan installments%n-->> results set to zero%n", new Object[0]);
        }
        if (graceOnInt > grace) {
            graceOnInt = grace;
            System.out.printf("Grace period on interest set to %1d to fit grace%n", graceOnInt);
        }
        int i = first;
        while (i <= last) {
            if (itemLoan.getValues()[i] < 0.0) {
                System.out.println("AMOUNT OF LOAN IS NEGATIVE IN YEAR " + i + "\n-->> LOAN WILL BE ASSUMED AS ZERO FOR YEAR " + i);
                return res;
            }
            ++i;
        }
        i = first;
        while (i <= last) {
            int n;
            int gP;
            int graceP;
            int graceI;
            double[] debt = new double[pLife + 1];
            double[] outst = new double[pLife + 1];
            double amount = itemLoan.getValues()[i];
            if (isSeparateLoans) {
                graceI = graceOnInt;
                graceP = grace;
            } else {
                graceI = graceOnInt - (i - first);
                if (graceI < 0) {
                    graceI = 0;
                }
                graceP = grace - (i - first);
            }
            int gI = i + graceI - 1;
            if (gI > pLife) {
                gI = pLife;
            }
            if ((gP = i + graceP - 1) > pLife) {
                gP = pLife;
            }
            if ((n = gP + repayP) > pLife) {
                n = pLife;
            }
            int j = i;
            while (j < gI + 1) {
                outst[j] = amount * Math.pow(rateFactor, j - i + 1);
                ++j;
            }
            j = gI + 1;
            while (j < gP + 1) {
                outst[j] = outst[j - 1];
                if (j == i) {
                    outst[j] = amount;
                }
                debt[j] = outst[j] * rate / 100.0;
                ++j;
            }
            double PV = graceP > 0 ? outst[gP] : amount;
            double PMT = rate == 0.0 ? PV / (double)repayP : PV * rate / 100.0 / (1.0 - Math.pow(rateFactor, -repayP));
            j = gP + 1;
            while (j <= n) {
                debt[j] = PMT;
                outst[j] = PV = PV * rateFactor - PMT;
                ++j;
            }
            if (isEndYr) {
                j = pLife;
                while (j > 0) {
                    debt[j] = debt[j - 1];
                    outst[j] = outst[j - 1];
                    --j;
                }
            }
            j = 1;
            while (j <= pLife) {
                res.addValue(debt[j], j);
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static TimeSeries outstanding(TimeSeries itemLoan, double rate, boolean isEndYr, TimeSeries debtService, int pLife) {
        TimeSeries res = new TimeSeries(pLife);
        double[] outst = new double[pLife + 1];
        double rateFactor = 1.0 + rate / 100.0;
        int i = 1;
        while (i <= pLife) {
            outst[i] = isEndYr ? itemLoan.getValues()[i] + outst[i - 1] * rateFactor - debtService.getValues()[i] : (outst[i - 1] + itemLoan.getValues()[i]) * rateFactor - debtService.getValues()[i];
            res.addValue(outst[i], i);
            ++i;
        }
        return res;
    }
}

