/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.calc;

import fr.msimeon.mads.mads.CommInPlanType;
import fr.msimeon.mads.mads.DataByHerdClass;
import fr.msimeon.mads.mads.FemaleHerdClass;
import fr.msimeon.mads.mads.HerdClass;
import fr.msimeon.mads.mads.HerdDataByCat;
import fr.msimeon.mads.mads.HerdDetailedResType;
import fr.msimeon.mads.mads.HerdFeedItem;
import fr.msimeon.mads.mads.HerdPropItem;
import fr.msimeon.mads.mads.HerdResType;
import fr.msimeon.mads.mads.IntakeItem;
import fr.msimeon.mads.mads.MaleHerdClass;
import fr.msimeon.mads.mads.ParturitionItem;
import fr.msimeon.mads.mads.TS;
import fr.msimeon.mads.mads.impl.CommodityImpl;
import fr.msimeon.mads.mads.impl.HerdImpl;
import fr.msimeon.mads.runModel.calc.Calc;
import fr.msimeon.mads.runModel.calc.InOut;
import fr.msimeon.mads.runModel.calc.PlanResults;
import fr.msimeon.mads.runModel.calc.TimeSeries;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ui.console.MessageConsoleStream;

public class HerdModel {
    private int pLife;
    String name;
    String label;
    String unit;
    int nbMaleClasses;
    int nbFemaleClasses;
    int nbTotalClasses;
    int maxFemaleAge;
    int maxMaleAge;
    String[] classNames;
    String[] classLabels;
    String[] catLabels;
    int maxLabel;
    int[] indexM;
    int[] indexF;
    int[] ageGroupDuration;
    double[] initialSize;
    double[] maxSize;
    Boolean existsMaxM;
    Boolean existsMaxF;
    TimeSeries[] deathRates;
    TimeSeries[] femAtBirthRate;
    TimeSeries[] birthRate;
    TimeSeries[] prolifRate;
    TimeSeries[] offtakeRates;
    TimeSeries[] intakeNumbers;
    TimeSeries[] liveWeights;
    TimeSeries[] carcassYield;
    CommodityImpl milkComm;
    CommInPlanType milkCalcType;
    TimeSeries[] milkPerLactation;
    TimeSeries[] offtakePrices;
    TimeSeries[] intakePrices;
    FeedItem[] feedItems;
    PropItem[] propItems;
    TimeSeries[] herdSize;
    TimeSeries[] herdLiveWeight;
    TimeSeries[] offtakeNbr;
    TimeSeries[] importNbr;
    TimeSeries[] sizeVariation;

    HerdModel(HerdImpl herd, int pLife) {
        int rank;
        TimeSeries temp;
        this.pLife = pLife;
        this.name = herd.getName();
        this.label = herd.getLabel();
        this.unit = herd.getUnit();
        EList mClasses = herd.getMaleClasses();
        EList fClasses = herd.getFemaleClasses();
        this.nbFemaleClasses = fClasses.size();
        this.nbMaleClasses = mClasses.size();
        this.nbTotalClasses = this.nbMaleClasses + this.nbFemaleClasses;
        this.herdSize = new TimeSeries[this.nbTotalClasses];
        this.herdLiveWeight = new TimeSeries[this.nbTotalClasses];
        this.sizeVariation = new TimeSeries[this.nbTotalClasses];
        this.offtakeNbr = new TimeSeries[this.nbTotalClasses];
        this.importNbr = new TimeSeries[this.nbTotalClasses];
        this.classNames = new String[this.nbTotalClasses];
        this.classLabels = new String[this.nbTotalClasses];
        this.catLabels = new String[this.nbTotalClasses];
        this.indexM = new int[this.nbMaleClasses];
        this.indexF = new int[this.nbFemaleClasses];
        FemaleHerdClass[] femaleClasses = new FemaleHerdClass[this.nbFemaleClasses];
        int rk = 0;
        this.maxLabel = 0;
        this.maxFemaleAge = 0;
        for (FemaleHerdClass fClass : fClasses) {
            this.maxFemaleAge += fClass.getDuration();
            femaleClasses[rk] = fClass;
            this.classNames[rk] = fClass.getName();
            this.classLabels[rk] = fClass.getLabel();
            this.catLabels[rk] = "F " + (rk + 1) + " : " + fClass.getLabel();
            this.maxLabel = Math.max(this.maxLabel, this.catLabels[rk].length());
            ++rk;
        }
        MaleHerdClass[] maleClasses = new MaleHerdClass[this.nbMaleClasses];
        rk = 0;
        this.maxMaleAge = 0;
        for (MaleHerdClass mClass : mClasses) {
            this.maxMaleAge += mClass.getDuration();
            maleClasses[rk] = mClass;
            this.classNames[rk + this.nbFemaleClasses] = mClass.getName();
            this.classLabels[rk + this.nbFemaleClasses] = mClass.getLabel();
            this.catLabels[rk + this.nbFemaleClasses] = "M " + (rk + 1) + " : " + mClass.getLabel();
            this.maxLabel = Math.max(this.maxLabel, this.catLabels[rk + this.nbFemaleClasses].length());
            ++rk;
        }
        this.ageGroupDuration = new int[this.nbTotalClasses];
        this.initialSize = new double[this.nbTotalClasses];
        this.maxSize = new double[this.nbTotalClasses];
        this.deathRates = new TimeSeries[this.nbTotalClasses];
        this.offtakeRates = new TimeSeries[this.nbTotalClasses];
        this.offtakePrices = new TimeSeries[this.nbTotalClasses];
        this.liveWeights = new TimeSeries[this.nbTotalClasses];
        this.carcassYield = new TimeSeries[this.nbTotalClasses];
        this.existsMaxM = false;
        this.existsMaxF = false;
        int i = 0;
        while (i < this.nbFemaleClasses) {
            this.ageGroupDuration[i] = femaleClasses[i].getDuration();
            this.initialSize[i] = femaleClasses[i].getInitSize();
            this.maxSize[i] = femaleClasses[i].getMaxSize();
            if (this.maxSize[i] > 0.0) {
                this.existsMaxF = true;
            }
            this.deathRates[i] = this.getTSValues(femaleClasses[i].getDeathRate(), pLife, true);
            this.offtakeRates[i] = this.getTSValues(femaleClasses[i].getOfftakeRate(), pLife, true);
            this.offtakePrices[i] = this.getTSValues(femaleClasses[i].getPrice(), pLife, false);
            this.liveWeights[i] = this.getTSValues(femaleClasses[i].getWeight(), pLife, false);
            this.carcassYield[i] = this.getTSValues(femaleClasses[i].getYield(), pLife, true);
            if (i == 0) {
                this.indexF[0] = 0;
            } else {
                this.indexF[i] = this.indexF[i - 1] + this.ageGroupDuration[i - 1];
            }
            ++i;
        }
        i = 0;
        while (i < this.nbFemaleClasses - 1) {
            temp = this.liveWeights[i].addValues(this.liveWeights[i + 1]);
            this.liveWeights[i] = temp.divValues(2.0);
            ++i;
        }
        i = 0;
        while (i < this.nbMaleClasses) {
            this.ageGroupDuration[this.nbFemaleClasses + i] = maleClasses[i].getDuration();
            this.initialSize[this.nbFemaleClasses + i] = maleClasses[i].getInitSize();
            this.maxSize[this.nbFemaleClasses + i] = maleClasses[i].getMaxSize();
            if (this.maxSize[this.nbFemaleClasses + i] > 0.0) {
                this.existsMaxM = true;
            }
            this.deathRates[this.nbFemaleClasses + i] = this.getTSValues(maleClasses[i].getDeathRate(), pLife, true);
            this.offtakeRates[this.nbFemaleClasses + i] = this.getTSValues(maleClasses[i].getOfftakeRate(), pLife, true);
            this.offtakePrices[this.nbFemaleClasses + i] = this.getTSValues(maleClasses[i].getPrice(), pLife, false);
            this.liveWeights[this.nbFemaleClasses + i] = this.getTSValues(maleClasses[i].getWeight(), pLife, false);
            this.carcassYield[this.nbFemaleClasses + i] = this.getTSValues(maleClasses[i].getYield(), pLife, true);
            if (i == 0) {
                this.indexM[0] = 0;
            } else {
                this.indexM[i] = this.indexM[i - 1] + this.ageGroupDuration[this.nbFemaleClasses + i - 1];
            }
            ++i;
        }
        i = 0;
        while (i < this.nbMaleClasses - 1) {
            temp = this.liveWeights[this.nbFemaleClasses + i].addValues(this.liveWeights[this.nbFemaleClasses + i + 1]);
            this.liveWeights[this.nbFemaleClasses + i] = temp.divValues(2.0);
            ++i;
        }
        this.milkComm = (CommodityImpl)herd.getMilkCommRef();
        this.milkCalcType = herd.getMilkCommCalcType();
        if (this.milkCalcType == null) {
            this.milkCalcType = CommInPlanType.PROD;
        }
        this.birthRate = this.initData(this.nbFemaleClasses);
        this.femAtBirthRate = this.initData(this.nbFemaleClasses);
        this.prolifRate = this.initData(this.nbFemaleClasses);
        this.milkPerLactation = this.initData(this.nbFemaleClasses);
        for (ParturitionItem item : herd.getParturitionItems()) {
            rank = this.getRank(item.getClassRef().getName());
            this.birthRate[rank] = this.getTSValues(item.getBirthRate(), pLife, true);
            this.femAtBirthRate[rank] = this.getTSValues(item.getFemAtBirthRate(), pLife, true);
            this.prolifRate[rank] = this.getTSValues(item.getProlifRate(), pLife, true);
            this.milkPerLactation[rank] = this.getTSValues(item.getMilkPerLactation(), pLife, false);
        }
        this.intakeNumbers = this.initData(this.nbTotalClasses);
        this.intakePrices = this.initData(this.nbTotalClasses);
        for (IntakeItem item : herd.getIntakeItems()) {
            rank = this.getRank(item.getClassRef().getName());
            this.intakeNumbers[rank] = this.getTSValues(item.getNumbers(), pLife, false);
            this.intakePrices[rank] = this.getTSValues(item.getPrice(), pLife, false);
        }
        this.feedItems = new FeedItem[herd.getFeedItems().size()];
        int index = 0;
        for (HerdFeedItem item : herd.getFeedItems()) {
            this.feedItems[index] = new FeedItem(item);
            ++index;
        }
        this.propItems = new PropItem[herd.getProportionalItems().size()];
        index = 0;
        for (HerdFeedItem item : herd.getProportionalItems()) {
            this.propItems[index] = new PropItem((HerdPropItem)item);
            ++index;
        }
    }

    TimeSeries[] initData(int nb) {
        TimeSeries[] data = new TimeSeries[nb];
        int i = 0;
        while (i < nb) {
            data[i] = new TimeSeries(this.pLife);
            ++i;
        }
        return data;
    }

    int getRank(String name) {
        int r = 0;
        while (!this.classNames[r].equals(name)) {
            ++r;
        }
        return r;
    }

    TimeSeries[] setDataByCat(HerdDataByCat data, boolean rate) {
        TimeSeries[] res = new TimeSeries[this.nbTotalClasses];
        int i = 0;
        while (i < this.nbTotalClasses) {
            res[i] = new TimeSeries(this.pLife);
            ++i;
        }
        EList classData = data.getData();
        for (DataByHerdClass aClassData : classData) {
            TimeSeries ts = this.getTSValues(aClassData, this.pLife);
            HerdClass aClass = aClassData.getClassRef();
            int rank = this.getRank(aClass.getName());
            res[rank] = ts;
        }
        if (rate) {
            int n = 0;
            while (n < this.nbTotalClasses) {
                res[n] = res[n].divValues(100.0);
                ++n;
            }
        }
        return res;
    }

    TimeSeries getTSValues(TS ts, int pLife, Boolean isRate) {
        TimeSeries tsValues = new TimeSeries(pLife);
        EList level = ts.getLevel();
        if (!level.isEmpty()) {
            tsValues.setValues((EList<Double>)level);
        } else {
            tsValues = Calc.getReadValues(ts.getLevelvalues(), pLife);
        }
        if (isRate.booleanValue()) {
            return tsValues.divValues(100.0);
        }
        return tsValues;
    }

    TimeSeries getTSValues(DataByHerdClass ts, int pLife) {
        TimeSeries tsValues = new TimeSeries(pLife);
        EList level = ts.getValues();
        if (!level.isEmpty()) {
            tsValues.setValues((EList<Double>)level);
        } else {
            tsValues = Calc.getReadValues(ts.getLevelvalues(), pLife);
        }
        return tsValues;
    }

    double[] setInitSize(int nbClasses, int maxAge, int offset, double[] psurv) {
        double[] initClassSize = new double[maxAge + 1];
        int[] indexS = offset == 0 ? this.indexF : this.indexM;
        int i = 0;
        while (i < nbClasses) {
            double[] isize = new double[this.ageGroupDuration[offset + i]];
            isize[0] = 1.0;
            double sum = 1.0;
            double surv = psurv[indexS[i]];
            int j = 1;
            while (j < isize.length) {
                isize[j] = isize[j - 1] * surv;
                sum += isize[j];
                ++j;
            }
            double nb = 0.0;
            double initSize = this.initialSize[offset + i] - nb;
            int j2 = 0;
            while (j2 < isize.length) {
                int k = indexS[i] + j2;
                initClassSize[k] = initSize * isize[j2] / sum;
                ++j2;
            }
            ++i;
        }
        return initClassSize;
    }

    void evaluate(PlanResults planResults, TimeSeries level) {
        double[][] nbrFemales = new double[this.pLife * 12 + 1][this.maxFemaleAge + 1];
        double[][] nbrVariationF = new double[this.pLife + 1][this.maxFemaleAge + 1];
        double[][] offFemales = new double[this.pLife * 12 + 1][this.maxFemaleAge + 1];
        double[][] deaFemales = new double[this.pLife * 12 + 1][this.maxFemaleAge + 1];
        double[][] inFemales = new double[this.pLife + 1][this.maxFemaleAge + 1];
        double[][] nbrMales = new double[this.pLife * 12 + 1][this.maxMaleAge + 1];
        double[][] nbrVariationM = new double[this.pLife + 1][this.maxMaleAge + 1];
        double[][] offMales = new double[this.pLife * 12 + 1][this.maxMaleAge + 1];
        double[][] deaMales = new double[this.pLife * 12 + 1][this.maxMaleAge + 1];
        double[][] inMales = new double[this.pLife + 1][this.maxMaleAge + 1];
        MonthlyRates rates = new MonthlyRates(1);
        nbrFemales[0] = this.setInitSize(this.nbFemaleClasses, this.maxFemaleAge, 0, rates.psurvF);
        nbrMales[0] = this.setInitSize(this.nbMaleClasses, this.maxMaleAge, this.nbFemaleClasses, rates.psurvM);
        int year = 1;
        while (year <= this.pLife) {
            int month = 1;
            while (month < 13) {
                double groupSize;
                int group;
                double basis;
                int t = (year - 1) * 12 + month;
                int i = 1;
                while (i < this.maxFemaleAge + 1) {
                    double intakeF;
                    if (month == 7) {
                        inFemales[year][i] = intakeF = rates.nbintakeF[i];
                    } else {
                        intakeF = 0.0;
                    }
                    basis = intakeF + nbrFemales[t - 1][i - 1];
                    nbrFemales[t][i] = basis * rates.psurvF[i - 1];
                    offFemales[t][i - 1] = basis * rates.poffF[i - 1];
                    deaFemales[t][i - 1] = basis * rates.pdeaF[i - 1];
                    ++i;
                }
                i = 1;
                while (i < this.maxMaleAge + 1) {
                    double intakeM;
                    if (month == 7) {
                        inMales[year][i] = intakeM = rates.nbintakeM[i];
                    } else {
                        intakeM = 0.0;
                    }
                    basis = intakeM + nbrMales[t - 1][i - 1];
                    nbrMales[t][i] = basis * rates.psurvM[i - 1];
                    offMales[t][i - 1] = basis * rates.poffM[i - 1];
                    deaMales[t][i - 1] = basis * rates.pdeaM[i - 1];
                    ++i;
                }
                double[] dArray = offFemales[t];
                int n = this.maxFemaleAge - 1;
                dArray[n] = dArray[n] + nbrFemales[t][this.maxFemaleAge];
                nbrFemales[t][this.maxFemaleAge] = 0.0;
                double[] dArray2 = offMales[t];
                int n2 = this.maxMaleAge - 1;
                dArray2[n2] = dArray2[n2] + nbrMales[t][this.maxMaleAge];
                nbrMales[t][this.maxMaleAge] = 0.0;
                double nf = 0.0;
                int i2 = 0;
                while (i2 < this.maxFemaleAge) {
                    nf = nbrFemales[t][i2];
                    double[] dArray3 = nbrFemales[t];
                    dArray3[0] = dArray3[0] + nf * rates.netFfec[i2];
                    double[] dArray4 = nbrMales[t];
                    dArray4[0] = dArray4[0] + nf * rates.netMfec[i2];
                    ++i2;
                }
                if (this.existsMaxF.booleanValue()) {
                    group = 0;
                    while (group < this.nbFemaleClasses) {
                        if (this.maxSize[group] > 0.0) {
                            groupSize = 0.0;
                            int i3 = this.indexF[group];
                            while (i3 < this.indexF[group] + this.ageGroupDuration[group]) {
                                groupSize += nbrFemales[t][i3];
                                ++i3;
                            }
                            if (groupSize > this.maxSize[group]) {
                                double delta = (groupSize - this.maxSize[group]) / (double)this.ageGroupDuration[group];
                                int i4 = this.indexF[group];
                                while (i4 < this.indexF[group] + this.ageGroupDuration[group]) {
                                    double[] dArray5 = nbrFemales[t];
                                    int n3 = i4;
                                    dArray5[n3] = dArray5[n3] - delta;
                                    double[] dArray6 = offFemales[t];
                                    int n4 = i4++;
                                    dArray6[n4] = dArray6[n4] + delta;
                                }
                            }
                        }
                        ++group;
                    }
                }
                if (this.existsMaxM.booleanValue()) {
                    group = 0;
                    while (group < this.nbMaleClasses) {
                        if (this.maxSize[this.nbFemaleClasses + group] > 0.0) {
                            groupSize = 0.0;
                            int grp = this.nbFemaleClasses + group;
                            int i5 = this.indexM[group];
                            while (i5 < this.indexM[group] + this.ageGroupDuration[grp]) {
                                groupSize += nbrMales[t][i5];
                                ++i5;
                            }
                            if (groupSize > this.maxSize[grp]) {
                                double delta = (groupSize - this.maxSize[grp]) / (double)this.ageGroupDuration[grp];
                                int i6 = this.indexM[group];
                                while (i6 < this.indexF[group] + this.ageGroupDuration[grp]) {
                                    double[] dArray7 = nbrMales[t];
                                    int n5 = i6;
                                    dArray7[n5] = dArray7[n5] - delta;
                                    double[] dArray8 = offMales[t];
                                    int n6 = i6++;
                                    dArray8[n6] = dArray8[n6] + delta;
                                }
                            }
                        }
                        ++group;
                    }
                }
                ++month;
            }
            int i = 0;
            while (i < this.maxFemaleAge) {
                nbrVariationF[year][i] = nbrFemales[year * 12][i] - nbrFemales[(year - 1) * 12][i];
                ++i;
            }
            i = 0;
            while (i < this.maxMaleAge) {
                nbrVariationM[year][i] = nbrMales[year * 12][i] - nbrMales[(year - 1) * 12][i];
                ++i;
            }
            if (year < this.pLife) {
                rates = new MonthlyRates(year + 1);
            }
            ++year;
        }
        TimeSeries averageSizeF = new TimeSeries(this.pLife);
        TimeSeries sizeVarF = new TimeSeries(this.pLife);
        TimeSeries offNbrF = new TimeSeries(this.pLife);
        TimeSeries inNbrF = new TimeSeries(this.pLife);
        TimeSeries[] res = this.cumulate(this.nbFemaleClasses, 0, this.indexF, nbrFemales, offFemales, inFemales, nbrVariationF, deaFemales, planResults, level);
        averageSizeF = res[0];
        offNbrF = res[1];
        inNbrF = res[2];
        sizeVarF = res[3];
        planResults.putHerdResult(this.name, HerdResType.TOTAL_FEMALE_NBR, null, null, averageSizeF);
        planResults.putHerdResult(this.name, HerdResType.NBR_OFFTAKE_FEMALE, null, null, offNbrF);
        planResults.putHerdResult(this.name, HerdResType.RTE_OFFTAKE_FEMALE, null, null, offNbrF.divValues(averageSizeF));
        planResults.putHerdResult(this.name, HerdResType.NBR_INTAKE_FEMALE, null, null, inNbrF);
        planResults.putHerdResult(this.name, HerdResType.RTE_INTAKE_FEMALE, null, null, inNbrF.divValues(averageSizeF));
        planResults.putHerdResult(this.name, HerdResType.NBR_VARIATION_FEMALE, null, null, sizeVarF);
        TimeSeries averageSizeM = new TimeSeries(this.pLife);
        TimeSeries sizeVarM = new TimeSeries(this.pLife);
        TimeSeries offNbrM = new TimeSeries(this.pLife);
        TimeSeries inNbrM = new TimeSeries(this.pLife);
        TimeSeries averageSizeTot = new TimeSeries(this.pLife);
        TimeSeries sizeVarTot = new TimeSeries(this.pLife);
        TimeSeries offNbrTot = new TimeSeries(this.pLife);
        TimeSeries inNbrTot = new TimeSeries(this.pLife);
        res = this.cumulate(this.nbMaleClasses, this.nbFemaleClasses, this.indexM, nbrMales, offMales, inMales, nbrVariationM, deaMales, planResults, level);
        averageSizeM = res[0];
        offNbrM = res[1];
        inNbrM = res[2];
        sizeVarM = res[3];
        planResults.putHerdResult(this.name, HerdResType.TOTAL_MALE_NBR, null, null, averageSizeM);
        averageSizeTot = averageSizeM.addValues(averageSizeF);
        planResults.putHerdResult(this.name, HerdResType.TOTAL_NBR, null, null, averageSizeTot);
        planResults.putHerdResult(this.name, HerdResType.NBR_OFFTAKE_MALE, null, null, offNbrM);
        planResults.putHerdResult(this.name, HerdResType.RTE_OFFTAKE_MALE, null, null, offNbrM.divValues(averageSizeM));
        planResults.putHerdResult(this.name, HerdResType.RTE_INTAKE_MALE, null, null, inNbrM.divValues(averageSizeM));
        offNbrTot = offNbrF.addValues(offNbrM);
        planResults.putHerdResult(this.name, HerdResType.NBR_OFFTAKE_TOTAL, null, null, offNbrTot);
        planResults.putHerdResult(this.name, HerdResType.RTE_OFFTAKE_TOTAL, null, null, offNbrTot.divValues(averageSizeTot));
        planResults.putHerdResult(this.name, HerdResType.NBR_INTAKE_MALE, null, null, inNbrM);
        inNbrTot = inNbrF.addValues(inNbrM);
        planResults.putHerdResult(this.name, HerdResType.NBR_INTAKE_TOTAL, null, null, inNbrTot);
        planResults.putHerdResult(this.name, HerdResType.RTE_INTAKE_TOTAL, null, null, inNbrTot.divValues(averageSizeTot));
        planResults.putHerdResult(this.name, HerdResType.NBR_VARIATION_MALE, null, null, sizeVarM);
        sizeVarTot = sizeVarM.addValues(sizeVarF);
        planResults.putHerdResult(this.name, HerdResType.NBR_VARIATION_TOTAL, null, null, sizeVarTot);
        TimeSeries resultM = new TimeSeries(this.pLife);
        TimeSeries resultF = new TimeSeries(this.pLife);
        TimeSeries resultTotProdM = new TimeSeries(this.pLife);
        TimeSeries resultTotProdF = new TimeSeries(this.pLife);
        resultF = sizeVarF.addValues(offNbrF);
        resultF = resultF.substractValues(inNbrF);
        planResults.putHerdResult(this.name, HerdResType.NBR_TOTPROD_FEMALE, null, null, resultF);
        resultM = sizeVarM.addValues(offNbrM);
        resultM = resultM.substractValues(inNbrM);
        planResults.putHerdResult(this.name, HerdResType.NBR_TOTPROD_MALE, null, null, resultM);
        planResults.putHerdResult(this.name, HerdResType.NBR_TOTPROD_TOTAL, null, null, resultM.addValues(resultF));
        resultF = this.setResults(this.nbFemaleClasses, 0, this.sizeVariation, this.offtakePrices);
        resultM = this.setResults(this.nbMaleClasses, this.nbFemaleClasses, this.sizeVariation, this.offtakePrices);
        resultTotProdM = resultTotProdM.addValues(resultM);
        resultTotProdF = resultTotProdF.addValues(resultF);
        planResults.putHerdResult(this.name, HerdResType.FIN_VARIATION_FEMALE, null, null, resultF);
        planResults.putHerdResult(this.name, HerdResType.FIN_VARIATION_MALE, null, null, resultM);
        planResults.putHerdResult(this.name, HerdResType.FIN_VARIATION_TOTAL, null, null, resultM.addValues(resultF));
        resultF = this.setResults(this.nbFemaleClasses, 0, this.offtakeNbr, this.offtakePrices);
        resultM = this.setResults(this.nbMaleClasses, this.nbFemaleClasses, this.offtakeNbr, this.offtakePrices);
        resultTotProdM = resultTotProdM.addValues(resultM);
        resultTotProdF = resultTotProdF.addValues(resultF);
        planResults.putHerdResult(this.name, HerdResType.FIN_OFFTAKE_FEMALE, null, null, resultF);
        planResults.putHerdResult(this.name, HerdResType.FIN_OFFTAKE_MALE, null, null, resultM);
        planResults.putHerdResult(this.name, HerdResType.FIN_OFFTAKE_TOTAL, null, null, resultM.addValues(resultF));
        resultF = this.setResults(this.nbFemaleClasses, 0, this.importNbr, this.intakePrices);
        resultM = this.setResults(this.nbMaleClasses, this.nbFemaleClasses, this.importNbr, this.intakePrices);
        resultTotProdM = resultTotProdM.substractValues(resultM);
        resultTotProdF = resultTotProdF.substractValues(resultF);
        planResults.putHerdResult(this.name, HerdResType.FIN_INTAKE_FEMALE, null, null, resultF);
        planResults.putHerdResult(this.name, HerdResType.FIN_INTAKE_MALE, null, null, resultM);
        planResults.putHerdResult(this.name, HerdResType.FIN_INTAKE_TOTAL, null, null, resultM.addValues(resultF));
        planResults.putHerdResult(this.name, HerdResType.FIN_TOTPROD_FEMALE, null, null, resultTotProdF);
        planResults.putHerdResult(this.name, HerdResType.FIN_TOTPROD_MALE, null, null, resultTotProdM);
        planResults.putHerdResult(this.name, HerdResType.FIN_TOTPROD_TOTAL, null, null, resultTotProdM.addValues(resultTotProdF));
        resultF = this.setResults(this.nbFemaleClasses, 0, this.sizeVariation, this.liveWeights);
        resultM = this.setResults(this.nbMaleClasses, this.nbFemaleClasses, this.sizeVariation, this.liveWeights);
        resultTotProdM = resultTotProdM.addValues(resultM);
        resultTotProdF = resultTotProdF.addValues(resultF);
        resultTotProdM = resultTotProdM.addValues(resultM);
        resultTotProdF = resultTotProdF.addValues(resultF);
        planResults.putHerdResult(this.name, HerdResType.LW_VARIATION_FEMALE, null, null, resultF);
        planResults.putHerdResult(this.name, HerdResType.LW_VARIATION_MALE, null, null, resultM);
        planResults.putHerdResult(this.name, HerdResType.LW_VARIATION_TOTAL, null, null, resultM.addValues(resultF));
        resultF = this.setResults(this.nbFemaleClasses, 0, this.offtakeNbr, this.liveWeights);
        resultM = this.setResults(this.nbMaleClasses, this.nbFemaleClasses, this.offtakeNbr, this.liveWeights);
        resultTotProdM = resultTotProdM.addValues(resultM);
        resultTotProdF = resultTotProdF.addValues(resultF);
        planResults.putHerdResult(this.name, HerdResType.LW_OFFTAKE_FEMALE, null, null, resultF);
        planResults.putHerdResult(this.name, HerdResType.LW_OFFTAKE_MALE, null, null, resultM);
        planResults.putHerdResult(this.name, HerdResType.LW_OFFTAKE_TOTAL, null, null, resultM.addValues(resultF));
        resultF = this.setResults(this.nbFemaleClasses, 0, this.importNbr, this.liveWeights);
        resultM = this.setResults(this.nbMaleClasses, this.nbFemaleClasses, this.importNbr, this.liveWeights);
        resultTotProdM = resultTotProdM.substractValues(resultM);
        resultTotProdF = resultTotProdF.substractValues(resultF);
        planResults.putHerdResult(this.name, HerdResType.LW_INTAKE_FEMALE, null, null, resultF);
        planResults.putHerdResult(this.name, HerdResType.LW_INTAKE_MALE, null, null, resultM);
        planResults.putHerdResult(this.name, HerdResType.LW_INTAKE_TOTAL, null, null, resultM.addValues(resultF));
        planResults.putHerdResult(this.name, HerdResType.LW_TOTPROD_FEMALE, null, null, resultTotProdF);
        planResults.putHerdResult(this.name, HerdResType.LW_TOTPROD_MALE, null, null, resultTotProdM);
        planResults.putHerdResult(this.name, HerdResType.LW_TOTPROD_TOTAL, null, null, resultTotProdM.addValues(resultTotProdF));
        resultF = this.setResults2(this.nbFemaleClasses, 0, this.sizeVariation, this.liveWeights, this.carcassYield);
        resultM = this.setResults2(this.nbMaleClasses, this.nbFemaleClasses, this.sizeVariation, this.liveWeights, this.carcassYield);
        resultTotProdM = resultTotProdM.addValues(resultM);
        resultTotProdF = resultTotProdF.addValues(resultF);
        resultTotProdM = resultTotProdM.addValues(resultM);
        resultTotProdF = resultTotProdF.addValues(resultF);
        planResults.putHerdResult(this.name, HerdResType.MT_VARIATION_FEMALE, null, null, resultF);
        planResults.putHerdResult(this.name, HerdResType.MT_VARIATION_MALE, null, null, resultM);
        planResults.putHerdResult(this.name, HerdResType.MT_VARIATION_TOTAL, null, null, resultM.addValues(resultF));
        resultF = this.setResults2(this.nbFemaleClasses, 0, this.offtakeNbr, this.liveWeights, this.carcassYield);
        resultM = this.setResults2(this.nbMaleClasses, this.nbFemaleClasses, this.offtakeNbr, this.liveWeights, this.carcassYield);
        resultTotProdM = resultTotProdM.addValues(resultM);
        resultTotProdF = resultTotProdF.addValues(resultF);
        planResults.putHerdResult(this.name, HerdResType.MT_OFFTAKE_FEMALE, null, null, resultF);
        planResults.putHerdResult(this.name, HerdResType.MT_OFFTAKE_MALE, null, null, resultM);
        planResults.putHerdResult(this.name, HerdResType.MT_OFFTAKE_TOTAL, null, null, resultM.addValues(resultF));
        resultF = this.setResults2(this.nbFemaleClasses, 0, this.importNbr, this.liveWeights, this.carcassYield);
        resultM = this.setResults2(this.nbMaleClasses, this.nbFemaleClasses, this.importNbr, this.liveWeights, this.carcassYield);
        resultTotProdM = resultTotProdM.substractValues(resultM);
        resultTotProdF = resultTotProdF.substractValues(resultF);
        planResults.putHerdResult(this.name, HerdResType.MT_INTAKE_FEMALE, null, null, resultF);
        planResults.putHerdResult(this.name, HerdResType.MT_INTAKE_MALE, null, null, resultM);
        planResults.putHerdResult(this.name, HerdResType.MT_INTAKE_TOTAL, null, null, resultM.addValues(resultF));
        planResults.putHerdResult(this.name, HerdResType.MT_TOTPROD_FEMALE, null, null, resultTotProdF);
        planResults.putHerdResult(this.name, HerdResType.MT_TOTPROD_MALE, null, null, resultTotProdM);
        planResults.putHerdResult(this.name, HerdResType.MT_TOTPROD_TOTAL, null, null, resultTotProdM.addValues(resultTotProdF));
        TimeSeries totQ = new TimeSeries(this.pLife);
        resultF = this.setResults2(this.nbFemaleClasses, 0, this.herdSize, this.birthRate, this.milkPerLactation);
        totQ = resultF.phasing(level);
        Calc.setCommodityResults(this.milkComm, this.milkCalcType, totQ, planResults);
        Object[] objectArray = this.feedItems;
        int n = this.feedItems.length;
        int n7 = 0;
        while (n7 < n) {
            FeedItem feedItem = objectArray[n7];
            resultF = this.setResults2(this.nbFemaleClasses, 0, this.herdSize, this.liveWeights, feedItem.quantities);
            resultM = this.setResults2(this.nbMaleClasses, this.nbFemaleClasses, this.herdSize, this.liveWeights, feedItem.quantities);
            totQ = resultF.addValues(resultM);
            totQ = totQ.phasing(level);
            Calc.setCommodityResults(feedItem.comm, feedItem.calcType, totQ, planResults);
            ++n7;
        }
        objectArray = this.propItems;
        n = this.propItems.length;
        n7 = 0;
        while (n7 < n) {
            Object propItem = objectArray[n7];
            resultF = this.setResults(this.nbFemaleClasses, 0, this.herdSize, ((PropItem)propItem).quantities);
            resultM = this.setResults(this.nbMaleClasses, this.nbFemaleClasses, this.herdSize, ((PropItem)propItem).quantities);
            totQ = resultF.addValues(resultM);
            totQ = totQ.phasing(level);
            Calc.setCommodityResults(((PropItem)propItem).comm, ((PropItem)propItem).calcType, totQ, planResults);
            ++n7;
        }
    }

    TimeSeries setResults(int nbGroups, int offset, TimeSeries[] nbrs, TimeSeries[] factor) {
        TimeSeries res = new TimeSeries(this.pLife);
        TimeSeries result = new TimeSeries(this.pLife);
        int group = 0;
        while (group < nbGroups) {
            int grp = offset + group;
            res = nbrs[grp].multValues(factor[grp]);
            result = result.addValues(res);
            ++group;
        }
        return result;
    }

    TimeSeries setResults2(int nbGroups, int offset, TimeSeries[] nbrs, TimeSeries[] factor, TimeSeries[] factor2) {
        TimeSeries res = new TimeSeries(this.pLife);
        TimeSeries result = new TimeSeries(this.pLife);
        int group = 0;
        while (group < nbGroups) {
            int grp = offset + group;
            res = nbrs[grp].multValues(factor[grp]);
            res = res.multValues(factor2[grp]);
            result = result.addValues(res);
            ++group;
        }
        return result;
    }

    TimeSeries[] cumulate(int nbGroups, int offset, int[] index, double[][] nbrs, double[][] offtake, double[][] intake, double[][] nbrVariation, double[][] death, PlanResults planResults, TimeSeries level) {
        double[] averageSize = new double[this.pLife];
        double[] sizeVar = new double[this.pLife];
        TimeSeries averageSizeSex = new TimeSeries(this.pLife);
        TimeSeries phasedSize = new TimeSeries(this.pLife);
        TimeSeries sizeVarSex = new TimeSeries(this.pLife);
        double[] valuesOfftake = new double[this.pLife];
        TimeSeries offtakeRte = new TimeSeries(this.pLife);
        TimeSeries offNbrSex = new TimeSeries(this.pLife);
        TimeSeries inNbrSex = new TimeSeries(this.pLife);
        double[] valuesDeath = new double[this.pLife];
        TimeSeries deathRte = new TimeSeries(this.pLife);
        TimeSeries deathNbr = new TimeSeries(this.pLife);
        double[] valuesIn = new double[this.pLife];
        TimeSeries inRte = new TimeSeries(this.pLife);
        int group = 0;
        while (group < nbGroups) {
            int grp = offset + group;
            int year = 1;
            while (year < this.pLife + 1) {
                averageSize[year - 1] = 0.0;
                valuesOfftake[year - 1] = 0.0;
                valuesDeath[year - 1] = 0.0;
                valuesIn[year - 1] = 0.0;
                sizeVar[year - 1] = 0.0;
                int j = index[group];
                while (j < index[group] + this.ageGroupDuration[grp]) {
                    int n = year - 1;
                    averageSize[n] = averageSize[n] + nbrs[(year - 1) * 12][j];
                    int month = 1;
                    while (month < 13) {
                        int t = (year - 1) * 12 + month;
                        int n2 = year - 1;
                        averageSize[n2] = averageSize[n2] + nbrs[t][j];
                        int n3 = year - 1;
                        valuesOfftake[n3] = valuesOfftake[n3] + offtake[t][j];
                        int n4 = year - 1;
                        valuesDeath[n4] = valuesDeath[n4] + death[t][j];
                        ++month;
                    }
                    int n5 = year - 1;
                    valuesIn[n5] = valuesIn[n5] + intake[year][j];
                    int n6 = year - 1;
                    sizeVar[n6] = sizeVar[n6] + nbrVariation[year][j];
                    ++j;
                }
                int n = year - 1;
                averageSize[n] = averageSize[n] / 13.0;
                ++year;
            }
            this.herdSize[grp] = new TimeSeries(this.pLife);
            this.herdSize[grp].setValues(averageSize);
            this.herdLiveWeight[grp] = this.herdSize[grp].multValues(this.liveWeights[grp]);
            phasedSize = this.herdSize[grp].phasing(level);
            averageSizeSex = averageSizeSex.addValues(phasedSize);
            planResults.putHerdResult(this.name, null, HerdDetailedResType.AVERAGE_SIZE, this.classNames[grp], phasedSize);
            this.sizeVariation[grp] = new TimeSeries(this.pLife);
            this.sizeVariation[grp].setValues(sizeVar);
            this.sizeVariation[grp] = this.sizeVariation[grp].phasing(level);
            sizeVarSex = sizeVarSex.addValues(this.sizeVariation[grp]);
            this.offtakeNbr[grp] = new TimeSeries(this.pLife);
            this.offtakeNbr[grp].setValues(valuesOfftake);
            this.offtakeNbr[grp] = this.offtakeNbr[grp].phasing(level);
            offNbrSex = offNbrSex.addValues(this.offtakeNbr[grp]);
            offtakeRte = this.offtakeNbr[grp].divValues(phasedSize);
            planResults.putHerdResult(this.name, null, HerdDetailedResType.OFFTAKE_RATE, this.classNames[grp], offtakeRte);
            deathNbr.setValues(valuesDeath);
            deathNbr = deathNbr.phasing(level);
            deathRte = deathNbr.divValues(phasedSize);
            planResults.putHerdResult(this.name, null, HerdDetailedResType.DEATH_RATE, this.classNames[grp], deathRte);
            this.importNbr[grp] = new TimeSeries(this.pLife);
            this.importNbr[grp].setValues(valuesIn);
            this.importNbr[grp] = this.importNbr[grp].phasing(level);
            inNbrSex = inNbrSex.addValues(this.importNbr[grp]);
            inRte = this.importNbr[grp].divValues(phasedSize);
            planResults.putHerdResult(this.name, null, HerdDetailedResType.INTAKE_RATE, this.classNames[grp], inRte);
            ++group;
        }
        return new TimeSeries[]{averageSizeSex, offNbrSex, inNbrSex, sizeVarSex};
    }

    double[] getMonthlyRates(int year, int ageClass) {
        double deathR = this.deathRates[ageClass].getValues()[year];
        double offtakeR = this.offtakeRates[ageClass].getValues()[year];
        int duration = this.ageGroupDuration[ageClass];
        return this.getMonthlyProbRates(deathR, offtakeR, duration);
    }

    double[] getMonthlyProbRates(double deathProbRate, double offtakeProbRate, int nbOfMonths) {
        double deltahoff;
        double[] monthlyRates = new double[2];
        double tol = 1.0E-15;
        boolean finish = false;
        double hdea = -Math.log(1.0 - deathProbRate);
        double hofft = -Math.log(1.0 - offtakeProbRate);
        do {
            double funchoff = hofft / (hdea + hofft) * (1.0 - Math.exp(-(hdea + hofft))) - offtakeProbRate;
            double derivhoff = (hdea * (1.0 - Math.exp(-(hdea + hofft))) + hofft * (hdea + hofft) * Math.exp(-(hdea + hofft))) / Math.pow(hdea + hofft, 2.0);
            double hofft1 = hofft - funchoff / derivhoff;
            deltahoff = Math.abs(hofft1 - hofft);
            hofft = hofft1;
        } while (!(finish = deltahoff < tol));
        if (nbOfMonths > 12) {
            nbOfMonths = 12;
        }
        double mhdea = hdea / (double)nbOfMonths;
        double mhoff = hofft / (double)nbOfMonths;
        double mhtot = mhdea + mhoff;
        monthlyRates[0] = mhdea / mhtot * (1.0 - Math.exp(-mhtot));
        monthlyRates[1] = mhoff / mhtot * (1.0 - Math.exp(-mhtot));
        return monthlyRates;
    }

    void listOut() {
        MessageConsoleStream out = InOut.out;
        out.println("Herd Input Data");
        out.print(String.format("%n%s = %s, unit = %s%n%n", this.name, this.label, this.unit));
        out.print(String.format("%25s%14s%14s%14s%n", "Age groups", "Duration", "Initial size", "Maximum size"));
        int i = 0;
        while (i < this.nbTotalClasses) {
            out.print(String.format("%-25s  %8d   %12.2f  %12.2f%n", this.catLabels[i], this.ageGroupDuration[i], this.initialSize[i], this.maxSize[i]));
            ++i;
        }
        out.println();
        out.print(String.format("%n%s%n%n", "Demographic parameters"));
        this.listOutDataByCat("Birth rate", this.birthRate, true, out);
        this.listOutDataByCat("Prolificacy rate", this.prolifRate, true, out);
        this.listOutDataByCat("Female at birth rate", this.femAtBirthRate, true, out);
        this.listOutDataByCat("Death Rates", this.deathRates, out);
        this.listOutDataByCat("Offtake Rates", this.offtakeRates, out);
        this.listOutDataByCat("Intake numbers", this.intakeNumbers, out);
        out.print(String.format("%n%s%n%n", "Production parameters"));
        this.listOutDataByCat("Liveweight per head", this.liveWeights, out);
        this.listOutDataByCat("Carcass Yield", this.carcassYield, out);
        out.print(String.format("Dairy production: %s %s%n", this.milkComm.getLabel(), this.milkCalcType.toString()));
        this.listOutDataByCat("Milk Per Lactation", this.milkPerLactation, true, out);
        out.print(String.format("%n%s%n%n", "Animal Prices per head"));
        this.listOutDataByCat("Offtake Prices", this.offtakePrices, out);
        this.listOutDataByCat("Intake Prices", this.intakePrices, out);
        out.print(String.format("%n%s%n%n", "Feed Requirements per kg of LW"));
        Object[] objectArray = this.feedItems;
        int n = this.feedItems.length;
        int n2 = 0;
        while (n2 < n) {
            FeedItem item = objectArray[n2];
            out.print(String.format("Feed item: %s %s%n", item.comm.getLabel(), item.calcType.toString()));
            this.listOutDataByCat("Quantities", item.quantities, out);
            ++n2;
        }
        out.print(String.format("%n%s%n%n", "Proportional items"));
        objectArray = this.propItems;
        n = this.propItems.length;
        n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            out.print(String.format("proportional item: %s %s%n", ((PropItem)item).comm.getLabel(), ((PropItem)item).calcType.toString()));
            this.listOutDataByCat("Quantities", ((PropItem)item).quantities, out);
            ++n2;
        }
        out.println("\n\n");
    }

    void listOutDataByCat(String label, TimeSeries[] data, MessageConsoleStream out) {
        this.listOutDataByCat(label, data, false, out);
    }

    void listOutDataByCat(String label, TimeSeries[] data, Boolean fem, MessageConsoleStream out) {
        out.println(label);
        int nbr = fem != false ? this.nbFemaleClasses : this.nbTotalClasses;
        int cat = 0;
        while (cat < nbr) {
            out.print(String.format("%-" + (this.maxLabel + 2) + "s", this.catLabels[cat]));
            data[cat].printValues(out, 6, 2);
            ++cat;
        }
    }

    class FeedItem {
        CommodityImpl comm;
        CommInPlanType calcType;
        TimeSeries[] quantities;

        FeedItem(HerdFeedItem data) {
            this.comm = (CommodityImpl)data.getCommRef();
            this.calcType = data.getCommCalcType();
            if (this.calcType == null) {
                this.calcType = CommInPlanType.CONS;
            }
            this.quantities = HerdModel.this.setDataByCat(data.getQuantity(), false);
        }
    }

    class MonthlyRates {
        double[] pdeaM;
        double[] poffM;
        double[] psurvM;
        double[] pdeaF;
        double[] poffF;
        double[] psurvF;
        double[] nbintakeM;
        double[] nbintakeF;
        double[] netFfec;
        double[] netMfec;

        MonthlyRates(int year) {
            int j;
            double intake;
            double[] mrates;
            this.pdeaM = new double[HerdModel.this.maxMaleAge + 1];
            this.poffM = new double[HerdModel.this.maxMaleAge + 1];
            this.psurvM = new double[HerdModel.this.maxMaleAge + 1];
            this.nbintakeM = new double[HerdModel.this.maxMaleAge + 1];
            this.pdeaF = new double[HerdModel.this.maxFemaleAge + 1];
            this.poffF = new double[HerdModel.this.maxFemaleAge + 1];
            this.psurvF = new double[HerdModel.this.maxFemaleAge + 1];
            this.nbintakeF = new double[HerdModel.this.maxFemaleAge + 1];
            this.netFfec = new double[HerdModel.this.maxFemaleAge + 1];
            this.netMfec = new double[HerdModel.this.maxFemaleAge + 1];
            int i = 0;
            while (i < HerdModel.this.nbFemaleClasses) {
                mrates = HerdModel.this.getMonthlyRates(year, i);
                intake = HerdModel.this.intakeNumbers[i].getValues()[year] / (double)HerdModel.this.ageGroupDuration[i];
                j = HerdModel.this.indexF[i];
                while (j < HerdModel.this.indexF[i] + HerdModel.this.ageGroupDuration[i]) {
                    this.pdeaF[j] = mrates[0];
                    this.poffF[j] = mrates[1];
                    this.psurvF[j] = 1.0 - mrates[0] - mrates[1];
                    double birth = HerdModel.this.birthRate[i].getValues()[year] / 12.0 * HerdModel.this.prolifRate[i].getValues()[year];
                    this.netFfec[j] = birth * HerdModel.this.femAtBirthRate[i].getValues()[year];
                    this.netMfec[j] = birth - this.netFfec[j];
                    this.nbintakeF[j] = intake;
                    ++j;
                }
                ++i;
            }
            i = HerdModel.this.nbFemaleClasses;
            while (i < HerdModel.this.nbTotalClasses) {
                mrates = HerdModel.this.getMonthlyRates(year, i);
                intake = HerdModel.this.intakeNumbers[i].getValues()[year] / (double)HerdModel.this.ageGroupDuration[i];
                j = HerdModel.this.indexM[i - HerdModel.this.nbFemaleClasses];
                while (j < HerdModel.this.indexM[i - HerdModel.this.nbFemaleClasses] + HerdModel.this.ageGroupDuration[i]) {
                    this.pdeaM[j] = mrates[0];
                    this.poffM[j] = mrates[1];
                    this.psurvM[j] = 1.0 - mrates[0] - mrates[1];
                    this.nbintakeM[j] = intake;
                    ++j;
                }
                ++i;
            }
        }
    }

    class PropItem {
        CommodityImpl comm;
        CommInPlanType calcType;
        TimeSeries[] quantities;

        PropItem(HerdPropItem data) {
            this.comm = (CommodityImpl)data.getCommRef();
            this.calcType = data.getCommCalcType();
            this.quantities = HerdModel.this.setDataByCat(data.getQuantity(), false);
        }
    }
}

