/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.calc;

import fr.msimeon.mads.runModel.calc.ExportIRR_full;
import fr.msimeon.mads.runModel.calc.ExportTable;
import fr.msimeon.mads.runModel.calc.TimeSeries;
import fr.msimeon.mads.runModel.console.MadsConsole;
import fr.msimeon.mads.runModel.odfdom.ODFSpreadsheet_IO;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.progress.IProgressConstants;
import org.odftoolkit.simple.SpreadsheetDocument;

public class InOut {
    static String bb1 = "<b><big>";
    static String bb2 = "</big></b>";
    static String bbb1 = "<b><big><big>";
    static String bbb2 = "</big></big></b>";
    static String em1 = "<em>";
    static String em2 = "</em>";
    public static MessageConsoleStream out = new MadsConsole(2).getConsoleStream();
    public static MessageConsoleStream err = new MadsConsole(3).getConsoleStream();
    public static final int FILE_CREATION_ERROR = 1;
    public static final int ABORTED = 3;
    public static final int FILE_CONNECT_ERROR = 2;
    public static final int FILE_OK = 0;
    public static final int FILE_DOES_NOT_LOAD = 4;
    public static final int FILE_DOES_NOT_SAVE = 5;

    public static void outputTS(TimeSeries ts, String label, String cmdKW) {
        out.print(String.valueOf(label) + " ");
        ts.printValues(out);
    }

    public static void outputTS(TimeSeries ts, String label, IDocument doc, Boolean isHtml) {
        try {
            doc.replace(doc.getLength(), 0, String.valueOf(label) + " ");
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        ts.printValues(doc, isHtml);
    }

    static void lineOut(String c, int length, IDocument doc) {
        String line = "";
        int i = 0;
        while (i < length) {
            line = String.valueOf(line) + c;
            ++i;
        }
        InOut.outputString(line, doc);
        InOut.outputLF(doc);
    }

    static void outputLF(IDocument doc, Boolean isHtml) {
        if (isHtml.booleanValue()) {
            InOut.outputString("<br/>\n", doc);
        } else {
            InOut.outputString("\n", doc);
        }
    }

    static void outputLF(IDocument doc) {
        InOut.outputString("\n", doc);
    }

    public static void outputString(String s, IDocument doc) {
        try {
            doc.replace(doc.getLength(), 0, s);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public static void outputString(String s, String tag1, String tag2, IDocument doc) {
        String ss = String.valueOf(tag1) + s + tag2;
        try {
            doc.replace(doc.getLength(), 0, ss);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public static void outputHeaders(String[] headers, Boolean isHtml, IDocument doc) {
        if (isHtml.booleanValue()) {
            InOut.outputString(String.valueOf(headers[0]) + " - " + headers[1], bbb1, bbb2, doc);
        } else {
            InOut.outputString(String.valueOf(headers[0]) + " - " + headers[1], doc);
        }
        InOut.outputLF(doc, isHtml);
        if (isHtml.booleanValue()) {
            InOut.outputString(headers[2], bb1, bb2, doc);
        } else {
            InOut.outputString(headers[2], doc);
        }
        InOut.outputLF(doc, isHtml);
    }

    public static void outputTable_html(String[] headers, ArrayList<Integer> tYears, ArrayList<String> lineLabels, ArrayList<String> footnotes, ArrayList<Integer> decDigits, ArrayList<Boolean> isLineTitle, double[][] values, double tScale, boolean totals, boolean[] skipYear, ArrayList<String> yearGroupLabels, IDocument doc) {
        InOut.outputLF(doc, true);
        int nbYears = tYears.size();
        int nbOfYearHeaders = 0;
        String[] yearHeaders = null;
        if (yearGroupLabels != null) {
            nbOfYearHeaders = yearGroupLabels.size();
            int i = 0;
            while (i < nbOfYearHeaders) {
                yearHeaders = new String[nbOfYearHeaders];
                ++i;
            }
            i = 0;
            while (i < nbOfYearHeaders) {
                yearHeaders[i] = yearGroupLabels.get(i);
                ++i;
            }
        }
        String s = "";
        InOut.outputString("<table summary = \"\" border=\"1\">\n<caption>", doc);
        s = String.valueOf(bb1) + headers[0] + "<br/>\n" + headers[1] + "<br/>\n" + bb2 + em1 + headers[2] + em2 + "<br/>\n" + bb1 + headers[3] + bb2 + "<br/>\n" + bbb1 + headers[4] + bbb2 + "<br/>\n";
        int i = 5;
        while (i < headers.length) {
            s = String.valueOf(s) + em1 + headers[i] + em2 + "<br/>\n";
            ++i;
        }
        if (tScale != 1.0) {
            String sf = String.format("All values in table scaled by a factor of %1.4g", tScale);
            s = String.valueOf(s) + em1 + sf + em2;
        }
        InOut.outputString(String.valueOf(s) + "</caption>\n", doc);
        if (yearGroupLabels != null) {
            nbOfYearHeaders = yearGroupLabels.size();
            int yearGroupSize = nbYears / nbOfYearHeaders;
            InOut.outputString("<thead><tr><th></th>", doc);
            int i2 = 0;
            while (i2 < nbOfYearHeaders) {
                InOut.outputString("<th colspan=\"" + yearGroupSize + "\" align=center>" + yearHeaders[i2] + "</th>", doc);
                ++i2;
            }
        }
        InOut.outputString("<thead><tr><th></th>", doc);
        int yr = 0;
        while (yr < nbYears) {
            if (!skipYear[yr]) {
                int nextYr = yr;
                while (nextYr + 1 < nbYears && skipYear[nextYr + 1]) {
                    ++nextYr;
                }
                s = nextYr == yr ? String.format("%d", tYears.get(yr)) : String.format(String.valueOf(tYears.get(yr).toString()) + "-" + tYears.get(nextYr).toString(), new Object[0]);
                InOut.outputString("<th align=center>" + s + "</th>", doc);
            }
            ++yr;
        }
        if (totals) {
            InOut.outputString("<th align=center>Total</th>", doc);
        }
        InOut.outputString("\n</thead>\n<tbody>\n", doc);
        int lineIndex = 0;
        int labelIndex = 0;
        while (labelIndex < lineLabels.size()) {
            String lbl = lineLabels.get(labelIndex);
            Boolean isTitle = isLineTitle.get(labelIndex);
            if (isTitle.booleanValue()) {
                InOut.outputString("<tr><td align=left colspan=10><em>" + lbl + "</em></td>\n", doc);
            } else {
                InOut.outputString("<tr><th align=left>" + lbl + "</th>", doc);
                String f = "%,1." + decDigits.get(lineIndex) + "f";
                int yr2 = 0;
                while (yr2 < nbYears) {
                    if (!skipYear[yr2]) {
                        InOut.outputString("<td align=right>" + String.format(f, values[lineIndex][yr2]), doc);
                    }
                    ++yr2;
                }
                if (totals) {
                    InOut.outputString("<td align=right>" + String.format(f, values[lineIndex][nbYears]), doc);
                }
                ++lineIndex;
            }
            InOut.outputString("</tr>\n", doc);
            ++labelIndex;
        }
        InOut.outputString("\n</tbody></table>\n", doc);
        int i3 = 0;
        while (i3 < footnotes.size()) {
            InOut.outputString(footnotes.get(i3), doc);
            InOut.outputLF(doc, true);
            ++i3;
        }
        InOut.outputLF(doc, true);
    }

    public static void exportTable(String[] headers, ArrayList<Integer> tYears, ArrayList<String> lineLabels, ArrayList<String> footnotes, ArrayList<Integer> decDigits, ArrayList<Boolean> isLineTitle, double[][] values, double tScale, boolean totals, int width, boolean[] skipYear, ArrayList<String> yearGroupLabels, String worksheetName, String fSpec) {
        ExportTable job = new ExportTable(headers, tYears, lineLabels, footnotes, decDigits, isLineTitle, values, tScale, totals, width, skipYear, yearGroupLabels, worksheetName, fSpec);
        job.setProperty(IProgressConstants.KEEP_PROPERTY, "Export Successfull");
        job.setUser(true);
        job.schedule();
    }

    public static void outputTable_plain(String[] headers, ArrayList<Integer> tYears, ArrayList<String> lineLabels, ArrayList<String> footnotes, ArrayList<Integer> decDigits, ArrayList<Boolean> isLineTitle, double[][] values, double tScale, boolean totals, int width, boolean[] skipYear, ArrayList<String> yearGroupLabels, IDocument doc) {
        int lw;
        InOut.outputLF(doc);
        TableLayout layout = new TableLayout(tYears, decDigits, values, width, lineLabels, isLineTitle, yearGroupLabels, skipYear, totals);
        width = layout.width;
        int labelWidth = layout.labelWidth;
        String[] yearHeaders = layout.yearHeaders;
        int nbOfYearHeaders = layout.nbOfYearHeaders;
        boolean yearGroupLabelsSplit = layout.yearGroupLabelsSplit;
        int availableWidth = layout.availableWidth;
        int nbYears = layout.nbYears;
        int totWidth = layout.totWidth;
        String s = "";
        String[] stringArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            lw = (header.length() + totWidth) / 2;
            InOut.outputString(String.format("%" + lw + "s", header), doc);
            InOut.outputLF(doc);
            ++n2;
        }
        if (tScale != 1.0) {
            String sf = String.format("All values in table scaled by a factor of %1.4g", tScale);
            InOut.outputString(sf, doc);
            InOut.outputLF(doc);
        }
        InOut.lineOut("=", totWidth, doc);
        if (yearGroupLabels != null) {
            InOut.outputString(String.format("%-" + (labelWidth - 1) + "s ", " "), doc);
            int i = 0;
            while (i < nbOfYearHeaders) {
                InOut.outputString(String.format("%" + (availableWidth + 1) + "s ", yearHeaders[i]), doc);
                ++i;
            }
            InOut.outputLF(doc);
            if (yearGroupLabelsSplit) {
                InOut.outputString(String.format("%" + (labelWidth - 1) + "s ", " "), doc);
                i = nbOfYearHeaders;
                while (i < nbOfYearHeaders * 2) {
                    lw = (yearHeaders[i].length() + availableWidth) / 2;
                    InOut.outputString(String.format("%" + (availableWidth + 1) + "s ", yearHeaders[i]), doc);
                    ++i;
                }
                InOut.outputLF(doc);
            }
        }
        InOut.outputString(String.format("%-" + (labelWidth - 2) + "s ", " "), doc);
        int yr = 0;
        while (yr < nbYears) {
            if (!skipYear[yr]) {
                int nextYr = yr;
                while (nextYr + 1 < nbYears && skipYear[nextYr + 1]) {
                    ++nextYr;
                }
                s = nextYr == yr ? String.format("%" + (width + 1) + "d", tYears.get(yr)) : String.format("%" + (width + 1) + "s", String.valueOf(tYears.get(yr).toString()) + "-" + tYears.get(nextYr).toString());
                InOut.outputString(s, doc);
            }
            ++yr;
        }
        if (totals) {
            InOut.outputString(String.format("%" + (width + 1) + "s", "Total"), doc);
        }
        InOut.outputLF(doc);
        InOut.lineOut("-", totWidth, doc);
        int lineIndex = 0;
        int labelIndex = 0;
        while (labelIndex < lineLabels.size()) {
            String lbl = lineLabels.get(labelIndex);
            Boolean isTitle = isLineTitle.get(labelIndex);
            if (isTitle.booleanValue() && labelIndex > 0) {
                InOut.outputLF(doc);
            }
            InOut.outputString(String.format("%-" + labelWidth + "s ", lbl), doc);
            isTitle = isLineTitle.get(labelIndex);
            if (!isTitle.booleanValue()) {
                String f = "%," + width + "." + decDigits.get(lineIndex) + "f ";
                int yr2 = 0;
                while (yr2 < nbYears) {
                    if (!skipYear[yr2]) {
                        InOut.outputString(String.format(f, values[lineIndex][yr2]), doc);
                    }
                    ++yr2;
                }
                if (totals) {
                    InOut.outputString(String.format(f, values[lineIndex][nbYears]), doc);
                }
                ++lineIndex;
            }
            InOut.outputLF(doc);
            if (isTitle.booleanValue()) {
                InOut.lineOut("-", lbl.length(), doc);
            }
            ++labelIndex;
        }
        InOut.lineOut("=", totWidth, doc);
        int i = 0;
        while (i < footnotes.size()) {
            InOut.outputString(footnotes.get(i), doc);
            InOut.outputLF(doc);
            ++i;
        }
        InOut.outputLF(doc);
    }

    static String[] hSplit(String h) {
        String[] res = new String[2];
        String[] hSplit = h.split(" ");
        int l = h.length();
        int i = 0;
        String h1 = hSplit[0];
        while (i < hSplit.length - 1 && h1.length() + 2 < l / 2) {
            h1 = String.valueOf(h1) + " " + hSplit[i + 1];
            ++i;
        }
        String h2 = h.substring(h1.length() + 1);
        res[0] = h1;
        res[1] = h2;
        return res;
    }

    public static void exportTS(TimeSeries ts, String dataID, String tableName, String fileSpec) {
        double[] data = ts.getValues();
        ODFSpreadsheet_IO.setValues(data, fileSpec, tableName, dataID);
    }

    public static TimeSeries importTS(String vName, String tName, String fSpec, int pLife) {
        TimeSeries ts = new TimeSeries(pLife);
        Double[] data = ODFSpreadsheet_IO.getValues(fSpec, tName, vName);
        if (data != null) {
            ts.setValues(data);
        } else {
            ts.setValues(Double.NaN);
        }
        return ts;
    }

    static void listRoot(Object result, IDocument doc, Boolean isHtml) {
        if (result instanceof Double) {
            Double rate = (Double)result;
            if (isHtml.booleanValue()) {
                InOut.outputString(String.format("Rate of return = %,1.2f%%", rate), bb1, bb2, doc);
            } else {
                InOut.outputString(String.format("Rate of return = %,1.2f%%", rate), doc);
            }
            InOut.outputLF(doc, isHtml);
        } else if (isHtml.booleanValue()) {
            InOut.outputString("IRR : " + result, bb1, bb2, doc);
        } else {
            InOut.outputString("IRR : " + result, doc);
        }
        InOut.outputLF(doc, isHtml);
    }

    public static void listIRR(String label, double npv, double oCC, Object result, IDocument doc, Boolean isHtml) {
        if (doc == null) {
            return;
        }
        InOut.outputLF(doc, isHtml);
        InOut.outputLF(doc, isHtml);
        if (isHtml.booleanValue()) {
            InOut.outputString(String.format("%s<br>Net Present Value = %,1.2f (at OCC = %,1.2f per cent)", label, npv, oCC), bb1, bb2, doc);
        } else {
            InOut.outputString(String.format("%s\nNet Present Value = %,1.2f (at OCC = %,1.2f per cent)", label, npv, oCC), doc);
        }
        InOut.outputLF(doc, isHtml);
        InOut.listRoot(result, doc, isHtml);
    }

    public static void listIRR(String label, double[] npv, String[] varLabels, double oCC, double bal, Object result, IDocument doc, Boolean isHtml) {
        String swLabel;
        if (doc == null) {
            return;
        }
        int nbRes = npv.length;
        double[] sw = new double[nbRes];
        int width = 0;
        int i = 0;
        while (i < nbRes) {
            width = Math.max(width, varLabels[i].length());
            ++i;
        }
        width = Math.max(width, 16);
        InOut.outputLF(doc, isHtml);
        if (isHtml.booleanValue()) {
            InOut.outputString(label, bb1, bb2, doc);
        } else {
            InOut.outputString(label, doc);
        }
        InOut.outputLF(doc, isHtml);
        InOut.outputLF(doc, isHtml);
        InOut.listRoot(result, doc, isHtml);
        if (isHtml.booleanValue()) {
            InOut.outputString("</font></font>\n<table summary = \"\" border=\"1\">\n<caption>", doc);
            swLabel = "<b>Present and switching values<br></b><em>(Opportunity cost of capital = ";
            String swLabel2 = ")</em></caption>\n<col width=\"40%,30%,30%\" ><col align=right><col align=right>\n<thead><tr><th></th><th>Present Values</th><th align=center>Switching Values<br>Per cent</th></tr></thead>\n";
            InOut.outputString(String.format("%s%,1.2f%%%s", swLabel, oCC, swLabel2), doc);
        } else {
            swLabel = "Present and switching values\n(Opportunity cost of capital = ";
            InOut.outputString(String.format("%s%,1.2f%%)\n\n", swLabel, oCC), doc);
        }
        if (!isHtml.booleanValue()) {
            InOut.outputString(String.format("%" + (width + 17) + "s%20s", "Present Values", "Switching Values"), doc);
            InOut.outputLF(doc, isHtml);
            InOut.outputString(String.format("%" + (width + 33) + "s", "Per cent"), doc);
            InOut.outputLF(doc, isHtml);
        } else {
            InOut.outputString("<tbody>\n", doc);
        }
        int i2 = 0;
        while (i2 < nbRes) {
            sw[i2] = -100.0 * bal / npv[i2];
            if (isHtml.booleanValue()) {
                InOut.outputString(String.format("<tr><td>%s<td>%,15.2f<td>%,20.2f%%\n", varLabels[i2], npv[i2], sw[i2]), doc);
            } else {
                InOut.outputString(String.format("%-" + width + "s%,15.2f%,20.2f%%", varLabels[i2], npv[i2], sw[i2]), doc);
                InOut.outputLF(doc, isHtml);
            }
            ++i2;
        }
        if (isHtml.booleanValue()) {
            InOut.outputString(String.format("%s%,15.2f%s", "<tr><td align=right>Net Balance</td><td>", bal, "</td><td>--</td></tr>\n</tbody></table>\n"), doc);
        } else {
            InOut.outputString(String.format("%-" + width + "s%,15.2f", "     Net Balance", bal), doc);
        }
        InOut.outputLF(doc, isHtml);
        InOut.outputLF(doc, isHtml);
    }

    public static void exportIRR(String[] headers, double[] npv, String[] varLabels, double oCC, double bal, Object result, String fSpec, String worksheet) {
        ExportIRR_full job = new ExportIRR_full(headers, npv, varLabels, oCC, bal, result, fSpec, worksheet);
        job.setUser(true);
        job.setProperty(IProgressConstants.KEEP_PROPERTY, "Export Successfull");
        job.schedule();
    }

    public static void exportIRR(String[] headers, double npv, double oCC, Object result, String fSpec, String worksheet) {
        int nbHeaders = headers.length;
        ODFSpreadsheet_IO ods = new ODFSpreadsheet_IO(fSpec, worksheet, true, 3, nbHeaders + 1);
        ods.setCell(0, 0, 2, 0, "left", null, String.valueOf(headers[0]) + " - " + headers[1], ods.h1StyleName, null, null);
        int i = 2;
        while (i < nbHeaders) {
            ods.setCell(0, i - 1, 2, 0, "left", null, headers[i], ods.h2StyleName, null, null);
            ++i;
        }
        ods.setCell(0, nbHeaders - 1, 1, 0, "left", null, "OCC", ods.tlStyleName, null, null);
        ods.setCell(1, nbHeaders - 1, 1, 0, null, null, null, ods.dStyleName, oCC / 100.0, true);
        ods.setCell(0, nbHeaders, 1, 0, "left", null, "Net Present Value", ods.tlStyleName, null, null);
        ods.setCell(1, nbHeaders, 1, 0, null, null, null, ods.dStyleName, npv, false);
        ods.setCell(0, nbHeaders + 1, 1, 0, "left", null, "IRR", ods.tlStyleName, null, null);
        if (result instanceof Double) {
            ods.setCell(1, nbHeaders + 1, 1, 0, null, null, null, ods.dStyleName, (Double)result / 100.0, true);
        } else {
            ods.setCell(1, nbHeaders + 1, 1, 0, "left", null, (String)result, ods.dStyleName, null, null);
        }
        ods.save();
        ods.close();
    }

    static void notImpl(String mess) {
        err.println(String.valueOf(mess) + ": not implemented");
    }

    public static void showMessage(String header, String message, Boolean error) {
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
        if (error.booleanValue()) {
            MessageDialog.openError((Shell)shell, (String)header, (String)message);
        } else {
            MessageDialog.openInformation((Shell)shell, (String)header, (String)message);
        }
        shell.dispose();
    }

    public static int checkODSFile(String fSpec, String text) {
        String title = String.valueOf(text) + " Export File Specification";
        File file = new File(fSpec);
        if (file.exists()) {
            SpreadsheetDocument odsDoc;
            try {
                odsDoc = SpreadsheetDocument.loadDocument((File)file);
            }
            catch (Exception exception) {
                String message = "File " + fSpec + " exists but could not be loaded" + "\nMake sure it is an ODS file";
                InOut.showMessage(title, message, true);
                return 4;
            }
            try {
                odsDoc.save(fSpec);
                odsDoc.close();
                return 0;
            }
            catch (Exception exception) {
                String message = "File " + fSpec + " exists but cannot be saved" + "\nMake sure it is not open by an other application";
                InOut.showMessage(title, message, true);
                return 5;
            }
        }
        String message = "File " + fSpec + " does not exist\nDo you want to create it ?";
        if (!MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message)) {
            return 3;
        }
        try {
            SpreadsheetDocument odsDoc = SpreadsheetDocument.newSpreadsheetDocument();
            odsDoc.save(fSpec);
            odsDoc.close();
            message = "File " + fSpec + " was created successfuly";
            InOut.showMessage(title, message, false);
        }
        catch (Exception exception) {
            message = "Creation of File " + fSpec + " was unsuccessfuly";
            InOut.showMessage(title, message, true);
            return 1;
        }
        return 0;
    }

    static class TableLayout {
        int width;
        int labelWidth;
        int nbOfYearHeaders = 0;
        int availableWidth = 0;
        int nbYears;
        int totWidth;
        int totColNbr;
        boolean yearGroupLabelsSplit = false;
        String[] yearHeaders = null;

        TableLayout(ArrayList<Integer> tYears, ArrayList<Integer> decDigits, double[][] values, int wdth, ArrayList<String> lineLabels, ArrayList<Boolean> isLineTitle, ArrayList<String> yearGroupLabels, boolean[] skipYear, boolean totals) {
            this.width = wdth;
            if (this.width == 0) {
                int line = 0;
                while (line < values.length) {
                    String f = "%,1." + decDigits.get(line) + "f";
                    int yr = 0;
                    while (yr < values[0].length) {
                        this.width = Math.max(this.width, String.format(f, values[line][yr]).length());
                        ++yr;
                    }
                    ++line;
                }
                ++this.width;
            }
            int labelIndex = 0;
            while (labelIndex < lineLabels.size()) {
                if (!isLineTitle.get(labelIndex).booleanValue()) {
                    this.labelWidth = Math.max(this.labelWidth, lineLabels.get(labelIndex).length());
                }
                ++labelIndex;
            }
            this.nbYears = tYears.size();
            int yearHeadersWidth = 0;
            if (yearGroupLabels != null) {
                this.nbOfYearHeaders = yearGroupLabels.size();
                int yearGroupSize = this.nbYears / this.nbOfYearHeaders;
                this.availableWidth = this.width * yearGroupSize;
                int i = 0;
                while (i < this.nbOfYearHeaders) {
                    yearHeadersWidth = Math.max(yearHeadersWidth, yearGroupLabels.get(i).length());
                    ++i;
                }
                if (yearHeadersWidth > this.availableWidth) {
                    this.yearGroupLabelsSplit = true;
                    this.yearHeaders = new String[this.nbOfYearHeaders * 2];
                    yearHeadersWidth = 0;
                    i = 0;
                    while (i < this.nbOfYearHeaders) {
                        String header = yearGroupLabels.get(i);
                        if (header.length() <= this.availableWidth) {
                            this.yearHeaders[i] = " ";
                            this.yearHeaders[i + this.nbOfYearHeaders] = header;
                        } else {
                            String[] hSplit = InOut.hSplit(header);
                            yearHeadersWidth = Math.max(yearHeadersWidth, hSplit[0].length());
                            yearHeadersWidth = Math.max(yearHeadersWidth, hSplit[1].length());
                            this.yearHeaders[i] = hSplit[0];
                            this.yearHeaders[i + this.nbOfYearHeaders] = hSplit[1];
                        }
                        ++i;
                    }
                    if (++yearHeadersWidth > this.availableWidth) {
                        this.width = yearHeadersWidth / yearGroupSize;
                        this.availableWidth = this.width * yearGroupSize;
                    }
                } else {
                    this.yearHeaders = new String[this.nbOfYearHeaders];
                    i = 0;
                    while (i < this.nbOfYearHeaders) {
                        this.yearHeaders[i] = yearGroupLabels.get(i);
                        ++i;
                    }
                }
            }
            int nbToSkip = 0;
            boolean[] blArray = skipYear;
            int n = skipYear.length;
            int n2 = 0;
            while (n2 < n) {
                boolean skip = blArray[n2];
                if (skip) {
                    ++nbToSkip;
                }
                ++n2;
            }
            this.totColNbr = this.nbYears - nbToSkip;
            this.totWidth = this.labelWidth + this.totColNbr * (this.width + 1);
            if (totals) {
                this.totWidth += this.width + 1;
                this.totColNbr += 2;
            } else {
                ++this.totColNbr;
            }
        }
    }
}

