/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.calc;

import fr.msimeon.mads.mads.AtomID;
import fr.msimeon.mads.mads.CommResType;
import fr.msimeon.mads.mads.Command;
import fr.msimeon.mads.mads.CommodityReference;
import fr.msimeon.mads.mads.ExportCmd;
import fr.msimeon.mads.mads.HerdDetailedResType;
import fr.msimeon.mads.mads.HerdReference;
import fr.msimeon.mads.mads.HerdResType;
import fr.msimeon.mads.mads.PlanInPlanType;
import fr.msimeon.mads.mads.ScriptItem;
import fr.msimeon.mads.mads.VariableReference;
import fr.msimeon.mads.mads.impl.TableImpl;
import fr.msimeon.mads.runModel.calc.CommodityResult;
import fr.msimeon.mads.runModel.calc.HerdResult;
import fr.msimeon.mads.runModel.calc.IPlanResults;
import fr.msimeon.mads.runModel.calc.InOut;
import fr.msimeon.mads.runModel.calc.TimeSeries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.ui.console.MessageConsoleStream;

public class PlanResults
implements IPlanResults {
    private HashMap<String, CommodityResult> commodityResults = new HashMap();
    private HashMap<String, HerdResult> herdResults = new HashMap();
    private HashMap<String, TimeSeries> globalVarResults = new HashMap();
    private HashMap<String, TimeSeries> localVarResults = new HashMap();
    private Iterable<ScriptItem> commands = new ArrayList<ScriptItem>();

    @Override
    public void putCommodityResult(String commodityID, CommResType ctype, TimeSeries res) {
        CommodityResult commRes = this.commodityResults.containsKey(commodityID) ? this.commodityResults.get(commodityID) : new CommodityResult();
        commRes.putRes(ctype, res);
        this.commodityResults.put(commodityID, commRes);
    }

    @Override
    public TimeSeries getCommodityResult(String commodityID, CommResType ctype) {
        if (this.commodityResults.containsKey(commodityID)) {
            CommodityResult commRes = this.commodityResults.get(commodityID);
            TimeSeries ts = commRes.getRes(ctype);
            return ts;
        }
        return null;
    }

    @Override
    public void putHerdResult(String herdID, HerdResType ctype, HerdDetailedResType dtype, String hClass, TimeSeries res) {
        HerdResult herdRes = this.herdResults.containsKey(herdID) ? this.herdResults.get(herdID) : new HerdResult();
        herdRes.putRes(ctype, dtype, hClass, res);
        this.herdResults.put(herdID, herdRes);
    }

    @Override
    public TimeSeries getHerdResult(String herdID, HerdResType ctype, HerdDetailedResType dtype, String hClass) {
        if (this.herdResults.containsKey(herdID)) {
            HerdResult herdRes = this.herdResults.get(herdID);
            TimeSeries ts = herdRes.getRes(ctype, dtype, hClass);
            return ts;
        }
        return null;
    }

    @Override
    public void putGlobalVarResult(String varName, TimeSeries res) {
        if (this.globalVarResults.containsKey(varName)) {
            res = res.addValues(this.globalVarResults.put(varName, res));
        }
        this.globalVarResults.put(varName, res);
    }

    @Override
    public void putLocalVarResult(String varName, TimeSeries res) {
        if (this.localVarResults.containsKey(varName)) {
            res = res.addValues(this.localVarResults.put(varName, res));
        }
        this.localVarResults.put(varName, res);
    }

    @Override
    public TimeSeries getGlobalVarResult(String varName) {
        if (this.globalVarResults.containsKey(varName)) {
            TimeSeries ts = this.globalVarResults.get(varName);
            return ts;
        }
        return null;
    }

    @Override
    public TimeSeries getLocalVarResult(String varName) {
        if (this.localVarResults.containsKey(varName)) {
            TimeSeries ts = this.localVarResults.get(varName);
            return ts;
        }
        return null;
    }

    @Override
    public Iterable<ScriptItem> getCommands() {
        return this.commands;
    }

    @Override
    public void addCommand(ScriptItem cmd) {
        ((ArrayList)this.commands).add(cmd);
    }

    public void listOut() {
        TimeSeries ts;
        TimeSeries ts2;
        int n;
        Object[] objectArray;
        String key;
        String[] keys;
        MessageConsoleStream out = InOut.out;
        out.println("Plan Results");
        out.println("\nCommodities");
        Set<String> keysSet = this.commodityResults.keySet();
        String[] stringArray = keys = keysSet.toArray(new String[keysSet.size()]);
        int n2 = keys.length;
        int n3 = 0;
        while (n3 < n2) {
            CommResType[] resTypes;
            key = stringArray[n3];
            out.println(key);
            CommodityResult commRes = this.commodityResults.get(key);
            objectArray = resTypes = commRes.getTypes();
            n = resTypes.length;
            int n4 = 0;
            while (n4 < n) {
                CommResType ctype = objectArray[n4];
                ts2 = commRes.getRes(ctype);
                out.println(String.valueOf(key) + " " + ctype.getName());
                ts2.printValues(out, 6, 2);
                ++n4;
            }
            ++n3;
        }
        out.println("\nHerds");
        keysSet = this.herdResults.keySet();
        stringArray = keys = keysSet.toArray(new String[keysSet.size()]);
        n2 = keys.length;
        n3 = 0;
        while (n3 < n2) {
            CommResType hClass;
            key = stringArray[n3];
            HerdResult herdRes = this.herdResults.get(key);
            String[] classNames = herdRes.getClassIDs();
            out.println("\n" + key + "\nHerd Size");
            objectArray = classNames;
            n = classNames.length;
            int n5 = 0;
            while (n5 < n) {
                hClass = objectArray[n5];
                ts2 = herdRes.getRes(null, HerdDetailedResType.AVERAGE_SIZE, (String)hClass);
                out.println(String.valueOf(key) + " " + (String)hClass);
                ts2.printValues(out, 6, 4);
                ++n5;
            }
            out.println("\n" + key + "\nOfftake Rates");
            objectArray = classNames;
            n = classNames.length;
            n5 = 0;
            while (n5 < n) {
                hClass = objectArray[n5];
                ts2 = herdRes.getRes(null, HerdDetailedResType.OFFTAKE_RATE, (String)hClass);
                if (ts2 != null) {
                    out.println(String.valueOf(key) + " " + (String)hClass);
                    ts2.printValues(out, 6, 4);
                }
                ++n5;
            }
            out.println("\n" + key + "\nMortality Rates");
            objectArray = classNames;
            n = classNames.length;
            n5 = 0;
            while (n5 < n) {
                hClass = objectArray[n5];
                ts2 = herdRes.getRes(null, HerdDetailedResType.DEATH_RATE, (String)hClass);
                if (ts2 != null) {
                    out.println(String.valueOf(key) + " " + (String)hClass);
                    ts2.printValues(out, 6, 4);
                }
                ++n5;
            }
            out.println("\n" + key + "\nIntake Rates");
            objectArray = classNames;
            n = classNames.length;
            n5 = 0;
            while (n5 < n) {
                hClass = objectArray[n5];
                ts2 = herdRes.getRes(null, HerdDetailedResType.INTAKE_RATE, (String)hClass);
                if (ts2 != null) {
                    out.println(String.valueOf(key) + " " + (String)hClass);
                    ts2.printValues(out, 6, 4);
                }
                ++n5;
            }
            HerdResType[] resTypes = herdRes.getTypes();
            out.println("\n" + key + "\nOther Results");
            HerdResType[] herdResTypeArray = resTypes;
            int n6 = resTypes.length;
            n = 0;
            while (n < n6) {
                HerdResType ctype = herdResTypeArray[n];
                TimeSeries ts3 = herdRes.getRes(ctype, null, null);
                out.println(String.valueOf(key) + " " + ctype.getName());
                ts3.printValues(out, 6, 2);
                ++n;
            }
            ++n3;
        }
        out.println("\nGlobal variables");
        keysSet = this.globalVarResults.keySet();
        stringArray = keys = keysSet.toArray(new String[keysSet.size()]);
        n2 = keys.length;
        n3 = 0;
        while (n3 < n2) {
            key = stringArray[n3];
            ts = this.globalVarResults.get(key);
            out.println(key);
            ts.printValues(out, 6, 2);
            ++n3;
        }
        out.println("\nLocal variables");
        keysSet = this.localVarResults.keySet();
        stringArray = keys = keysSet.toArray(new String[keysSet.size()]);
        n2 = keys.length;
        n3 = 0;
        while (n3 < n2) {
            key = stringArray[n3];
            ts = this.localVarResults.get(key);
            out.println(key);
            ts.printValues(out, 6, 2);
            ++n3;
        }
        out.println("\nCommands");
        for (ScriptItem command : this.commands) {
            if (command instanceof Command) {
                VariableReference varRef;
                Command cmd = (Command)command;
                String s = "print ";
                CommodityReference commRef = cmd.getCommItem();
                s = commRef != null ? String.valueOf(s) + commRef.getCommRef().getName() : ((varRef = cmd.getVarRef()) != null ? String.valueOf(s) + varRef.getVarRef().getName() : String.valueOf(s) + cmd.getTableRef().getName());
                if (cmd.getLabel() != null) {
                    s = String.valueOf(s) + " as " + cmd.getLabel();
                }
                out.println(s);
                continue;
            }
            if (!(command instanceof ExportCmd)) continue;
            ExportCmd cmd = (ExportCmd)command;
            String worksheetName = cmd.getWorksheet();
            if (worksheetName == null) {
                worksheetName = "Sheet1";
            }
            String fileSpec = cmd.getFileRef().getFileSpec();
            TableImpl table = (TableImpl)cmd.getTabRef();
            String s = "export ";
            if (table == null) {
                String dataID = cmd.getData();
                AtomID atom = cmd.getAtomRef();
                if (atom instanceof CommodityReference) {
                    s = String.valueOf(s) + ((CommodityReference)atom).getCommRef().getName();
                } else if (atom instanceof VariableReference) {
                    s = String.valueOf(s) + ((VariableReference)atom).getVarRef().getName();
                } else if (atom instanceof HerdReference) {
                    s = String.valueOf(s) + ((HerdReference)atom).getHerdRef().getName();
                }
                s = String.valueOf(s) + " into " + dataID + " in " + worksheetName + " in " + fileSpec;
            } else {
                String label = cmd.getLabel();
                s = String.valueOf(s) + "table " + table.getName() + " as \"" + label + "\" into " + worksheetName + " in " + fileSpec;
            }
            out.println(s);
        }
    }

    public void addPlanResults(PlanResults otherResults, PlanInPlanType pType, TimeSeries level) {
        TimeSeries ts;
        int n;
        String[] keys;
        if (pType == PlanInPlanType.PHASTOT) {
            level = level.setIncr();
        }
        Set<String> keysSet = otherResults.commodityResults.keySet();
        String[] stringArray = keys = keysSet.toArray(new String[keysSet.size()]);
        int n2 = keys.length;
        int n3 = 0;
        while (n3 < n2) {
            CommResType[] resTypes;
            String key = stringArray[n3];
            CommodityResult commRes = otherResults.commodityResults.get(key);
            CommResType[] commResTypeArray = resTypes = commRes.getTypes();
            n = resTypes.length;
            int n4 = 0;
            while (n4 < n) {
                CommResType ctype = commResTypeArray[n4];
                ts = commRes.getRes(ctype);
                ts = ts.aggregate(pType, level);
                this.putCommodityResult(key, ctype, ts);
                ++n4;
            }
            ++n3;
        }
        keysSet = otherResults.herdResults.keySet();
        String[] stringArray2 = keys = keysSet.toArray(new String[keysSet.size()]);
        int n5 = keys.length;
        n2 = 0;
        while (n2 < n5) {
            HerdResType[] resTypes;
            String[] classNames;
            String key = stringArray2[n2];
            HerdResult herdRes = otherResults.herdResults.get(key);
            String[] stringArray3 = classNames = herdRes.getClassIDs();
            int n6 = classNames.length;
            n = 0;
            while (n < n6) {
                String hClass = stringArray3[n];
                HerdDetailedResType dtype = HerdDetailedResType.AVERAGE_SIZE;
                ts = herdRes.getRes(null, dtype, hClass);
                ts = ts.aggregate(pType, level);
                this.putHerdResult(key, null, dtype, hClass, ts);
                dtype = HerdDetailedResType.AVERAGE_SIZE;
                ts = herdRes.getRes(null, dtype, hClass);
                ts = ts.aggregate(pType, level);
                this.putHerdResult(key, null, dtype, hClass, ts);
                dtype = HerdDetailedResType.AVERAGE_SIZE;
                ts = herdRes.getRes(null, dtype, hClass);
                ts = ts.aggregate(pType, level);
                this.putHerdResult(key, null, dtype, hClass, ts);
                dtype = HerdDetailedResType.AVERAGE_SIZE;
                ts = herdRes.getRes(null, dtype, hClass);
                ts = ts.aggregate(pType, level);
                this.putHerdResult(key, null, dtype, hClass, ts);
                ++n;
            }
            HerdResType[] herdResTypeArray = resTypes = herdRes.getTypes();
            int n7 = resTypes.length;
            n6 = 0;
            while (n6 < n7) {
                HerdResType ctype = herdResTypeArray[n6];
                ts = herdRes.getRes(ctype, null, null);
                ts = ts.aggregate(pType, level);
                this.putHerdResult(key, ctype, null, null, ts);
                ++n6;
            }
            ++n2;
        }
        keysSet = otherResults.globalVarResults.keySet();
        stringArray2 = keys = keysSet.toArray(new String[keysSet.size()]);
        n5 = keys.length;
        n2 = 0;
        while (n2 < n5) {
            String key = stringArray2[n2];
            ts = otherResults.globalVarResults.get(key);
            ts = ts.aggregate(pType, level);
            this.putGlobalVarResult(key, ts);
            ++n2;
        }
    }
}

