/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.calc;

import fr.msimeon.mads.mads.PlanInPlanType;
import fr.msimeon.mads.mads.ReadFunc;
import fr.msimeon.mads.mads.impl.ReadFuncImpl;
import fr.msimeon.mads.runModel.calc.Functions;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.console.MessageConsoleStream;

public class TimeSeries {
    private double[] values;

    TimeSeries(int life) {
        this.values = new double[life + 1];
        int i = 0;
        while (i < life + 1) {
            this.values[i] = 0.0;
            ++i;
        }
    }

    public double[] getValues() {
        return this.values;
    }

    public void setValues(EList<Double> newvalues) {
        int l;
        int n = newvalues.size();
        if (n >= (l = this.values.length) - 1) {
            int i = 1;
            while (i < l) {
                this.values[i] = (Double)newvalues.get(i - 1);
                ++i;
            }
        } else {
            int i = 1;
            while (i < n + 1) {
                this.values[i] = (Double)newvalues.get(i - 1);
                ++i;
            }
            i = n + 1;
            while (i < l) {
                this.values[i] = this.values[n];
                ++i;
            }
        }
    }

    public void setValues(Double[] newvalues) {
        int n = newvalues.length;
        int l = this.values.length;
        if (n >= l - 1) {
            int i = 1;
            while (i < l) {
                this.values[i] = newvalues[i - 1];
                ++i;
            }
        } else {
            int i = 1;
            while (i < n + 1) {
                this.values[i] = newvalues[i - 1];
                ++i;
            }
            i = n + 1;
            while (i < l) {
                this.values[i] = this.values[n];
                ++i;
            }
        }
    }

    public void setValues(double[] newvalues) {
        int n = newvalues.length;
        int l = this.values.length;
        if (n >= l - 1) {
            int i = 1;
            while (i < l) {
                this.values[i] = newvalues[i - 1];
                ++i;
            }
        } else {
            int i = 1;
            while (i < n + 1) {
                this.values[i] = newvalues[i - 1];
                ++i;
            }
            i = n + 1;
            while (i < l) {
                this.values[i] = this.values[n];
                ++i;
            }
        }
    }

    public void setValues(Double v) {
        int i = 1;
        while (i < this.values.length) {
            this.values[i] = v;
            ++i;
        }
    }

    public void addValue(Double v, int index) {
        this.values[index] = this.values[index] + v;
    }

    public void setValues(int v) {
        int i = 1;
        while (i < this.values.length) {
            this.values[i] = v;
            ++i;
        }
    }

    public void setValues(ReadFunc readFunc) {
        String name = ((ReadFuncImpl)readFunc).getRvar();
        String table = ((ReadFuncImpl)readFunc).getTable();
        String fileSpec = "file:///" + ((ReadFuncImpl)readFunc).getFileSpec().getFileSpec();
        TimeSeries res = new TimeSeries(this.values.length);
        res = Functions.read(name, table, fileSpec, this.values.length);
        int i = 1;
        while (i < this.values.length) {
            this.values[i] = res.values[i];
            ++i;
        }
    }

    public TimeSeries addValues(TimeSeries ts) {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = this.values[i] + ts.getValues()[i];
            ++i;
        }
        return res;
    }

    public TimeSeries addValues(double v) {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = this.values[i] + v;
            ++i;
        }
        return res;
    }

    public TimeSeries substractValues(TimeSeries ts) {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = this.values[i] - ts.getValues()[i];
            ++i;
        }
        return res;
    }

    public TimeSeries substractValues(double v) {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = this.values[i] - v;
            ++i;
        }
        return res;
    }

    public TimeSeries divValues(TimeSeries ts) {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = this.values[i] / ts.getValues()[i];
            ++i;
        }
        return res;
    }

    public TimeSeries divValues(double v) {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = this.values[i] / v;
            ++i;
        }
        return res;
    }

    public TimeSeries multValues(TimeSeries ts) {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = this.values[i] * ts.getValues()[i];
            ++i;
        }
        return res;
    }

    public TimeSeries multValues(double v) {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = this.values[i] * v;
            ++i;
        }
        return res;
    }

    public TimeSeries power(TimeSeries ts) {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = Math.pow(this.values[i], ts.getValues()[i]);
            ++i;
        }
        return res;
    }

    public TimeSeries power(double v) {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = Math.pow(this.values[i], v);
            ++i;
        }
        return res;
    }

    public TimeSeries setIncr() {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = this.values[i] - this.values[i - 1];
            ++i;
        }
        return res;
    }

    public TimeSeries aggregate(PlanInPlanType pType, TimeSeries level) {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        res = pType == PlanInPlanType.ANNUAL ? this.multValues(level) : (pType == PlanInPlanType.PHASOLD ? this.phasOld(level) : this.phasing(level));
        return res;
    }

    public TimeSeries phasOld(TimeSeries level) {
        int pLife = this.values.length - 1;
        TimeSeries res = new TimeSeries(pLife);
        int j = 1;
        while (j < pLife + 1) {
            int i = 1;
            while (i < pLife + 1) {
                int v = i + j - 1;
                if (v > pLife) {
                    v = pLife;
                }
                res.values[i] = res.values[i] + this.values[v] * level.values[j];
                ++i;
            }
            ++j;
        }
        return res;
    }

    public TimeSeries phasing(TimeSeries level) {
        int pLife = this.values.length - 1;
        TimeSeries res = new TimeSeries(pLife);
        int j = 1;
        while (j < pLife + 1) {
            int i = j;
            while (i < pLife + 1) {
                res.values[i] = res.values[i] + this.values[i - j + 1] * level.values[j];
                ++i;
            }
            ++j;
        }
        return res;
    }

    public TimeSeries deflated(TimeSeries inflationRates) {
        int pLife = this.values.length - 1;
        TimeSeries res = new TimeSeries(pLife);
        double inflationFactor = 1.0 + inflationRates.values[1] / 100.0;
        res.values[1] = this.values[1] / inflationFactor;
        int i = 2;
        while (i < pLife + 1) {
            res.values[i] = this.values[i] / (inflationFactor *= 1.0 + inflationRates.values[2] / 100.0);
            ++i;
        }
        return res;
    }

    public TimeSeries priceCont(TimeSeries inflationRates) {
        int pLife = this.values.length - 1;
        TimeSeries res = new TimeSeries(pLife);
        double inflationFactor = 1.0 + inflationRates.values[1] / 100.0;
        res.values[1] = this.values[1] * (inflationFactor - 1.0);
        int i = 2;
        while (i < pLife + 1) {
            res.values[i] = this.values[i] * ((inflationFactor *= 1.0 + inflationRates.values[2] / 100.0) - 1.0);
            ++i;
        }
        return res;
    }

    public TimeSeries shift(int sh) {
        TimeSeries res;
        block4: {
            int pLife;
            block6: {
                block5: {
                    block3: {
                        pLife = this.values.length - 1;
                        res = new TimeSeries(pLife);
                        if (sh < pLife) break block3;
                        res.setValues(0);
                        break block4;
                    }
                    if (sh > -pLife) break block5;
                    res.setValues(this.values[pLife]);
                    break block4;
                }
                if (sh <= 0) break block6;
                int i = 1;
                while (i < sh + 1) {
                    res.values[i] = 0.0;
                    ++i;
                }
                i = sh + 1;
                while (i < pLife + 1) {
                    res.values[i] = this.values[i - sh];
                    ++i;
                }
                break block4;
            }
            if (sh >= 0) break block4;
            int i = 1;
            while (i < pLife + 1) {
                res.values[i] = this.values[Math.min(pLife, i - sh)];
                ++i;
            }
        }
        return res;
    }

    public TimeSeries ifPlus() {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = this.values[i] > 0.0 ? this.values[i] : 0.0;
            ++i;
        }
        return res;
    }

    public TimeSeries ifMinus() {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = this.values[i] < 0.0 ? this.values[i] : 0.0;
            ++i;
        }
        return res;
    }

    public TimeSeries sum() {
        TimeSeries res = new TimeSeries(this.values.length - 1);
        double s = 0.0;
        int i = 1;
        while (i < this.values.length) {
            s += this.values[i];
            ++i;
        }
        res.setValues(s);
        return res;
    }

    public TimeSeries singleValue(int index) {
        int pLife = this.values.length - 1;
        TimeSeries res = new TimeSeries(pLife);
        if (index < 1) {
            index = 1;
        } else if (index > pLife) {
            index = pLife;
        }
        int i = 1;
        while (i < this.values.length) {
            res.values[i] = this.values[index];
            ++i;
        }
        return res;
    }

    public void printValues(int width, int decDigits) {
        if (width < 1) {
            width = 1;
        }
        if (decDigits < 0) {
            decDigits = 0;
        }
        String f = "%," + width + "." + decDigits + "f ";
        int i = 1;
        while (i < this.values.length) {
            System.out.printf(f, this.values[i]);
            ++i;
        }
        System.out.println();
    }

    public void printValues(int decDigits) {
        this.printValues(1, decDigits);
    }

    public void printValues() {
        this.printValues(1, 2);
    }

    public void printValues(MessageConsoleStream out, int width, int decDigits) {
        if (width < 1) {
            width = 1;
        }
        if (decDigits < 0) {
            decDigits = 0;
        }
        String f = "%," + width + "." + decDigits + "f ";
        int i = 1;
        while (i < this.values.length) {
            out.print(String.format(f, this.values[i]));
            ++i;
        }
        out.println();
    }

    public void printValues(MessageConsoleStream out, int decDigits) {
        this.printValues(out, 1, decDigits);
    }

    public void printValues(MessageConsoleStream out) {
        this.printValues(out, 1, 2);
    }

    public void printValues(int width, int decDigits, IDocument doc, Boolean isHtml) {
        if (width < 1) {
            width = 1;
        }
        if (decDigits < 0) {
            decDigits = 0;
        }
        String f = "%," + width + "." + decDigits + "f ";
        try {
            int i = 1;
            while (i < this.values.length) {
                doc.replace(doc.getLength(), 0, String.format(f, this.values[i]));
                ++i;
            }
            if (isHtml.booleanValue()) {
                doc.replace(doc.getLength(), 0, "<br/>\n");
            } else {
                doc.replace(doc.getLength(), 0, "\n");
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void printValues(int decDigits, IDocument doc, Boolean isHtml) {
        this.printValues(1, decDigits, doc, isHtml);
    }

    public void printValues(IDocument doc, Boolean isHtml) {
        this.printValues(1, 2, doc, isHtml);
    }
}

