/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.calc;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class test {
    public static void main(String[] args) {
        double offtakeProbRate = 0.07;
        double deathProbRate = 0.19;
        int d = 9;
        System.out.printf("duration d = %d%n", d);
        System.out.printf("Pdea = %1.6f --- Poff = %1.6f%n", deathProbRate, offtakeProbRate);
        double[] mrates = test.getMonthlyProbRates(deathProbRate, offtakeProbRate, d);
        System.out.printf("mpdea = %1.20f --- mpoff = %1.20f%n", mrates[0], mrates[1]);
        System.out.println("Using BigDecimal");
        BigDecimal[] mratesBD = test.getMonthlyProbRatesBD(deathProbRate, offtakeProbRate, d);
        System.out.printf("mpdea = %1.20f --- mpoff = %1.20f%n", mratesBD[0], mratesBD[1]);
    }

    static double[] getMonthlyProbRates(double deathProbRate, double offtakeProbRate, int nbOfMonths) {
        double deltahoff;
        double[] monthlyRates = new double[2];
        double tol = 1.0E-20;
        boolean finish = false;
        if (nbOfMonths > 12) {
            nbOfMonths = 12;
        }
        double hdea = -Math.log(1.0 - deathProbRate);
        double hofft = -Math.log(1.0 - offtakeProbRate);
        do {
            double funchoff = hofft / (hdea + hofft) * (1.0 - Math.exp(-(hdea + hofft))) - offtakeProbRate;
            double derivhoff = (hdea * (1.0 - Math.exp(-(hdea + hofft))) + hofft * (hdea + hofft) * Math.exp(-(hdea + hofft))) / Math.pow(hdea + hofft, 2.0);
            double hofft1 = hofft - funchoff / derivhoff;
            deltahoff = Math.abs(hofft1 - hofft);
            hofft = hofft1;
        } while (!(finish = deltahoff < tol));
        double mhdea = hdea / (double)nbOfMonths;
        double mhoff = hofft / (double)nbOfMonths;
        System.out.printf(" hdea = %1.20f ---  hoff = %1.20f%n", hdea / (double)nbOfMonths, hofft / (double)nbOfMonths);
        double mhtot = mhdea + mhoff;
        monthlyRates[0] = mhdea / mhtot * (1.0 - Math.exp(-mhtot));
        monthlyRates[1] = mhoff / mhtot * (1.0 - Math.exp(-mhtot));
        return monthlyRates;
    }

    static BigDecimal[] getMonthlyProbRatesBD(double deathPRate, double offtakePRate, int nbOfMonths) {
        BigDecimal deltahoff;
        int prec = 50;
        MathContext mc = new MathContext(prec);
        BigDecimal[] monthlyRates = new BigDecimal[2];
        BigDecimal hdea = new BigDecimal("0", mc);
        BigDecimal hofft = new BigDecimal("0", mc);
        BigDecimal hofft1 = new BigDecimal("0", mc);
        BigDecimal mhdea = new BigDecimal("0", mc);
        BigDecimal mhoff = new BigDecimal("0", mc);
        BigDecimal sumh = new BigDecimal("0", mc);
        BigDecimal funchoff = new BigDecimal("0", mc);
        BigDecimal derivhoff = new BigDecimal("0", mc);
        BigDecimal tol = new BigDecimal(1.0E-15);
        BigDecimal deathProbRate = new BigDecimal(deathPRate, mc);
        BigDecimal offtakeProbRate = new BigDecimal(offtakePRate, mc);
        boolean finish = false;
        if (nbOfMonths > 12) {
            nbOfMonths = 12;
        }
        BigDecimal nbM = new BigDecimal(nbOfMonths);
        hdea = test.ln(BigDecimal.ONE.subtract(deathProbRate), mc).negate();
        hofft = test.ln(BigDecimal.ONE.subtract(offtakeProbRate), mc).negate();
        do {
            sumh = hdea.add(hofft, mc);
            funchoff = hofft.divide(sumh, mc).multiply(BigDecimal.ONE.subtract(test.exp(sumh.negate(), prec), mc)).subtract(offtakeProbRate, mc);
            derivhoff = hdea.multiply(BigDecimal.ONE.subtract(test.exp(sumh.negate(), prec), mc)).add(hofft.multiply(sumh, mc).multiply(test.exp(sumh.negate(), prec), mc)).divide(sumh.pow(2), mc);
            hofft1 = hofft.subtract(funchoff.divide(derivhoff, mc), mc);
            deltahoff = hofft1.subtract(hofft, mc).abs(mc);
            hofft = hofft1;
        } while (!(finish = deltahoff.compareTo(tol) == -1));
        mhdea = hdea.divide(nbM, mc);
        mhoff = hofft.divide(nbM, mc);
        System.out.printf(" hdea = %1.20f ---  hoff = %1.20f%n", mhdea, mhoff);
        BigDecimal mhtot = mhdea.add(mhoff, mc);
        monthlyRates[0] = mhdea.divide(mhtot, mc).multiply(BigDecimal.ONE.subtract(test.exp(mhtot.negate(), prec), mc));
        monthlyRates[1] = mhoff.divide(mhtot, mc).multiply(BigDecimal.ONE.subtract(test.exp(mhtot.negate(), prec), mc));
        return monthlyRates;
    }

    public static BigDecimal exp(BigDecimal x, int prec) {
        int bits = prec * 4;
        BigDecimal natural_e = test.naturalE(prec);
        BigDecimal epsilon = new BigDecimal("1");
        int i = 0;
        while (i < bits) {
            epsilon = epsilon.multiply(new BigDecimal("0.5"));
            ++i;
        }
        BigDecimal y = new BigDecimal("1.0");
        BigDecimal ep = natural_e;
        BigDecimal j = new BigDecimal("1");
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal half = new BigDecimal("0.5");
        if (x.abs().compareTo(half) < 0) {
            return test.exp_series(x, prec);
        }
        if (x.compareTo(new BigDecimal("0")) > 0) {
            while (x.compareTo(j.add(one)) > 0) {
                ep = ep.multiply(natural_e);
                j = j.add(one);
            }
            BigDecimal xc = x.subtract(j);
            y = ep.multiply(test.exp_series(xc, prec));
            y = y.setScale(prec, 1);
            return y;
        }
        BigDecimal xp = x.negate();
        while (xp.compareTo(j.add(one)) > 0) {
            ep = ep.multiply(natural_e);
            j = j.add(one);
        }
        BigDecimal xc = xp.subtract(j);
        y = ep.multiply(test.exp_series(xc, prec));
        y = y.setScale(prec, 1);
        return one.add(epsilon).divide(y, 1);
    }

    public static BigDecimal naturalE(int prec_dig) {
        BigDecimal sum = new BigDecimal("1");
        BigDecimal fact = new BigDecimal("1");
        BigDecimal del = new BigDecimal("1");
        BigDecimal one = new BigDecimal("1");
        BigDecimal ten = new BigDecimal("10");
        int prec_bits = prec_dig * 332 / 100;
        one = one.setScale(prec_dig, 1);
        int i = 0;
        while (i < prec_dig) {
            del = del.multiply(ten);
            ++i;
        }
        i = 1;
        while (i < prec_bits) {
            fact = fact.multiply(new BigDecimal(i));
            fact = fact.setScale(prec_dig, 1);
            sum = sum.add(one.divide(fact, 1));
            if (del.compareTo(fact) < 0) break;
            ++i;
        }
        return sum.setScale(prec_dig, 1);
    }

    public static BigDecimal exp_series(BigDecimal x, int prec) {
        BigDecimal fact = new BigDecimal("1");
        BigDecimal xp = new BigDecimal("1");
        BigDecimal y = new BigDecimal("1");
        int n = 2 * prec / 3;
        int i = 1;
        while (i < n) {
            fact = fact.multiply(new BigDecimal(i));
            fact = fact.setScale(prec, 1);
            xp = xp.multiply(x);
            xp = xp.setScale(prec, 1);
            y = y.add(xp.divide(fact, 1));
            ++i;
        }
        y = y.setScale(prec, 1);
        return y;
    }

    public static BigDecimal log(BigDecimal b, int dp) {
        int NUM_OF_DIGITS = dp + 2;
        MathContext mc = new MathContext(NUM_OF_DIGITS, RoundingMode.HALF_EVEN);
        if (b.signum() <= 0) {
            throw new ArithmeticException("log of a negative number! (or zero)");
        }
        if (b.compareTo(BigDecimal.ONE) == 0) {
            return BigDecimal.ZERO;
        }
        if (b.compareTo(BigDecimal.ONE) < 0) {
            return test.log(BigDecimal.ONE.divide(b, mc), dp).negate();
        }
        StringBuffer sb = new StringBuffer();
        int leftDigits = b.precision() - b.scale();
        sb.append(leftDigits - 1).append(".");
        int n = 0;
        while (n < NUM_OF_DIGITS) {
            b = b.movePointLeft(leftDigits - 1).pow(10, mc);
            leftDigits = b.precision() - b.scale();
            sb.append(leftDigits - 1);
            ++n;
        }
        BigDecimal ans = new BigDecimal(sb.toString());
        ans = ans.round(new MathContext(ans.precision() - ans.scale() + dp, RoundingMode.HALF_EVEN));
        return ans;
    }

    public static BigDecimal ln(BigDecimal x, MathContext context) {
        if (x.equals(BigDecimal.ONE)) {
            return BigDecimal.ZERO;
        }
        long ITER = 1000L;
        x = x.subtract(BigDecimal.ONE);
        BigDecimal ret = new BigDecimal(ITER + 1L);
        long i = ITER;
        while (i >= 0L) {
            BigDecimal N = new BigDecimal(i / 2L + 1L).pow(2);
            N = N.multiply(x, context);
            ret = N.divide(ret, context);
            N = new BigDecimal(i + 1L);
            ret = ret.add(N, context);
            --i;
        }
        ret = x.divide(ret, context);
        return ret;
    }
}

