/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.console;

import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class MadsConsole {
    private final String CONSOLE_NAME = "Mads Console";
    private MessageConsoleStream out;

    public MadsConsole(int color) {
        MessageConsole console = this.findConsole("Mads Console");
        this.out = console.newMessageStream();
        Color fore = PlatformUI.getWorkbench().getDisplay().getSystemColor(color);
        this.out.setColor(fore);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        String id = "org.eclipse.ui.console.ConsoleView";
        try {
            IConsoleView view = (IConsoleView)activePage.showView(id);
            view.display((IConsole)console);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public MessageConsoleStream getConsoleStream() {
        return this.out;
    }

    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }
}

