/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.evaluatePlan;

import fr.msimeon.mads.mads.Entity;
import fr.msimeon.mads.mads.Model;
import fr.msimeon.mads.mads.Plan;
import fr.msimeon.mads.mads.ResKW;
import fr.msimeon.mads.mads.impl.ModelImpl;
import fr.msimeon.mads.mads.impl.PlanImpl;
import fr.msimeon.mads.runModel.calc.Calc;
import fr.msimeon.mads.runModel.calc.InOut;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;

public class EvalPlan
implements IEditorActionDelegate {
    public static final String MADS_JOBS = "MadsJobs";

    public void run(IAction action) {
        EvalPlan.runEvalPlan();
    }

    public static void runEvalPlan() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = activePage.getActiveEditor();
        IXtextDocument xtextDocument = ((XtextEditor)editor).getDocument();
        String planLabel = (String)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

            public String exec(XtextResource resource) throws Exception {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = activePage.getActiveEditor();
                IResourceValidator validator = resource.getResourceServiceProvider().getResourceValidator();
                Boolean edErrors = validator.validate((Resource)resource, CheckMode.ALL, null).size() > 0;
                if (edErrors.booleanValue()) {
                    EvalPlan.showError("Errors in editor\nCorrect and Re-Run");
                    return null;
                }
                if (editor.isDirty()) {
                    EvalPlan.showError("Unsaved editor\nSave and Re-Run");
                    return null;
                }
                Model model = (Model)resource.getContents().get(0);
                if (model == null) {
                    return null;
                }
                EList entities = model.getElements();
                ITextSelection selection = (ITextSelection)((XtextEditor)editor).getSelectionProvider().getSelection();
                String txt = selection.getText();
                PlanImpl selectedPlan = null;
                int numberOfPlans = 0;
                for (Entity entity : entities) {
                    if (!(entity instanceof Plan)) continue;
                    ++numberOfPlans;
                    if (!entity.getName().equals(txt)) continue;
                    selectedPlan = (PlanImpl)entity;
                }
                if (numberOfPlans == 0) {
                    EvalPlan.showError("No plan defined\nCannot run any evaluation");
                    return null;
                }
                if (selectedPlan == null) {
                    EvalPlan.showError("Select a plan to calculate it by double-clicking its name\neither in the editor or in the outline, and Re-Run");
                } else {
                    IFile file = ((IFileEditorInput)editor.getEditorInput()).getFile();
                    IProject project = file.getProject();
                    String planId = String.valueOf(selectedPlan.getName()) + " = " + selectedPlan.getLabel();
                    if (EvalPlan.confirm("Calculations launched on " + planId)) {
                        IDocument doc;
                        ResKW resultAs = model.getResultAs();
                        Boolean isHtml = false;
                        if (resultAs == ResKW.HTML) {
                            doc = EvalPlan.openEditorForOutput(project, "mads_output.html", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n\"http://www.w3.org/TR/html4/strict.dt\"><HTML>\n<HEAD><TITLE>mads.mads output</TITLE></HEAD>\n<body><font face=\"Consolas\"> <FONT SIZE=2>\n");
                            isHtml = true;
                        } else {
                            doc = EvalPlan.openEditorForOutput(project, "mads_output.txt", "");
                        }
                        Calc.calcPlan((ModelImpl)model, selectedPlan, numberOfPlans, doc, isHtml);
                        return selectedPlan.getLabel();
                    }
                }
                return null;
            }
        });
        if (planLabel != null) {
            EvalPlan.displayInBrowser(planLabel);
        }
    }

    static void displayInBrowser(String selectedPlanLabel) {
        Browser browser;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = page.getActiveEditor();
        IDocumentProvider dp = ((ITextEditor)editor.getAdapter(ITextEditor.class)).getDocumentProvider();
        IDocument doc = dp.getDocument((Object)editor.getEditorInput());
        String html = doc.get();
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
        shell.setText("Mads output for Plan " + selectedPlanLabel);
        shell.setLayout((Layout)new FillLayout());
        try {
            browser = new Browser((Composite)shell, 0);
        }
        catch (SWTError e) {
            InOut.err.println("Could not instantiate Browser: " + e.getMessage());
            return;
        }
        browser.setText(html);
        shell.open();
        shell.setFocus();
    }

    public static IDocument openEditorForOutput(IProject project, String fname, String content) {
        IFile file = project.getFile(fname);
        IDocument doc = null;
        if (!file.exists()) {
            ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
            try {
                file.create((InputStream)source, false, null);
            }
            catch (CoreException coreException) {
                EvalPlan.showError("Unable to find or create output file");
                return null;
            }
        }
        IEditorRegistry edReg = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor ed = edReg.getDefaultEditor("m.txt");
        FileEditorInput edInput = new FileEditorInput(file);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            try {
                page.openEditor((IEditorInput)edInput, ed.getId(), true);
                IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                IDocumentProvider dp = ((ITextEditor)editor.getAdapter(ITextEditor.class)).getDocumentProvider();
                doc = dp.getDocument((Object)editor.getEditorInput());
            }
            catch (PartInitException e) {
                InOut.err.println("Could not open editor: " + e.getMessage());
            }
        }
        return doc;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    private static boolean confirm(String message) {
        return MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mads Run", (String)message);
    }

    private static void showError(String message) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mads Run", (String)message);
    }
}

