/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.math;

public class Complex
implements Cloneable {
    public static final String VERSION = "1.0 FINAL alm";
    public static final String DATE = "Fri 29-Jul-97";
    public static final String AUTHOR = "sandy@almide.demon.co.uk";
    public static final String REMARK = "Class available from http://www.netlib.org/";
    protected static final double TWO_PI = Math.PI * 2;
    public static final Complex i = new Complex(0.0, 1.0);
    private double re;
    private double im;

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(double re) {
        this(re, 0.0);
    }

    public Complex(Complex z) {
        this(z.re, z.im);
    }

    public Complex(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public static void main(String[] args) {
        System.out.println();
        System.out.println("Module : " + Complex.class.getName());
        System.out.println("Version: 1.0 FINAL alm");
        System.out.println("Date   : Fri 29-Jul-97");
        System.out.println("Author : sandy@almide.demon.co.uk");
        System.out.println("Remark : Class available from http://www.netlib.org/");
        System.out.println();
        System.out.println("Hint:  use TestComplex to test the class.");
        System.out.println();
    }

    public static Complex real(double real) {
        return new Complex(real, 0.0);
    }

    public static Complex cart(double re, double im) {
        return new Complex(re, im);
    }

    public static Complex polar(double r, double theta) {
        if (r < 0.0) {
            theta += Math.PI;
            r = -r;
        }
        return Complex.cart(r * Math.cos(theta %= Math.PI * 2), r * Math.sin(theta));
    }

    public static Complex pow(Complex base, double exponent) {
        double re = exponent * Math.log(base.abs());
        double im = exponent * base.arg();
        double scalar = Math.exp(re);
        return Complex.cart(scalar * Math.cos(im), scalar * Math.sin(im));
    }

    public static Complex pow(double base, Complex exponent) {
        double re = Math.log(Math.abs(base));
        double im = Math.atan2(0.0, base);
        double re2 = re * exponent.re - im * exponent.im;
        double im2 = re * exponent.im + im * exponent.re;
        double scalar = Math.exp(re2);
        return Complex.cart(scalar * Math.cos(im2), scalar * Math.sin(im2));
    }

    public static Complex pow(Complex base, Complex exponent) {
        double re = Math.log(base.abs());
        double im = base.arg();
        double re2 = re * exponent.re - im * exponent.im;
        double im2 = re * exponent.im + im * exponent.re;
        double scalar = Math.exp(re2);
        return Complex.cart(scalar * Math.cos(im2), scalar * Math.sin(im2));
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public boolean equals(Complex z, double tolerance) {
        return Complex.abs(this.re - z.re, this.im - z.im) <= Math.abs(tolerance);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Complex other = (Complex)obj;
        return this.re == other.re && this.im == other.im;
    }

    public int hashcode() {
        return (int)(this.re * 1024.0 * 31.0 + this.im * 1024.0 * 37.0);
    }

    public double re() {
        return this.re;
    }

    public double im() {
        return this.im;
    }

    public double norm() {
        return this.re * this.re + this.im * this.im;
    }

    public double abs() {
        return Complex.abs(this.re, this.im);
    }

    private static double abs(double x, double y) {
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        if (absX == 0.0 && absY == 0.0) {
            return 0.0;
        }
        if (absX >= absY) {
            double d = y / x;
            return absX * Math.sqrt(1.0 + d * d);
        }
        double d = x / y;
        return absY * Math.sqrt(1.0 + d * d);
    }

    public double arg() {
        return Math.atan2(this.im, this.re);
    }

    public Complex neg() {
        return this.scale(-1.0);
    }

    public Complex conj() {
        return Complex.cart(this.re, -this.im);
    }

    private static void inv(Complex z) {
        double zIm;
        double zRe;
        if (Math.abs(z.re) >= Math.abs(z.im)) {
            double scalar;
            zRe = scalar = 1.0 / (z.re + z.im * (z.im / z.re));
            zIm = scalar * (-z.im / z.re);
        } else {
            double scalar = 1.0 / (z.re * (z.re / z.im) + z.im);
            zRe = scalar * (z.re / z.im);
            zIm = -scalar;
        }
        z.re = zRe;
        z.im = zIm;
    }

    public Complex scale(double scalar) {
        return Complex.cart(scalar * this.re, scalar * this.im);
    }

    public Complex add(Complex z) {
        return Complex.cart(this.re + z.re, this.im + z.im);
    }

    public Complex sub(Complex z) {
        return Complex.cart(this.re - z.re, this.im - z.im);
    }

    public Complex mul(Complex z) {
        return Complex.cart(this.re * z.re - this.im * z.im, this.re * z.im + this.im * z.re);
    }

    public Complex div(Complex z) {
        Complex result = new Complex(this);
        Complex.div(result, z.re, z.im);
        return result;
    }

    private static void div(Complex z, double x, double y) {
        double zIm;
        double zRe;
        if (Math.abs(x) >= Math.abs(y)) {
            double scalar = 1.0 / (x + y * (y / x));
            zRe = scalar * (z.re + z.im * (y / x));
            zIm = scalar * (z.im - z.re * (y / x));
        } else {
            double scalar = 1.0 / (x * (x / y) + y);
            zRe = scalar * (z.re * (x / y) + z.im);
            zIm = scalar * (z.im * (x / y) - z.re);
        }
        z.re = zRe;
        z.im = zIm;
    }

    public Complex sqrt() {
        Complex result = new Complex(this);
        Complex.sqrt(result);
        return result;
    }

    private static void sqrt(Complex z) {
        double mag = z.abs();
        if (mag > 0.0) {
            if (z.re > 0.0) {
                double temp;
                z.re = temp = Math.sqrt(0.5 * (mag + z.re));
                z.im = 0.5 * z.im / temp;
            } else {
                double temp = Math.sqrt(0.5 * (mag - z.re));
                if (z.im < 0.0) {
                    temp = -temp;
                }
                z.re = 0.5 * z.im / temp;
                z.im = temp;
            }
        } else {
            z.re = 0.0;
            z.im = 0.0;
        }
    }

    public Complex pow(Complex exponent) {
        return Complex.pow(this, exponent);
    }

    public Complex exp() {
        double scalar = Math.exp(this.re);
        return Complex.cart(scalar * Math.cos(this.im), scalar * Math.sin(this.im));
    }

    public Complex log() {
        return Complex.cart(Math.log(this.abs()), this.arg());
    }

    public Complex sin() {
        double iz_re = -this.im;
        double iz_im = this.re;
        double scalar = Math.exp(iz_re);
        double _re1 = scalar * Math.cos(iz_im);
        double _im1 = scalar * Math.sin(iz_im);
        scalar = Math.exp(-iz_re);
        double _re2 = scalar * Math.cos(-iz_im);
        double _im2 = scalar * Math.sin(-iz_im);
        Complex result = Complex.cart(0.5 * (_im1 -= _im2), -0.5 * (_re1 -= _re2));
        return result;
    }

    public Complex cos() {
        double iz_re = -this.im;
        double iz_im = this.re;
        double scalar = Math.exp(iz_re);
        double _re1 = scalar * Math.cos(iz_im);
        double _im1 = scalar * Math.sin(iz_im);
        scalar = Math.exp(-iz_re);
        double _re2 = scalar * Math.cos(-iz_im);
        double _im2 = scalar * Math.sin(-iz_im);
        Complex result = Complex.cart(0.5 * (_re1 += _re2), 0.5 * (_im1 += _im2));
        return result;
    }

    public Complex tan() {
        double iz_re = -this.im;
        double iz_im = this.re;
        double scalar = Math.exp(iz_re);
        double _re1 = scalar * Math.cos(iz_im);
        double _im1 = scalar * Math.sin(iz_im);
        scalar = Math.exp(-iz_re);
        double _re2 = scalar * Math.cos(-iz_im);
        double _im2 = scalar * Math.sin(-iz_im);
        double _re3 = _re1 - _re2;
        double _im3 = _im1 - _im2;
        Complex result = Complex.cart(0.5 * _im3, -0.5 * _re3);
        _re3 = _re1 + _re2;
        _im3 = _im1 + _im2;
        double cs_re = 0.5 * _re3;
        double cs_im = 0.5 * _im3;
        Complex.div(result, cs_re, cs_im);
        return result;
    }

    public Complex cosec() {
        double iz_re = -this.im;
        double iz_im = this.re;
        double scalar = Math.exp(iz_re);
        double _re1 = scalar * Math.cos(iz_im);
        double _im1 = scalar * Math.sin(iz_im);
        scalar = Math.exp(-iz_re);
        double _re2 = scalar * Math.cos(-iz_im);
        double _im2 = scalar * Math.sin(-iz_im);
        Complex result = Complex.cart(0.5 * (_im1 -= _im2), -0.5 * (_re1 -= _re2));
        Complex.inv(result);
        return result;
    }

    public Complex sec() {
        double iz_re = -this.im;
        double iz_im = this.re;
        double scalar = Math.exp(iz_re);
        double _re1 = scalar * Math.cos(iz_im);
        double _im1 = scalar * Math.sin(iz_im);
        scalar = Math.exp(-iz_re);
        double _re2 = scalar * Math.cos(-iz_im);
        double _im2 = scalar * Math.sin(-iz_im);
        Complex result = Complex.cart(0.5 * (_re1 += _re2), 0.5 * (_im1 += _im2));
        Complex.inv(result);
        return result;
    }

    public Complex cot() {
        double iz_re = -this.im;
        double iz_im = this.re;
        double scalar = Math.exp(iz_re);
        double _re1 = scalar * Math.cos(iz_im);
        double _im1 = scalar * Math.sin(iz_im);
        scalar = Math.exp(-iz_re);
        double _re2 = scalar * Math.cos(-iz_im);
        double _im2 = scalar * Math.sin(-iz_im);
        double _re3 = _re1 + _re2;
        double _im3 = _im1 + _im2;
        Complex result = Complex.cart(0.5 * _re3, 0.5 * _im3);
        _re3 = _re1 - _re2;
        _im3 = _im1 - _im2;
        double sn_re = 0.5 * _im3;
        double sn_im = -0.5 * _re3;
        Complex.div(result, sn_re, sn_im);
        return result;
    }

    public Complex sinh() {
        double scalar = Math.exp(this.re);
        double _re1 = scalar * Math.cos(this.im);
        double _im1 = scalar * Math.sin(this.im);
        scalar = Math.exp(-this.re);
        double _re2 = scalar * Math.cos(-this.im);
        double _im2 = scalar * Math.sin(-this.im);
        Complex result = Complex.cart(0.5 * (_re1 -= _re2), 0.5 * (_im1 -= _im2));
        return result;
    }

    public Complex cosh() {
        double scalar = Math.exp(this.re);
        double _re1 = scalar * Math.cos(this.im);
        double _im1 = scalar * Math.sin(this.im);
        scalar = Math.exp(-this.re);
        double _re2 = scalar * Math.cos(-this.im);
        double _im2 = scalar * Math.sin(-this.im);
        Complex result = Complex.cart(0.5 * (_re1 += _re2), 0.5 * (_im1 += _im2));
        return result;
    }

    public Complex tanh() {
        double scalar = Math.exp(this.re);
        double _re1 = scalar * Math.cos(this.im);
        double _im1 = scalar * Math.sin(this.im);
        scalar = Math.exp(-this.re);
        double _re2 = scalar * Math.cos(-this.im);
        double _im2 = scalar * Math.sin(-this.im);
        double _re3 = _re1 - _re2;
        double _im3 = _im1 - _im2;
        Complex result = Complex.cart(0.5 * _re3, 0.5 * _im3);
        _re3 = _re1 + _re2;
        _im3 = _im1 + _im2;
        double ch_re = 0.5 * _re3;
        double ch_im = 0.5 * _im3;
        Complex.div(result, ch_re, ch_im);
        return result;
    }

    public Complex asin() {
        double _re1 = 1.0 - (this.re * this.re - this.im * this.im);
        double _im1 = 0.0 - (this.re * this.im + this.im * this.re);
        Complex result = Complex.cart(_re1, _im1);
        Complex.sqrt(result);
        _re1 = -this.im;
        _im1 = this.re;
        result.re = _re1 + result.re;
        result.im = _im1 + result.im;
        _re1 = Math.log(result.abs());
        result.re = _im1 = result.arg();
        result.im = -_re1;
        return result;
    }

    public Complex acos() {
        double _re1 = 1.0 - (this.re * this.re - this.im * this.im);
        double _im1 = 0.0 - (this.re * this.im + this.im * this.re);
        Complex result = Complex.cart(_re1, _im1);
        Complex.sqrt(result);
        _re1 = -result.im;
        _im1 = result.re;
        result.re = this.re + _re1;
        result.im = this.im + _im1;
        _re1 = Math.log(result.abs());
        result.re = _im1 = result.arg();
        result.im = -_re1;
        return result;
    }

    public Complex atan() {
        Complex result = Complex.cart(-this.re, 1.0 - this.im);
        double _re1 = this.re;
        double _im1 = 1.0 + this.im;
        Complex.div(result, _re1, _im1);
        _re1 = Math.log(result.abs());
        _im1 = result.arg();
        result.re = 0.5 * _im1;
        result.im = -0.5 * _re1;
        return result;
    }

    public Complex asinh() {
        double _re1 = this.re * this.re - this.im * this.im + 1.0;
        double _im1 = this.re * this.im + this.im * this.re + 0.0;
        Complex result = Complex.cart(_re1, _im1);
        Complex.sqrt(result);
        result.re = this.re + result.re;
        result.im = this.im + result.im;
        _re1 = Math.log(result.abs());
        _im1 = result.arg();
        result.re = _re1;
        result.im = _im1;
        return result;
    }

    public Complex acosh() {
        double _re1 = this.re * this.re - this.im * this.im - 1.0;
        double _im1 = this.re * this.im + this.im * this.re - 0.0;
        Complex result = Complex.cart(_re1, _im1);
        Complex.sqrt(result);
        result.re = this.re + result.re;
        result.im = this.im + result.im;
        _re1 = Math.log(result.abs());
        _im1 = result.arg();
        result.re = _re1;
        result.im = _im1;
        return result;
    }

    public Complex atanh() {
        Complex result = Complex.cart(1.0 + this.re, this.im);
        double _re1 = 1.0 - this.re;
        double _im1 = -this.im;
        Complex.div(result, _re1, _im1);
        _re1 = Math.log(result.abs());
        _im1 = result.arg();
        result.re = 0.5 * _re1;
        result.im = 0.5 * _im1;
        return result;
    }

    public String toString() {
        if (this.im < 0.0) {
            return "(" + this.re + " - " + -this.im + "i)";
        }
        if (1.0 / this.im == Double.NEGATIVE_INFINITY) {
            return "(" + this.re + " - " + 0.0 + "i)";
        }
        return "(" + this.re + " + " + this.im + "i)";
    }
}

