/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.math;

import fr.msimeon.mads.runModel.math.Complex;
import fr.msimeon.mads.runModel.math.RootException;
import java.io.Serializable;

public class Polynomial
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2679960976162995156L;
    private static final double BASE = 2.0;
    private static final double kT = 53.0;
    private static final double kN = -1022.0;
    private static final double ETA = Math.pow(2.0, -52.0);
    private static final double INFIN = Double.MAX_VALUE;
    private static final double SMALNO = Math.pow(2.0, -1019.0) / Math.pow(2.0, 3.0);
    private static final double ARE = ETA;
    private static final double MRE = 2.0 * Math.sqrt(2.0) * ETA;
    private static final double COSR = -0.060756474;
    private static final double SINR = 0.99756405;
    private Complex[] coef;
    private transient double PVr;
    private transient double PVi;
    private transient double Tr;
    private transient double Ti;
    private transient double Sr;
    private transient double Si;
    private transient double Zr;
    private transient double Zi;

    public Polynomial() {
    }

    public Polynomial(Complex[] coefficients) {
        this.coef = (Complex[])coefficients.clone();
    }

    public Polynomial(double[] coefficients) {
        int length = coefficients.length;
        this.coef = new Complex[length];
        int i = 0;
        while (i < length) {
            this.coef[i] = new Complex(coefficients[i]);
            ++i;
        }
    }

    public void setCoefficients(Complex[] coefficients) {
        this.coef = (Complex[])coefficients.clone();
    }

    public void setCoefficients(double[] coefficients) {
        int length = coefficients.length;
        this.coef = new Complex[length];
        int i = 0;
        while (i < length) {
            this.coef[i] = new Complex(coefficients[i]);
            ++i;
        }
    }

    public Complex[] getCoefficients() {
        return this.coef;
    }

    public Complex evaluate(Complex x) {
        return this.evaluate(x.re(), x.im());
    }

    public Complex evaluate(double x) {
        return this.evaluate(x, 0.0);
    }

    public Complex evaluate(double xr, double xi) {
        if (this.coef == null) {
            return new Complex(0.0, 0.0);
        }
        int NN = this.coef.length;
        double pvr = this.coef[NN - 1].re();
        double pvi = this.coef[NN - 1].im();
        int i = NN - 2;
        while (i >= 0) {
            double temp = pvr;
            pvr = pvr * xr - pvi * xi + this.coef[i].re();
            pvi = temp * xi + pvi * xr + this.coef[i].im();
            --i;
        }
        return new Complex(pvr, pvi);
    }

    public Complex slope(Complex x) {
        return this.slope(x.re(), x.im());
    }

    public Complex slope(double x) {
        return this.slope(x, 0.0);
    }

    public Complex slope(double xr, double xi) {
        if (this.coef == null) {
            return new Complex(0.0, 0.0);
        }
        int NN = this.coef.length;
        double dpr = this.coef[NN - 1].re() * (double)(NN - 1);
        double dpi = this.coef[NN - 1].im() * (double)(NN - 1);
        int i = NN - 2;
        while (i >= 1) {
            double temp = dpr;
            dpr = dpr * xr - dpi * xi + (double)i * this.coef[i].re();
            dpi = temp * xi + dpi * xr + (double)i * this.coef[i].im();
            --i;
        }
        return new Complex(dpr, dpi);
    }

    public Complex[] zeros() throws RootException {
        Complex[] zeros = null;
        if (this.coef != null && this.coef.length > 0) {
            int NN = this.coef.length;
            double[] Pr = new double[NN];
            double[] Pi = new double[NN];
            int i = 0;
            while (i < NN) {
                Pr[i] = this.coef[NN - 1 - i].re();
                Pi[i] = this.coef[NN - 1 - i].im();
                ++i;
            }
            zeros = this.cpoly(Pr, Pi);
        }
        return zeros;
    }

    public int hashcode() {
        if (this.coef == null) {
            return 0;
        }
        int length = this.coef.length;
        if (length > 3) {
            length = 3;
        }
        int hash = 0;
        int i = 0;
        while (i < length) {
            hash ^= this.coef[i].hashcode();
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polynomial newObj = (Polynomial)obj;
        if (this.coef == newObj.coef) {
            return true;
        }
        if (this.coef == null) {
            return newObj.coef.length == 1 && newObj.coef[0].re() == 0.0 && newObj.coef[0].im() == 0.0;
        }
        if (newObj.coef == null) {
            return this.coef.length == 1 && newObj.coef[0].re() == 0.0 && newObj.coef[0].im() == 0.0;
        }
        int length = this.coef.length;
        if (length != newObj.coef.length) {
            return false;
        }
        boolean retVal = true;
        int i = 0;
        while (i < length) {
            if (!this.coef[i].equals(newObj.coef[i])) {
                retVal = false;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.coef != null) {
            int NN = this.coef.length;
            if (this.coef[0].abs() > 0.0) {
                if (this.coef[0].im() != 0.0) {
                    buffer.append(this.coef[0].toString());
                } else {
                    buffer.append(this.coef[0].re());
                }
            }
            if (NN > 1) {
                if (this.coef[1].abs() > 0.0) {
                    buffer.append(" + ");
                    if (this.coef[1].im() != 0.0) {
                        buffer.append(this.coef[1].toString());
                    } else {
                        buffer.append(this.coef[1].re());
                    }
                    buffer.append("*x");
                }
                int i = 2;
                while (i < NN) {
                    if (this.coef[i].abs() > 0.0) {
                        buffer.append(" + ");
                        if (this.coef[i].im() != 0.0) {
                            buffer.append(this.coef[i].toString());
                        } else {
                            buffer.append(this.coef[i].re());
                        }
                        buffer.append("*x^");
                        buffer.append(i);
                    }
                    ++i;
                }
            }
        } else {
            buffer.append("0.");
        }
        return buffer.toString();
    }

    public Object clone() {
        Polynomial newObject = null;
        try {
            newObject = (Polynomial)super.clone();
            int length = this.coef.length;
            newObject.coef = new Complex[length];
            int i = 0;
            while (i < length) {
                newObject.coef[i] = new Complex(this.coef[i].re(), this.coef[i].im());
                ++i;
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return newObject;
    }

    protected Complex[] cpoly(double[] Pr, double[] Pi) throws RootException {
        int i;
        int NN = Pr.length;
        int degree = NN - 1;
        if (Pr[0] == 0.0 && Pi[0] == 0.0) {
            throw new RootException("Leading coefficient is zero.");
        }
        double[] Hr = new double[NN];
        double[] Hi = new double[NN];
        double[] QPr = new double[NN];
        double[] QPi = new double[NN];
        double[] QHr = new double[NN];
        double[] QHi = new double[NN];
        double[] SHr = new double[NN];
        double[] SHi = new double[NN];
        Complex[] zeros = new Complex[degree];
        double XX = Math.sqrt(2.0) / 2.0;
        double YY = -XX;
        int idNN2 = 0;
        while (Pr[NN - 1] == 0.0 && Pi[NN - 1] == 0.0) {
            idNN2 = degree - NN + 1;
            zeros[idNN2] = new Complex(0.0, 0.0);
            --NN;
        }
        int i2 = 0;
        while (i2 < NN) {
            SHr[i2] = Polynomial.cmod(Pr[i2], Pi[i2]);
            ++i2;
        }
        double bound = Polynomial.scale(NN, SHr);
        if (bound != 1.0) {
            i = 0;
            while (i < NN) {
                int n = i;
                Pr[n] = Pr[n] * bound;
                int n2 = i++;
                Pi[n2] = Pi[n2] * bound;
            }
        }
        block3: while (true) {
            if (NN <= 2) {
                this.cdiv(-Pr[1], -Pi[1], Pr[0], Pi[0]);
                zeros[degree - 1] = new Complex(this.Tr, this.Ti);
                return zeros;
            }
            i = 0;
            while (i < NN) {
                SHr[i] = Polynomial.cmod(Pr[i], Pi[i]);
                ++i;
            }
            bound = Polynomial.cauchy(NN, SHr, SHi);
            int cnt1 = 0;
            while (cnt1 < 2) {
                this.noShift(NN, 5, Pr, Pi, Hr, Hi);
                int cnt2 = 0;
                while (cnt2 < 9) {
                    double XXX = -0.060756474 * XX - 0.99756405 * YY;
                    YY = 0.99756405 * XX - -0.060756474 * YY;
                    XX = XXX;
                    this.Sr = bound * XX;
                    this.Si = bound * YY;
                    boolean conv = this.fxShift(NN, 10 * cnt2, Pr, Pi, QPr, QPi, Hr, Hi, QHr, QHi, SHr, SHi);
                    if (conv) {
                        idNN2 = degree - NN + 1;
                        zeros[idNN2] = new Complex(this.Zr, this.Zi);
                        --NN;
                        int i3 = 0;
                        while (true) {
                            if (i3 >= NN) continue block3;
                            Pr[i3] = QPr[i3];
                            Pi[i3] = QPi[i3];
                            ++i3;
                        }
                    }
                    ++cnt2;
                }
                ++cnt1;
            }
            break;
        }
        throw new RootException("Found fewer than " + degree + " zeros.");
    }

    private void polyEv(int NN, double Sr, double Si, double[] Pr, double[] Pi, double[] Qr, double[] Qi) {
        double pvr = Qr[0] = Pr[0];
        double pvi = Qi[0] = Pi[0];
        int i = 1;
        while (i < NN) {
            double temp = pvr;
            pvr = pvr * Sr - pvi * Si + Pr[i];
            pvi = temp * Si + pvi * Sr + Pi[i];
            Qr[i] = pvr;
            Qi[i] = pvi;
            ++i;
        }
        this.PVr = pvr;
        this.PVi = pvi;
    }

    private static double errEv(int NN, double[] Qr, double[] Qi, double MS, double MP, double ARE, double MRE) {
        double E = Polynomial.cmod(Qr[0], Qi[0]) * MRE / (ARE + MRE);
        int i = 0;
        while (i < NN) {
            E = E * MS + Polynomial.cmod(Qr[i], Qi[i]);
            ++i;
        }
        return E * (ARE + MRE) - MP * MRE;
    }

    private static double cauchy(int NN, double[] PT, double[] Q) {
        double F;
        double XM;
        int NNm1 = NN - 1;
        PT[NNm1] = -PT[NNm1];
        int N = NN - 1;
        int Nm1 = N - 1;
        double X = Math.exp((Math.log(-PT[NNm1]) - Math.log(PT[0])) / (double)N);
        if (PT[Nm1] != 0.0 && (XM = -PT[NNm1] / PT[Nm1]) < X) {
            X = XM;
        }
        while (true) {
            XM = X * 0.1;
            F = PT[0];
            int i = 1;
            while (i < NN) {
                F = F * XM + PT[i];
                ++i;
            }
            if (F <= 0.0) break;
            X = XM;
        }
        double DX = X;
        while (Math.abs(DX / X) > 0.005) {
            Q[0] = PT[0];
            int i = 1;
            while (i < NN) {
                Q[i] = Q[i - 1] * X + PT[i];
                ++i;
            }
            F = Q[NNm1];
            double DF = Q[0];
            int i2 = 1;
            while (i2 < N) {
                DF = DF * X + Q[i2];
                ++i2;
            }
            DX = F / DF;
            X -= DX;
        }
        return X;
    }

    private static double scale(int NN, double[] PT) {
        double sc;
        double X;
        double hi = Math.sqrt(Double.MAX_VALUE);
        double lo = SMALNO / ETA;
        double max = 0.0;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < NN) {
            X = PT[i];
            if (X > max) {
                max = X;
            }
            if (X != 0.0 && X < min) {
                min = X;
            }
            ++i;
        }
        double scale = 1.0;
        if (min >= lo && max <= hi) {
            return scale;
        }
        X = lo / min;
        if (X > 1.0) {
            sc = X;
            if (Double.MAX_VALUE / sc > max) {
                sc = 1.0;
            }
        } else {
            sc = 1.0 / Math.sqrt(max * min);
        }
        double L = Math.log(sc) / Math.log(2.0) + 0.5;
        scale = Math.pow(2.0, L);
        return scale;
    }

    private void cdiv(double Ar, double Ai, double Br, double Bi) {
        if (Br == 0.0 && Bi == 0.0) {
            this.Tr = Double.MAX_VALUE;
            this.Ti = Double.MAX_VALUE;
            return;
        }
        if (Math.abs(Br) >= Math.abs(Bi)) {
            double R = Bi / Br;
            double D = Br + R * Bi;
            this.Tr = (Ar + Ai * R) / D;
            this.Ti = (Ai - Ar * R) / D;
        } else {
            double R = Br / Bi;
            double D = Bi + R * Br;
            this.Tr = (Ar * R + Ai) / D;
            this.Ti = (Ai * R - Ar) / D;
        }
    }

    private static double cmod(double re, double im) {
        double ans = 0.0;
        re = Math.abs(re);
        im = Math.abs(im);
        if (re == 0.0) {
            ans = im;
        } else if (im == 0.0) {
            ans = re;
        } else if (re > im) {
            double temp = im / re;
            ans = re * Math.sqrt(1.0 + temp * temp);
        } else {
            double temp = re / im;
            ans = im * Math.sqrt(1.0 + temp * temp);
        }
        return ans;
    }

    private void noShift(int NN, int L1, double[] Pr, double[] Pi, double[] Hr, double[] Hi) {
        int N = NN - 1;
        int Nm1 = N - 1;
        int NNm1 = NN - 1;
        int i = 0;
        while (i < N) {
            double XNi = NNm1 - i;
            Hr[i] = XNi * Pr[i] / (double)N;
            Hi[i] = XNi * Pi[i] / (double)N;
            ++i;
        }
        int jj = 0;
        while (jj < L1) {
            int j;
            int i2;
            if (Polynomial.cmod(Hr[Nm1], Hi[Nm1]) > ETA * 10.0 * Polynomial.cmod(Pr[Nm1], Pi[Nm1])) {
                this.cdiv(-Pr[NNm1], -Pi[NNm1], Hr[Nm1], Hi[Nm1]);
                i2 = 1;
                while (i2 <= Nm1) {
                    j = NNm1 - i2;
                    double T1 = Hr[j - 1];
                    double T2 = Hi[j - 1];
                    Hr[j] = this.Tr * T1 - this.Ti * T2 + Pr[j];
                    Hi[j] = this.Tr * T2 + this.Ti * T1 + Pi[j];
                    ++i2;
                }
                Hr[0] = Pr[0];
                Hi[0] = Pi[0];
            } else {
                i2 = 1;
                while (i2 <= Nm1) {
                    j = NNm1 - i2;
                    Hr[j] = Hr[j - 1];
                    Hi[j] = Hi[j - 1];
                    ++i2;
                }
                Hr[0] = 0.0;
                Hi[0] = 0.0;
            }
            ++jj;
        }
    }

    private boolean calcT(int NN, double Sr, double Si, double[] Hr, double[] Hi, double[] QHr, double[] QHi) {
        boolean bool;
        int N = NN - 1;
        int Nm1 = N - 1;
        double tempR = this.PVr;
        double tempI = this.PVi;
        this.polyEv(N, Sr, Si, Hr, Hi, QHr, QHi);
        double HVr = this.PVr;
        double HVi = this.PVi;
        this.PVr = tempR;
        this.PVi = tempI;
        boolean bl = bool = Polynomial.cmod(HVr, HVi) <= ARE * 10.0 * Polynomial.cmod(Hr[Nm1], Hi[Nm1]);
        if (bool) {
            this.Tr = 0.0;
            this.Ti = 0.0;
        } else {
            this.cdiv(-this.PVr, -this.PVi, HVr, HVi);
        }
        return bool;
    }

    private void nextH(int NN, boolean bool, double[] Hr, double[] Hi, double[] QPr, double[] QPi, double[] QHr, double[] QHi) {
        int N = NN - 1;
        if (!bool) {
            int j = 1;
            while (j < N) {
                double T1 = QHr[j - 1];
                double T2 = QHi[j - 1];
                Hr[j] = this.Tr * T1 - this.Ti * T2 + QPr[j];
                Hi[j] = this.Tr * T2 + this.Ti * T1 + QPi[j];
                ++j;
            }
            Hr[0] = QPr[0];
            Hi[0] = QPi[0];
        } else {
            int j = 1;
            while (j < N) {
                Hr[j] = QHr[j - 1];
                Hi[j] = QHi[j - 1];
                ++j;
            }
            Hr[0] = 0.0;
            Hi[0] = 0.0;
        }
    }

    private boolean vrShift(int NN, int L3, double[] Pr, double[] Pi, double[] QPr, double[] QPi, double[] Hr, double[] Hi, double[] QHr, double[] QHi) {
        boolean conv = false;
        boolean B = false;
        boolean bool = false;
        double OMP = 0.0;
        double RelSTP = 0.0;
        this.Sr = this.Zr;
        this.Si = this.Zi;
        int i = 0;
        while (i < L3) {
            this.polyEv(NN, this.Sr, this.Si, Pr, Pi, QPr, QPi);
            double MP = Polynomial.cmod(this.PVr, this.PVi);
            double MS = Polynomial.cmod(this.Sr, this.Si);
            if (MP <= 20.0 * Polynomial.errEv(NN, QPr, QPi, MS, MP, ARE, MRE)) {
                this.Zr = this.Sr;
                this.Zi = this.Si;
                return true;
            }
            if (i == 0) {
                OMP = MP;
            } else if (!B && MP >= OMP && RelSTP < 0.05) {
                double TP = RelSTP;
                B = true;
                if (RelSTP < ETA) {
                    TP = ETA;
                }
                double R1 = Math.sqrt(TP);
                double R2 = this.Sr * (1.0 + R1) - this.Si * R1;
                this.Si = this.Sr * R1 + this.Si * (1.0 + R1);
                this.Sr = R2;
                this.polyEv(NN, this.Sr, this.Si, Pr, Pi, QPr, QPi);
                int j = 0;
                while (j < 5) {
                    bool = this.calcT(NN, this.Sr, this.Si, Hr, Hi, QHr, QHi);
                    this.nextH(NN, bool, Hr, Hi, QPr, QPi, QHr, QHi);
                    ++j;
                }
                OMP = Double.MAX_VALUE;
            } else {
                if (MP * 0.1 > OMP) {
                    return conv;
                }
                OMP = MP;
            }
            bool = this.calcT(NN, this.Sr, this.Si, Hr, Hi, QHr, QHi);
            this.nextH(NN, bool, Hr, Hi, QPr, QPi, QHr, QHi);
            bool = this.calcT(NN, this.Sr, this.Si, Hr, Hi, QHr, QHi);
            if (!bool) {
                RelSTP = Polynomial.cmod(this.Tr, this.Ti) / Polynomial.cmod(this.Sr, this.Si);
                this.Sr += this.Tr;
                this.Si += this.Ti;
            }
            ++i;
        }
        return conv;
    }

    private boolean fxShift(int NN, int L2, double[] Pr, double[] Pi, double[] QPr, double[] QPi, double[] Hr, double[] Hi, double[] QHr, double[] QHi, double[] SHr, double[] SHi) {
        boolean conv = false;
        int N = NN - 1;
        this.polyEv(NN, this.Sr, this.Si, Pr, Pi, QPr, QPi);
        boolean test2 = true;
        boolean pasd = false;
        boolean bool = this.calcT(NN, this.Sr, this.Si, Hr, Hi, QHr, QHi);
        int j = 0;
        while (j < L2) {
            double OTr = this.Tr;
            double OTi = this.Ti;
            this.nextH(NN, bool, Hr, Hi, QPr, QPi, QHr, QHi);
            bool = this.calcT(NN, this.Sr, this.Si, Hr, Hi, QHr, QHi);
            this.Zr = this.Sr + this.Tr;
            this.Zi = this.Si + this.Ti;
            if (!bool && test2 && j != L2 - 1) {
                if (Polynomial.cmod(this.Tr - OTr, this.Ti - OTi) < 0.5 * Polynomial.cmod(this.Zr, this.Zi)) {
                    if (pasd) {
                        int i = 0;
                        while (i < N) {
                            SHr[i] = Hr[i];
                            SHi[i] = Hi[i];
                            ++i;
                        }
                        double SVSr = this.Sr;
                        double SVSi = this.Si;
                        conv = this.vrShift(NN, 10, Pr, Pi, QPr, QPi, Hr, Hi, QHr, QHi);
                        if (conv) {
                            return conv;
                        }
                        test2 = false;
                        int i2 = 0;
                        while (i2 < N) {
                            Hr[i2] = SHr[i2];
                            Hi[i2] = SHi[i2];
                            ++i2;
                        }
                        this.Sr = SVSr;
                        this.Si = SVSi;
                        this.polyEv(NN, this.Sr, this.Si, Pr, Pi, QPr, QPi);
                        bool = this.calcT(NN, this.Sr, this.Si, Hr, Hi, QHr, QHi);
                    } else {
                        pasd = true;
                    }
                } else {
                    pasd = false;
                }
            }
            ++j;
        }
        conv = this.vrShift(NN, 10, Pr, Pi, QPr, QPi, Hr, Hi, QHr, QHi);
        return conv;
    }
}

