/*
 * Decompiled with CFR 0.152.
 */
package fr.msimeon.mads.runModel.odfdom;

import fr.msimeon.mads.runModel.calc.InOut;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.style.Border;
import org.odftoolkit.simple.style.Font;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.CellRange;
import org.odftoolkit.simple.table.Column;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.table.TableContainer;

public class ODFSpreadsheet_IO {
    private String fSpec;
    public String h1StyleName = "h1StyleName";
    public String h2StyleName = "h2StyleName";
    public String emhStyleName = "emhStyleName";
    public String emlStyleName = "emlStyleName";
    public String tlStyleName = "tlStyleName";
    public String dStyleName = "dStyleName";
    public String defStyleName = "defStyleName";
    private SpreadsheetDocument odsDoc;
    private int error;
    Table table;
    public static final int FILE_CONNECT_ERROR = 2;
    public static final int UNABLE_TO_SAVE = 4;
    public static final int UNABLE_TO_CREATE_TABLE = 5;

    public ODFSpreadsheet_IO(String fSpec, String tableName, Boolean export, int initColNbr, int initRowNbr) {
        this.fSpec = fSpec;
        this.error = 0;
        try {
            this.odsDoc = (SpreadsheetDocument)Document.loadDocument((String)fSpec);
        }
        catch (Exception exception) {
            this.error = 2;
        }
        if (this.odsDoc != null) {
            if (export.booleanValue()) {
                this.table = this.odsDoc.getTableByName(tableName);
                if (this.table != null) {
                    this.table.remove();
                }
                try {
                    this.table = Table.newTable((TableContainer)this.odsDoc);
                    this.table.setTableName(tableName);
                }
                catch (Exception exception) {
                    this.error = 5;
                    this.odsDoc.close();
                    this.odsDoc = null;
                    return;
                }
                this.table.getCellByPosition(initColNbr, initRowNbr);
            } else {
                this.getTable(tableName);
            }
        }
    }

    public Boolean docOK() {
        if (this.odsDoc != null) {
            return true;
        }
        return false;
    }

    public int getError() {
        return this.error;
    }

    public Boolean save() {
        try {
            this.odsDoc.save(this.fSpec);
            return true;
        }
        catch (Exception exception) {
            this.error = 4;
            return false;
        }
    }

    public void close() {
        if (this.odsDoc != null) {
            this.odsDoc.close();
        }
    }

    public void getTable(String tName) {
        if (tName == null) {
            tName = "Sheet1";
        }
        this.table = this.odsDoc.getTableByName(tName);
        if (this.table == null) {
            InOut.showMessage("Mads Data Import", "Could not find table " + tName, true);
        }
    }

    public void setColWidth(int col, int width) {
        Column column = this.table.getColumnByIndex(col);
        Double d = (double)(width * 11) * 0.22;
        long w = d.longValue();
        column.setWidth((double)w);
    }

    public void setCell(int cellCol, int cellRow, int colSpan, int rowSpan, String hAlign, String vAlign, String dispText, String styleName, Double value, Boolean percentage) {
        this.setCell(cellCol, cellRow, colSpan, rowSpan, hAlign, vAlign, dispText, styleName, value, percentage, 2);
    }

    public void setCell(int cellCol, int cellRow, int colSpan, int rowSpan, String hAlign, String vAlign, String dispText, String styleName, Double value, Boolean percentage, int decDigits) {
        if (this.table != null) {
            if (colSpan < 1) {
                colSpan = 1;
            }
            if (rowSpan < 1) {
                rowSpan = 1;
            }
            Cell cell = this.table.getCellByPosition(cellCol, cellRow);
            Font font = cell.getFont();
            if (styleName.equalsIgnoreCase(this.h1StyleName)) {
                font.setSize(12.0);
            } else {
                font.setSize(11.0);
            }
            if (styleName.equalsIgnoreCase(this.h1StyleName) || styleName.equalsIgnoreCase(this.h2StyleName) || styleName.equalsIgnoreCase(this.tlStyleName)) {
                font.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
            } else if (styleName.equalsIgnoreCase(this.emhStyleName) || styleName.equalsIgnoreCase(this.emlStyleName)) {
                font.setFontStyle(StyleTypeDefinitions.FontStyle.ITALIC);
            } else {
                font.setFontStyle(StyleTypeDefinitions.FontStyle.REGULAR);
            }
            cell.setFont(font);
            Color color = new Color("#000000");
            Border border = new Border(color, 1.0, StyleTypeDefinitions.SupportedLinearMeasure.PT);
            if (styleName.equalsIgnoreCase(this.emlStyleName) || styleName.equalsIgnoreCase(this.tlStyleName) || styleName.equalsIgnoreCase(this.dStyleName)) {
                cell.setBorders(StyleTypeDefinitions.CellBordersType.ALL_FOUR, border);
            } else {
                cell.setBorders(StyleTypeDefinitions.CellBordersType.NONE, border);
            }
            StyleTypeDefinitions.HorizontalAlignmentType hAlignType = hAlign == null ? StyleTypeDefinitions.HorizontalAlignmentType.DEFAULT : (hAlign.equals("center") ? StyleTypeDefinitions.HorizontalAlignmentType.CENTER : (hAlign.equals("left") ? StyleTypeDefinitions.HorizontalAlignmentType.LEFT : (hAlign.equals("right") ? StyleTypeDefinitions.HorizontalAlignmentType.RIGHT : StyleTypeDefinitions.HorizontalAlignmentType.DEFAULT)));
            StyleTypeDefinitions.VerticalAlignmentType vAlignType = vAlign == null ? StyleTypeDefinitions.VerticalAlignmentType.DEFAULT : (vAlign.equals("middle") ? StyleTypeDefinitions.VerticalAlignmentType.MIDDLE : (vAlign.equals("top") ? StyleTypeDefinitions.VerticalAlignmentType.TOP : (vAlign.equals("bottom") ? StyleTypeDefinitions.VerticalAlignmentType.BOTTOM : StyleTypeDefinitions.VerticalAlignmentType.DEFAULT)));
            cell.setHorizontalAlignment(hAlignType);
            cell.setVerticalAlignment(vAlignType);
            CellRange range = this.table.getCellRangeByPosition(cellCol, cellRow, cellCol + colSpan - 1, cellRow + rowSpan - 1);
            range.merge();
            if (dispText != null) {
                cell.setStringValue(dispText);
            } else if (percentage.booleanValue()) {
                cell.setPercentageValue(value);
            } else {
                String f = "#,##0";
                if (decDigits > 0) {
                    f = String.valueOf(f) + ".";
                    int i = 0;
                    while (i < decDigits) {
                        f = String.valueOf(f) + "0";
                        ++i;
                    }
                }
                cell.setDoubleValue(value);
                cell.setFormatString(f);
            }
        }
    }

    public CellRange getRange(String vName) {
        if (this.table == null) {
            return null;
        }
        CellRange cellRange = this.table.getCellRangeByName(vName);
        if (cellRange == null) {
            InOut.showMessage("Mads Data IO", "Could not find cell range " + vName, true);
        }
        return cellRange;
    }

    public Double[] getValues(CellRange cellRange) {
        if (cellRange == null) {
            return null;
        }
        int colNbr = cellRange.getColumnNumber();
        Double[] data = new Double[colNbr];
        int i = 0;
        while (i < colNbr) {
            Cell cell = cellRange.getCellByPosition(i, 0);
            try {
                data[i] = cell.getDoubleValue();
            }
            catch (Exception exception) {
                data[i] = Double.NaN;
            }
            ++i;
        }
        return data;
    }

    public void setValues(double[] data, CellRange cellRange) {
        if (cellRange == null) {
            return;
        }
        int dlength = data.length;
        int colNbr = cellRange.getColumnNumber();
        int i = 0;
        while (i < colNbr) {
            Cell cell = cellRange.getCellByPosition(i, 0);
            if (i < dlength - 1) {
                cell.setDoubleValue(Double.valueOf(data[i + 1]));
            } else {
                cell.setDoubleValue(Double.valueOf(data[dlength - 1]));
            }
            ++i;
        }
    }

    public static Double[] getValues(String fSpec, String tName, String vName) {
        CellRange cellRange;
        ODFSpreadsheet_IO ods = new ODFSpreadsheet_IO(fSpec, tName, false, 0, 0);
        Double[] data = ods.getValues(cellRange = ods.getRange(vName));
        if (data != null) {
            ODFSpreadsheet_IO.list(data);
        }
        ods.close();
        return data;
    }

    public static void setValues(double[] data, String fSpec, String tName, String vName) {
        ODFSpreadsheet_IO ods = new ODFSpreadsheet_IO(fSpec, tName, false, 0, 0);
        CellRange cellRange = ods.getRange(vName);
        ods.setValues(data, cellRange);
        ods.save();
        ods.close();
    }

    public static void main(String[] args) {
        String fSpec = "c:/Users/msimeon/Documents/test2.ods";
        String tName = "S1";
        String vName2 = "ExportTest";
        double[] data = new double[]{0.0, 1.1, 2.9, 3.3, 4.4, 5.5, 6.6, 7.7, 8.8};
        ODFSpreadsheet_IO.setValues(data, fSpec, tName, vName2);
        Double[] data1 = ODFSpreadsheet_IO.getValues(fSpec, tName, vName2);
        int i = 0;
        while (i < data1.length) {
            System.out.print(data1[i] + " ");
            ++i;
        }
        System.out.println();
        String tExpName = "IRR";
        String fSpec2 = "c:/Users/msimeon/Documents/table_export_test.ods";
        ODFSpreadsheet_IO ods = new ODFSpreadsheet_IO(fSpec2, tExpName, true, 10, 10);
        ods.setCell(0, 0, 3, 0, "center", "middle", "bla bla blop \nblurrrrp", ods.h1StyleName, null, null);
        ods.setCell(0, 2, 3, 0, "center", "middle", "bla bla blop \nblurrrrp", ods.h1StyleName, null, null);
        ods.setCell(0, 3, 0, 0, "left", "bottom", "using setSpanned ...", ods.emhStyleName, null, null);
        ods.setColWidth(20, 30);
        ods.save();
        ods.close();
    }

    private static void list(Double[] data) {
        int i = 0;
        while (i < data.length) {
            System.out.print(data[i] + "  ");
            ++i;
        }
        System.out.println("\n");
    }
}

